/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.model;

import com.ibm.team.enterprise.systemdefinition.common.model.IAntSnippetNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class AntSnippetNode
implements IAntSnippetNode {
    protected boolean isTask;
    protected String fName;
    protected Map<String, String> fAttributes;
    protected List<IAntSnippetNode> fChildrenNodes;
    protected String fText;

    public AntSnippetNode(String name, boolean isTask) {
        this.fName = name;
        this.isTask = isTask;
        this.fChildrenNodes = new ArrayList<IAntSnippetNode>();
    }

    public AntSnippetNode(Element element, boolean isTask) {
        this(element.getNodeName(), isTask);
    }

    @Override
    public boolean isTask() {
        return this.isTask;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.fAttributes == null) {
            return Collections.emptyMap();
        }
        return this.fAttributes;
    }

    @Override
    public List<IAntSnippetNode> getChildrenNodes() {
        return this.fChildrenNodes;
    }

    public void addChildNode(AntSnippetNode node) {
        this.fChildrenNodes.add(node);
    }

    public void addAttribute(String name, String value) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, String>();
        }
        this.fAttributes.put(name, value);
    }

    public void setText(String text) {
        this.fText = text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAntSnippetNode getNode(int offset) {
        AntSnippetNode antSnippetNode = this;
        synchronized (antSnippetNode) {
            if (this.fChildrenNodes != null) {
                for (AntSnippetNode antSnippetNode2 : this.fChildrenNodes) {
                    IAntSnippetNode containingNode = antSnippetNode2.getNode(offset);
                    if (containingNode == null) continue;
                    return containingNode;
                }
            }
        }
        return null;
    }

    public void setIsTask(boolean isTask) {
        this.isTask = isTask;
    }

    @Override
    public String getText() {
        return this.fText;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(this.getName());
        Map<String, String> atts = this.getAttributes();
        for (Map.Entry<String, String> att : atts.entrySet()) {
            buffer.append(" ");
            buffer.append(att.getKey());
            buffer.append("=");
            buffer.append(att.getValue());
        }
        if (this.fChildrenNodes.isEmpty()) {
            buffer.append("/>");
        } else {
            buffer.append(">");
        }
        return buffer.toString();
    }
}

