/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.model;

import com.ibm.team.enterprise.systemdefinition.common.internal.model.AntSnippetNode;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.AntSnippetTarget;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IAntSnippetDocument;
import com.ibm.team.enterprise.systemdefinition.common.model.IAntSnippetModel;
import com.ibm.team.enterprise.systemdefinition.common.model.IAntSnippetNode;
import com.ibm.team.enterprise.systemdefinition.common.model.IAntSnippetTarget;
import com.ibm.team.enterprise.systemdefinition.common.model.ISnippetProblemCollector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractAntSnippetModel
implements IAntSnippetModel {
    private static final String[] DELIMITERS = new String[]{"\n", "\r", "\r\n"};
    protected static final String XML_ROOT_FAKE_START = "<rtcee>";
    protected static final int XML_ROOT_FAKE_START_LOCATOR_DEV = 7;
    protected static final String XML_ROOT_FAKE_END = "</rtcee>";
    protected static final String XML_ROOT_FAKE_NAME = "rtcee";
    protected ISnippetProblemCollector fCollector;
    protected AntSnippetTarget fTarget;
    private static final String[] forbiddenTopElements = new String[]{"project", "description", "taskdef"};
    private boolean fShouldReconcile = true;

    protected AbstractAntSnippetModel() {
    }

    private void beginReporting() {
        if (this.fCollector != null) {
            this.fCollector.prepare();
        }
    }

    @Override
    public abstract void dispose();

    @Override
    public abstract Object getSnippetDocument();

    @Override
    public IAntSnippetNode getNode(int offset, boolean waitForReconcile) {
        if (this.getTargetNode(waitForReconcile) != null) {
            return this.getTargetNode(waitForReconcile).getNode(offset);
        }
        return null;
    }

    @Override
    public IAntSnippetTarget getTargetNode() {
        return this.getTargetNode(true);
    }

    @Override
    public AntSnippetTarget getTargetNode(boolean doReconcile) {
        if (doReconcile) {
            this.reconcile();
        }
        return this.fTarget;
    }

    @Override
    public abstract String getText(int var1, int var2);

    private void handleError(Exception e) {
        this.handleError(e.getMessage(), null);
    }

    protected abstract void handleError(String var1, Locator var2);

    private boolean isForbiddenTopElem(String elemName) {
        String[] stringArray = forbiddenTopElements;
        int n = forbiddenTopElements.length;
        int n2 = 0;
        while (n2 < n) {
            String forbiddenElemen = stringArray[n2];
            if (forbiddenElemen.equals(elemName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final void parseAntDocument(IAntSnippetDocument input) {
        if (input.getLength() == 0) {
            return;
        }
        this.parseDocument(input.get().trim());
    }

    private void parseDocument(String inputText) {
        if (inputText == null || inputText.isEmpty()) {
            this.handleError("A non-empty snippet is expected", null);
            if (this.fCollector != null) {
                this.fCollector.collect();
            }
        } else {
            Enumeration<InputStream> streams = Collections.enumeration(Arrays.asList(new ByteArrayInputStream(XML_ROOT_FAKE_START.getBytes()), new ByteArrayInputStream(inputText.getBytes()), new ByteArrayInputStream(XML_ROOT_FAKE_END.getBytes())));
            SequenceInputStream seqStream = new SequenceInputStream(streams);
            try {
                try {
                    SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                    parserFactory.setValidating(false);
                    SAXParser parser = parserFactory.newSAXParser();
                    this.beginReporting();
                    parser.parse((InputStream)seqStream, (DefaultHandler)new AntSnippetHandler());
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.handleError(e);
                    if (this.fCollector != null) {
                        this.fCollector.collect();
                    }
                }
            }
            finally {
                if (this.fCollector != null) {
                    this.fCollector.collect();
                }
            }
        }
    }

    protected final void parseRawSnippet(String inputText) {
        this.parseDocument(inputText.trim());
    }

    @Override
    public abstract void reconcile();

    @Override
    public void setShouldReconcile(boolean shouldReconcile) {
        this.fShouldReconcile = shouldReconcile;
        if (this.fShouldReconcile) {
            this.reconcile();
        }
    }

    private class AntSnippetHandler
    extends DefaultHandler {
        private final Stack<AntSnippetNode> elements = new Stack();
        private final StringBuilder elementText = new StringBuilder();
        private Locator locator;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equals(AbstractAntSnippetModel.XML_ROOT_FAKE_NAME)) {
                SAXParseException e;
                this.accumulateText();
                AntSnippetNode node = null;
                if (AbstractAntSnippetModel.this.isForbiddenTopElem(qName) && (AbstractAntSnippetModel.this.fTarget == null || AbstractAntSnippetModel.this.fTarget.getChildrenNodes().isEmpty())) {
                    e = new SAXParseException(Messages.AbstractAntSnippetModel_FORBIDDEN_SNIPPET_CONTENT_ERROR, this.locator);
                    this.error(e);
                }
                if (qName.equals("target")) {
                    if (AbstractAntSnippetModel.this.fTarget == null) {
                        String name = attributes.getValue(null, "name");
                        String targetName = name == null ? "default" : name;
                        AbstractAntSnippetModel.this.fTarget = new AntSnippetTarget(targetName, false);
                    } else {
                        e = new SAXParseException(Messages.AbstractAntSnippetModel_SEVERAL_TARGETS_ERROR, this.locator);
                        this.error(e);
                    }
                } else {
                    if (AbstractAntSnippetModel.this.fTarget == null) {
                        AbstractAntSnippetModel.this.fTarget = new AntSnippetTarget("default", true);
                    }
                    node = new AntSnippetNode(qName, false);
                    int i = 0;
                    while (i < attributes.getLength()) {
                        String attName = attributes.getQName(i);
                        String attValue = attributes.getValue(i);
                        node.addAttribute(attName, attValue);
                        ++i;
                    }
                }
                if (node == null) {
                    if (AbstractAntSnippetModel.this.fTarget == null) {
                        SAXParseException e2 = new SAXParseException(Messages.AbstractAntSnippetModel_ORPHANED_ELEMENT_ERROR, this.locator);
                        this.fatalError(e2);
                    }
                } else {
                    this.elements.push(node);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String readStr = new String(ch, start, length);
            if (!Arrays.asList(DELIMITERS).contains(readStr) && !readStr.matches("\\s+")) {
                this.elementText.append(readStr);
                if (this.elements.isEmpty()) {
                    SAXParseException e = new SAXParseException(Messages.AbstractAntSnippetModel_ORPHANED_TEXTELEMENT_ERROR, this.locator);
                    this.fatalError(e);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!qName.equals(AbstractAntSnippetModel.XML_ROOT_FAKE_NAME)) {
                this.accumulateText();
                if (AbstractAntSnippetModel.this.fTarget != null) {
                    AbstractAntSnippetModel.this.fTarget.getName().equals(qName);
                }
                if (!this.elements.empty()) {
                    AntSnippetNode self = this.elements.pop();
                    if (this.elements.isEmpty() || this.elements.peek().getName().equals(AbstractAntSnippetModel.XML_ROOT_FAKE_NAME)) {
                        self.setIsTask(true);
                        AbstractAntSnippetModel.this.fTarget.addChildNode(self);
                    } else if (!this.elements.empty()) {
                        AntSnippetNode parent = this.elements.peek();
                        parent.addChildNode(self);
                    }
                } else {
                    throw new SAXParseException(NLS.bind((String)Messages.AbstractAntSnippetModel_WRONG_CLOSED_ELEMENT, (Object)qName), this.locator);
                }
            }
        }

        private void accumulateText() {
            if (this.elementText.length() > 0 && !this.elements.isEmpty()) {
                AntSnippetNode node = this.elements.peek();
                node.setText(this.elementText.toString());
                this.elementText.delete(0, this.elementText.length());
            }
        }

        @Override
        public void error(SAXParseException e) {
            AbstractAntSnippetModel.this.handleError(e.getMessage(), this.locator);
        }

        @Override
        public void fatalError(SAXParseException e) {
            AbstractAntSnippetModel.this.handleError(e.getMessage(), this.locator);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

