/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.impl.VersionDefinitionImpl;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.LevelStatus;
import com.ibm.team.enterprise.systemdefinition.common.model.LevelType;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingElements;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingVersion;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionLogString;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.ItemHandle;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PackagingVersion
extends VersionDefinitionImpl
implements IVersionDefinition,
IPackagingVersion {
    private final IDebugger dbg;
    private final String simpleName;

    public PackagingVersion() {
        this((IDebugger)new Debugger(PackagingVersion.class));
    }

    public PackagingVersion(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.initNew();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingVersion(IVersionDefinition packagingVersion) {
        this(packagingVersion, (IDebugger)new Debugger(PackagingVersion.class));
    }

    public PackagingVersion(IVersionDefinition packagingVersion, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.copy(packagingVersion);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IPackagingVersion copy(IVersionDefinition original) {
        if (original == null) {
            this.initNew();
            this.setDescription("");
            this.setName("");
            this.setBaseFmid(IPackagingElements.EDEFAULT_VERSION_BASEFMID);
            this.setBaseFunction(IPackagingElements.EDEFAULT_VERSION_BASEFUNCTION);
            this.setChangeTeam("");
            this.setComponentId("");
            this.setComponentPrefix("");
            this.setCopyright("");
            this.setDefaultFunction(IPackagingElements.EDEFAULT_VERSION_DEFAULTFUNCTION);
            this.setExtendedService(false);
            this.setFullyResolved(false);
            this.setGenerallyAvailable(false);
            this.setId("");
            this.setLevelCreated(IPackagingElements.EDEFAULT_VERSION_LEVELCREATED);
            this.setLevelCreatedBy(IPackagingElements.EDEFAULT_VERSION_LEVELCREATEDBY);
            this.setLevelStatus(IPackagingElements.EDEFAULT_VERSION_LEVELSTATUS);
            this.setLevelSupFile("");
            this.setLevelSupList("");
            this.setLevelType(IPackagingElements.EDEFAULT_VERSION_LEVELTYPE);
            this.setNeverSup(false);
            this.setOutOfService(false);
            this.setSaveRequired(false);
            this.setSingleFunction(false);
            this.setSystemRelease("");
            this.setUsermodPrefix("");
        } else {
            this.setArchived(original.isArchived());
            this.setContextId(original.getContextId());
            this.setDescription(original.getDescription());
            this.setIgnoredOnceForBuild(original.isIgnoredOnceForBuild());
            this.setImmutable(original.isImmutable());
            this.setItemId(original.getItemId());
            this.setMigratedItemId(original.getMigratedItemId());
            this.setMigratedStateId(original.getMigratedStateId());
            this.setModifiedBy(original.getModifiedBy());
            this.setModified(original.getRequestedModified());
            this.setName(original.getName());
            this.setNonImpacting(original.isNonImpacting());
            this.setOrigin(original.getOrigin());
            this.setProjectArea(original.getProjectArea());
            this.setRedactedCopy(original.isRedactedCopy());
            this.setStateId(original.getStateId());
            this.setWorkingCopy(original.isWorkingCopy());
            this.setBaseFmid(original.getBaseFmid());
            this.setBaseFunction(original.getBaseFunction());
            this.setChangeTeam(original.getChangeTeam());
            this.setComponentId(original.getComponentId());
            this.setComponentPrefix(original.getComponentPrefix());
            this.setCopyright(original.getCopyright());
            this.setDefaultFunction(original.getDefaultFunction());
            this.setExtendedService(original.isExtendedService());
            this.setFullyResolved(original.isFullyResolved());
            this.setGenerallyAvailable(original.isGenerallyAvailable());
            this.setId(original.getId());
            this.setLevelCreated(original.getLevelCreated());
            this.setLevelCreatedBy(original.getLevelCreatedBy());
            this.setLevelStatus(original.getLevelStatus());
            this.setLevelSupFile(original.getLevelSupFile());
            this.setLevelSupList(original.getLevelSupList());
            this.setLevelType(original.getLevelType());
            this.setNeverSup(original.isNeverSup());
            this.setOutOfService(original.isOutOfService());
            this.setReleaseId(original.getReleaseId());
            this.setSaveRequired(original.isSaveRequired());
            this.setSingleFunction(original.isSingleFunction());
            this.setSystemRelease(original.getSystemRelease());
            this.setUsermodPrefix(original.getUsermodPrefix());
            this.getFmidItemDefinitions().addAll(original.getFmidItemDefinitions());
            this.getFmidItemStates().putAll(original.getFmidItemStates());
            this.getScopedProperties().addAll(new EcoreUtil.Copier().copyAll(original.getScopedProperties()));
            if (this.isWorkingCopy()) {
                PackagingVersion auditableThis = this;
                Auditable auditableThat = (Auditable)original;
                auditableThis.setWorkingCopyPredecessor(auditableThat.getWorkingCopyPredecessor());
                auditableThis.setWorkingCopyMergePredecessor(auditableThat.getWorkingCopyMergePredecessor());
                auditableThis.setPredecessor(auditableThat.getPredecessor());
                auditableThis.setMergePredecessor(auditableThat.getMergePredecessor());
                this.protect();
            }
        }
        return this;
    }

    @Override
    public final IPackagingVersion newCopy() {
        return new PackagingVersion(this);
    }

    @Override
    public final ISystemDefinition newInstance() {
        return new PackagingVersion();
    }

    @Override
    public final IPackagingVersion update(IVersionDefinition updated) {
        this.setArchived(updated.isArchived());
        this.setContextId(updated.getContextId());
        this.setDescription(updated.getDescription());
        this.setIgnoredOnceForBuild(updated.isIgnoredOnceForBuild());
        this.setItemId(updated.getItemId());
        this.setMigratedItemId(updated.getMigratedItemId());
        this.setMigratedStateId(updated.getMigratedStateId());
        this.setName(updated.getName());
        this.setNonImpacting(updated.isNonImpacting());
        this.setOrigin(updated.getOrigin());
        this.setProjectArea(updated.getProjectArea());
        this.setStateId(updated.getStateId());
        this.setBaseFmid(updated.getBaseFmid());
        this.setBaseFunction(updated.getBaseFunction());
        this.setChangeTeam(updated.getChangeTeam());
        this.setComponentId(updated.getComponentId());
        this.setComponentPrefix(updated.getComponentPrefix());
        this.setCopyright(updated.getCopyright());
        this.setDefaultFunction(updated.getDefaultFunction());
        this.setExtendedService(updated.isExtendedService());
        this.setFullyResolved(updated.isFullyResolved());
        this.setGenerallyAvailable(updated.isGenerallyAvailable());
        this.setId(updated.getId());
        this.setLevelCreated(updated.getLevelCreated());
        this.setLevelCreatedBy(updated.getLevelCreatedBy());
        this.setLevelStatus(updated.getLevelStatus());
        this.setLevelSupFile(updated.getLevelSupFile());
        this.setLevelSupList(updated.getLevelSupList());
        this.setLevelType(updated.getLevelType());
        this.setNeverSup(updated.isNeverSup());
        this.setOutOfService(updated.isOutOfService());
        this.setReleaseId(updated.getReleaseId());
        this.setSaveRequired(updated.isSaveRequired());
        this.setSingleFunction(updated.isSingleFunction());
        this.setSystemRelease(updated.getSystemRelease());
        this.setUsermodPrefix(updated.getUsermodPrefix());
        if (ItemUtil.isProtected((ItemHandle)this)) {
            ItemUtil.unprotect((ItemHandle)this);
            this.getFmidItemDefinitions().clear();
            this.getFmidItemDefinitions().addAll(updated.getFmidItemDefinitions());
            this.getFmidItemStates().clear();
            this.getFmidItemStates().putAll(updated.getFmidItemStates());
            this.getScopedProperties().clear();
            this.getScopedProperties().addAll(new EcoreUtil.Copier().copyAll(updated.getScopedProperties()));
            this.protect();
        } else {
            this.getFmidItemDefinitions().clear();
            this.getFmidItemDefinitions().addAll(updated.getFmidItemDefinitions());
            this.getFmidItemStates().clear();
            this.getFmidItemStates().putAll(updated.getFmidItemStates());
            this.getScopedProperties().clear();
            this.getScopedProperties().addAll(new EcoreUtil.Copier().copyAll(updated.getScopedProperties()));
        }
        return this;
    }

    @Override
    public final boolean hasDescription() {
        return Verification.isNonBlank((String)this.description);
    }

    @Override
    public final boolean hasName() {
        return Verification.isNonBlank((String)this.name);
    }

    @Override
    public final boolean hasBaseFmid() {
        return Verification.isNonNull((Object)this.baseFmid);
    }

    @Override
    public final boolean hasBaseFunction() {
        return Verification.isNonNull((Object)this.baseFunction);
    }

    @Override
    public boolean hasChangeTeam() {
        return Verification.isNonBlank((String)this.changeTeam);
    }

    @Override
    public final boolean hasComponentId() {
        return Verification.isNonBlank((String)this.componentId);
    }

    @Override
    public final boolean hasComponentPrefix() {
        return Verification.isNonBlank((String)this.componentPrefix);
    }

    @Override
    public final boolean hasCopyright() {
        return Verification.isNonBlank((String)this.copyright);
    }

    @Override
    public final boolean hasDefaultFunction() {
        return Verification.isNonNull((Object)this.defaultFunction);
    }

    @Override
    public final boolean hasId() {
        return Verification.isNonBlank((String)this.id);
    }

    @Override
    public boolean hasLevelCreated() {
        return Verification.isNonNull((Object)this.levelCreated);
    }

    @Override
    public boolean hasLevelCreatedBy() {
        return Verification.isNonNull((Object)this.levelCreatedBy);
    }

    @Override
    public boolean hasLevelStatus() {
        return Verification.isNonNull((Object)((Object)this.levelStatus));
    }

    @Override
    public boolean hasLevelSupFile() {
        return Verification.isNonBlank((String)this.levelSupFile);
    }

    @Override
    public boolean hasLevelSupList() {
        return Verification.isNonBlank((String)this.levelSupList);
    }

    @Override
    public boolean hasLevelType() {
        return Verification.isNonNull((Object)((Object)this.levelType));
    }

    @Override
    public boolean hasReleaseId() {
        return Verification.isNonBlank((String)this.releaseId);
    }

    @Override
    public final boolean hasSystemRelease() {
        return Verification.isNonBlank((String)this.systemRelease);
    }

    @Override
    public final boolean hasUsermodPrefix() {
        return Verification.isNonBlank((String)this.usermodPrefix);
    }

    @Override
    public final boolean hasFmidItemDefinitions() {
        return Verification.isNonEmpty((List)this.fmidItemDefinitions);
    }

    @Override
    public final boolean hasScopedProperties() {
        return Verification.isNonEmpty((List)this.scopedProperties);
    }

    @Override
    public final void setBaseFunction(IFunctionDefinitionHandle baseFunction) {
        super.setBaseFunction(baseFunction);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), SystemDefinitionLogString.valueOf(baseFunction)});
        }
    }

    @Override
    public final void setChangeTeam(String changeTeam) {
        super.setChangeTeam(changeTeam);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)changeTeam)});
        }
    }

    @Override
    public final void setComponentId(String componentId) {
        super.setComponentId(componentId);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)componentId)});
        }
    }

    @Override
    public final void setComponentPrefix(String componentPrefix) {
        super.setComponentPrefix(componentPrefix);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)componentPrefix)});
        }
    }

    @Override
    public final void setCopyright(String copyright) {
        super.setCopyright(copyright);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)copyright)});
        }
    }

    @Override
    public final void setDefaultFunction(IFunctionDefinitionHandle defaultFunction) {
        super.setDefaultFunction(defaultFunction);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), SystemDefinitionLogString.valueOf(defaultFunction)});
        }
    }

    @Override
    public final void setExtendedService(boolean extendedService) {
        super.setExtendedService(extendedService);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)extendedService)});
        }
    }

    @Override
    public final void setFullyResolved(boolean fullyResolved) {
        super.setFullyResolved(fullyResolved);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)fullyResolved)});
        }
    }

    @Override
    public final void setGenerallyAvailable(boolean generallyAvailable) {
        super.setGenerallyAvailable(generallyAvailable);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)generallyAvailable)});
        }
    }

    @Override
    public final void setId(String id) {
        super.setId(id);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)id)});
        }
    }

    @Override
    public final void setLevelCreated(Timestamp levelCreated) {
        super.setLevelCreated(levelCreated);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Date)levelCreated)});
        }
    }

    @Override
    public final void setLevelCreatedBy(IContributorHandle levelCreatedBy) {
        super.setLevelCreatedBy(levelCreatedBy);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)levelCreatedBy)});
        }
    }

    @Override
    public final void setLevelStatus(LevelStatus levelStatus) {
        super.setLevelStatus(levelStatus);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Object)((Object)levelStatus))});
        }
    }

    @Override
    public final void setLevelSupFile(String levelSupFile) {
        super.setLevelSupFile(levelSupFile);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)levelSupFile)});
        }
    }

    @Override
    public final void setLevelSupList(String levelSupList) {
        super.setLevelSupList(levelSupList);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)levelSupList)});
        }
    }

    @Override
    public final void setLevelType(LevelType levelType) {
        super.setLevelType(levelType);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Object)((Object)levelType))});
        }
    }

    @Override
    public final void setNeverSup(boolean neverSup) {
        super.setNeverSup(neverSup);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)neverSup)});
        }
    }

    @Override
    public final void setOutOfService(boolean outOfService) {
        super.setOutOfService(outOfService);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)outOfService)});
        }
    }

    @Override
    public final void setReleaseId(String releaseId) {
        super.setReleaseId(releaseId);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)releaseId)});
        }
    }

    @Override
    public final void setSaveRequired(boolean saveRequired) {
        super.setSaveRequired(saveRequired);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)saveRequired)});
        }
    }

    @Override
    public final void setSingleFunction(boolean singleFunction) {
        super.setSingleFunction(singleFunction);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)singleFunction)});
        }
    }

    @Override
    public final void setSystemRelease(String systemRelease) {
        super.setSystemRelease(systemRelease);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)systemRelease)});
        }
    }

    @Override
    public final void setUsermodPrefix(String usermodPrefix) {
        super.setUsermodPrefix(usermodPrefix);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)usermodPrefix)});
        }
    }
}

