/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.AbstractPackagingItemCommon;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.Packaging;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingDetailFile;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingDetailLanguage;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemFileDefaults;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingProperties;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.scm.common.IVersionable;
import java.util.ArrayList;
import java.util.List;

public class PackagingItemFile
extends AbstractPackagingItemCommon
implements IPackagingItemDefinition,
IPackagingItem {
    private final IPackagingItem fileItem;
    private IVersionable fileVersionable = IPackagingProperties.EDEFAULT_FILEITEM_FILEVERSIONABLE;
    private String fileName = IPackagingProperties.EDEFAULT_FILEITEM_FILENAME;
    private Boolean jclin = IPackagingProperties.EDEFAULT_FILEITEM_JCLIN;

    public PackagingItemFile(IPackagingItem packagingItem) {
        this(packagingItem, packagingItem.getDbg());
    }

    public PackagingItemFile(IPackagingItem packagingItem, IDebugger dbg) {
        super(packagingItem, new PackagingItemFileDefaults());
        this.fileItem = this;
        this.setItemId(packagingItem.getItemId());
        this.setOrigin(packagingItem.getOrigin());
        this.setProjectArea(packagingItem.getProjectArea());
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingItemFile(IPackagingItem packagingItem, IPackagingItem original) {
        this(packagingItem, original, packagingItem.getDbg());
    }

    public PackagingItemFile(IPackagingItem packagingItem, IPackagingItem original, IDebugger dbg) {
        super(packagingItem, original, new PackagingItemFileDefaults());
        this.fileItem = this;
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IPackagingItem copy(IPackagingItemDefinition original) {
        if (original == null) {
            this.initNew();
            this.setDescription(IPackagingProperties.EDEFAULT_FILEITEM_DESCRIPTION);
            this.setName(IPackagingProperties.EDEFAULT_FILEITEM_NAME);
            this.setFileName(IPackagingProperties.EDEFAULT_FILEITEM_FILENAME);
            this.setFileVersionable(IPackagingProperties.EDEFAULT_FILEITEM_FILEVERSIONABLE);
            this.setJclin(IPackagingProperties.EDEFAULT_FILEITEM_JCLIN);
            this.setIgnore(IPackagingProperties.EDEFAULT_FILEITEM_IGNORE);
            this.setAlias(IPackagingProperties.EDEFAULT_FILEITEM_ALIAS);
            this.setClazz(IPackagingProperties.EDEFAULT_FILEITEM_CLASS);
            this.setCsect(IPackagingProperties.EDEFAULT_FILEITEM_CSECT);
            this.setDeleted(IPackagingProperties.EDEFAULT_FILEITEM_DELETED);
            this.setDisttype(IPackagingProperties.EDEFAULT_FILEITEM_DISTTYPE);
            this.setFmid(IPackagingProperties.EDEFAULT_FILEITEM_FMID);
            this.setHfsdata(IPackagingProperties.EDEFAULT_FILEITEM_HFSDATA);
            this.setHfspath(IPackagingProperties.EDEFAULT_FILEITEM_HFSPATH);
            this.setLeparm(IPackagingProperties.EDEFAULT_FILEITEM_LEPARM);
            this.setMcsclass(IPackagingProperties.EDEFAULT_FILEITEM_MCSCLASS);
            this.setModule(IPackagingProperties.EDEFAULT_FILEITEM_MODULE);
            this.setOriginalFmid(IPackagingProperties.EDEFAULT_FILEITEM_ORIGINALFMID);
            this.setOriginalStateId(IPackagingProperties.EDEFAULT_FILEITEM_ORIGINALSTATEID);
            this.setTransform(IPackagingProperties.EDEFAULT_FILEITEM_TRANSFORM);
            this.setUpdated(IPackagingProperties.EDEFAULT_FILEITEM_UPDATED);
            this.setVpl(IPackagingProperties.EDEFAULT_FILEITEM_VPL);
        } else {
            this.setArchived(original.isArchived());
            this.setContextId(original.getContextId());
            this.setIgnoredOnceForBuild(original.isIgnoredOnceForBuild());
            this.setImmutable(original.isImmutable());
            this.setItemId(original.getItemId());
            this.setMigratedItemId(original.getMigratedItemId());
            this.setMigratedStateId(original.getMigratedStateId());
            this.setModifiedBy(original.getModifiedBy());
            this.setModified(original.getRequestedModified());
            this.setNonImpacting(original.isNonImpacting());
            this.setOrigin(original.getOrigin());
            this.setProjectArea(original.getProjectArea());
            this.setRedactedCopy(original.isRedactedCopy());
            this.setStateId(original.getStateId());
            this.setWorkingCopy(original.isWorkingCopy());
            if (original instanceof IPackagingItem) {
                IPackagingItem packagingItem = (IPackagingItem)original;
                this.setDescription(packagingItem.getDescription(true));
                this.setName(packagingItem.getName(true));
                this.setFileVersionable(packagingItem.getFileVersionable(true));
                this.setFileName(packagingItem.getFileName(true));
                this.setJclin(packagingItem.getJclin(true));
                this.setIgnore(packagingItem.getIgnore(true));
                this.setAlias(packagingItem.getAlias(true));
                this.setClazz(packagingItem.getClazz(true));
                this.setCsect(packagingItem.getCsect(true));
                this.setDeleted(packagingItem.getDeleted(true));
                this.setDisttype(packagingItem.getDisttype(true));
                this.setFmid(packagingItem.getFmid(true));
                this.setHfsdata(packagingItem.getHfsdata(true));
                this.setHfspath(packagingItem.getHfspath(true));
                this.setLeparm(packagingItem.getLeparm(true));
                this.setMcsclass(packagingItem.getMcsclass(true));
                this.setModule(packagingItem.getModule(true));
                this.setOriginalFmid(packagingItem.getOriginalFmid(true));
                this.setOriginalStateId(packagingItem.getOriginalStateId(true));
                this.setTransform(packagingItem.getTransform(true));
                this.setUpdated(packagingItem.getUpdated(true));
                this.setVpl(packagingItem.getVpl(true));
                this.getPackagingDetails().addAll(packagingItem.getPackagingDetails(true));
                this.getPackagingDetailStates().putAll(packagingItem.getPackagingDetailStates());
                if (original instanceof PackagingItemFile) {
                    PackagingItemFile concrete = (PackagingItemFile)original;
                    this.setDescription = concrete.setDescription;
                    this.setName = concrete.setName;
                    this.setIgnore = concrete.setIgnore;
                    this.setAlias = concrete.setAlias;
                    this.setClazz = concrete.setClazz;
                    this.setCsect = concrete.setCsect;
                    this.setDeleted = concrete.setDeleted;
                    this.setDisttype = concrete.setDisttype;
                    this.setFmid = concrete.setFmid;
                    this.setHfsdata = concrete.setHfsdata;
                    this.setHfspath = concrete.setHfspath;
                    this.setLeparm = concrete.setLeparm;
                    this.setMcsclass = concrete.setMcsclass;
                    this.setModule = concrete.setModule;
                    this.setOriginalFmid = concrete.setOriginalFmid;
                    this.setOriginalStateId = concrete.setOriginalStateId;
                    this.setTransform = concrete.setTransform;
                    this.setUpdated = concrete.setUpdated;
                    this.setVpl = concrete.setVpl;
                }
            } else {
                this.setDescription(original.getDescription());
                this.setName(original.getName());
                this.setFileName(IPackagingProperties.EDEFAULT_FILEITEM_FILENAME);
                this.setFileVersionable(IPackagingProperties.EDEFAULT_FILEITEM_FILEVERSIONABLE);
                this.setJclin(IPackagingProperties.EDEFAULT_FILEITEM_JCLIN);
                this.setIgnore(IPackagingProperties.EDEFAULT_FILEITEM_IGNORE);
                this.setAlias(original.getAlias());
                this.setClazz(original.getClazz());
                this.setCsect(original.getCsect());
                this.setDeleted(original.getDeleted());
                this.setDisttype(original.getDisttype());
                this.setFmid(original.getFmid());
                this.setHfsdata(original.getHfsdata());
                this.setHfspath(original.getHfspath());
                this.setLeparm(original.getLeparm());
                this.setMcsclass(original.getMcsclass());
                this.setModule(original.getModule());
                this.setOriginalFmid(original.getOriginalFmid());
                this.setOriginalStateId(original.getOriginalStateId());
                this.setTransform(original.getTransform());
                this.setUpdated(original.getUpdated());
                this.setVpl(original.getVpl());
                this.getPackagingDetails().addAll(original.getPackagingDetails());
                this.getPackagingDetailStates().putAll(original.getPackagingDetailStates());
            }
            if (this.isWorkingCopy()) {
                PackagingItemFile auditableThis = this;
                Auditable auditableThat = (Auditable)original;
                auditableThis.setWorkingCopyPredecessor(auditableThat.getWorkingCopyPredecessor());
                auditableThis.setWorkingCopyMergePredecessor(auditableThat.getWorkingCopyMergePredecessor());
                auditableThis.setPredecessor(auditableThat.getPredecessor());
                auditableThis.setMergePredecessor(auditableThat.getMergePredecessor());
                this.protect();
            }
        }
        return this;
    }

    @Override
    public final IPackagingItem duplicate(IPackagingItemDefinition original) {
        this.setArchived(original.isArchived());
        this.setContextId(original.getContextId());
        this.setIgnoredOnceForBuild(original.isIgnoredOnceForBuild());
        this.setNonImpacting(original.isNonImpacting());
        this.setOrigin(original.getOrigin());
        this.setProjectArea(original.getProjectArea());
        if (original instanceof IPackagingItem) {
            IPackagingItem packagingItem = (IPackagingItem)original;
            this.setDescription(packagingItem.getDescription(true));
            this.setName(packagingItem.getName(true));
            this.setFileVersionable(packagingItem.getFileVersionable(true));
            this.setFileName(packagingItem.getFileName(true));
            this.setJclin(packagingItem.getJclin(true));
            this.setIgnore(packagingItem.getIgnore(true));
            this.setAlias(packagingItem.getAlias(true));
            this.setClazz(packagingItem.getClazz(true));
            this.setCsect(packagingItem.getCsect(true));
            this.setDeleted(packagingItem.getDeleted(true));
            this.setDisttype(packagingItem.getDisttype(true));
            this.setFmid(packagingItem.getFmid(true));
            this.setHfsdata(packagingItem.getHfsdata(true));
            this.setHfspath(packagingItem.getHfspath(true));
            this.setLeparm(packagingItem.getLeparm(true));
            this.setMcsclass(packagingItem.getMcsclass(true));
            this.setModule(packagingItem.getModule(true));
            this.setOriginalFmid(packagingItem.getOriginalFmid(true));
            this.setOriginalStateId(packagingItem.getOriginalStateId(true));
            this.setTransform(packagingItem.getTransform(true));
            this.setUpdated(packagingItem.getUpdated(true));
            this.setVpl(packagingItem.getVpl(true));
            if (original instanceof PackagingItemFile) {
                PackagingItemFile concrete = (PackagingItemFile)original;
                this.setDescription = concrete.setDescription;
                this.setName = concrete.setName;
                this.setIgnore = concrete.setIgnore;
                this.setAlias = concrete.setAlias;
                this.setClazz = concrete.setClazz;
                this.setCsect = concrete.setCsect;
                this.setDeleted = concrete.setDeleted;
                this.setDisttype = concrete.setDisttype;
                this.setFmid = concrete.setFmid;
                this.setHfsdata = concrete.setHfsdata;
                this.setHfspath = concrete.setHfspath;
                this.setLeparm = concrete.setLeparm;
                this.setMcsclass = concrete.setMcsclass;
                this.setModule = concrete.setModule;
                this.setOriginalFmid = concrete.setOriginalFmid;
                this.setOriginalStateId = concrete.setOriginalStateId;
                this.setTransform = concrete.setTransform;
                this.setUpdated = concrete.setUpdated;
                this.setVpl = concrete.setVpl;
            }
        } else {
            this.setDescription(original.getDescription());
            this.setName(original.getName());
            this.setAlias(original.getAlias());
            this.setClazz(original.getClazz());
            this.setCsect(original.getCsect());
            this.setDeleted(original.getDeleted());
            this.setDisttype(original.getDisttype());
            this.setFmid(original.getFmid());
            this.setHfsdata(original.getHfsdata());
            this.setHfspath(original.getHfspath());
            this.setLeparm(original.getLeparm());
            this.setMcsclass(original.getMcsclass());
            this.setModule(original.getModule());
            this.setOriginalFmid(original.getOriginalFmid());
            this.setOriginalStateId(original.getOriginalStateId());
            this.setTransform(original.getTransform());
            this.setUpdated(original.getUpdated());
            this.setVpl(original.getVpl());
        }
        if (ItemUtil.isProtected((ItemHandle)this)) {
            ItemUtil.unprotect((ItemHandle)this);
            this.getPackagingDetails().clear();
            this.getPackagingDetails().addAll(original.getPackagingDetails());
            this.getPackagingDetailStates().clear();
            this.getPackagingDetailStates().putAll(original.getPackagingDetailStates());
            this.protect();
        } else {
            this.getPackagingDetails().clear();
            this.getPackagingDetails().addAll(original.getPackagingDetails());
            this.getPackagingDetailStates().clear();
            this.getPackagingDetailStates().putAll(original.getPackagingDetailStates());
        }
        return this;
    }

    @Override
    public final void init() {
        List<?> packagingDetails = super.getDetails();
        if (packagingDetails != null) {
            this.packagingDetails = new ArrayList();
            for (IPackagingDetail superItem : packagingDetails) {
                PackagingDetailFile localItem = new PackagingDetailFile(superItem);
                localItem.setAdded(false);
                this.packagingDetails.add(localItem);
            }
        }
    }

    @Override
    public final void init(List<String> add, List<String> remove, List<String> order) {
        this.init();
        if (add != null) {
            for (String uuid : add) {
                if (uuid == null) continue;
                IPackagingDetail localItem = this.newInstanceDetail();
                localItem.setUuid(uuid);
                localItem.setAdded(true);
                this.packagingDetails.add(localItem);
            }
        }
        if (remove != null) {
            block1: for (String uuid : remove) {
                if (uuid == null) continue;
                int i = 0;
                while (i < this.packagingDetails.size()) {
                    if (this.packagingDetails.get(i) != null && uuid.equals(((IPackagingDetailDefinitionHandle)this.packagingDetails.get(i)).getItemId().getUuidValue())) {
                        this.packagingDetails.remove(i);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        if (order != null) {
            ArrayList<IPackagingDetailDefinitionHandle> orderedDetails = new ArrayList<IPackagingDetailDefinitionHandle>();
            block3: for (String uuid : order) {
                if (uuid == null) continue;
                int i = 0;
                while (i < this.packagingDetails.size()) {
                    if (this.packagingDetails.get(i) != null && uuid.equals(((IPackagingDetailDefinitionHandle)this.packagingDetails.get(i)).getItemId().getUuidValue())) {
                        orderedDetails.add((IPackagingDetailDefinitionHandle)this.packagingDetails.get(i));
                        continue block3;
                    }
                    ++i;
                }
            }
            this.packagingDetails = orderedDetails;
        }
    }

    @Override
    public final IPackagingItem newCopy() {
        return new PackagingItemFile(this.packagingItem, this);
    }

    @Override
    public final ISystemDefinition newInstance() {
        return new PackagingItemFile(this.packagingItem);
    }

    @Override
    public final IPackagingDetail newInstanceDetail() {
        PackagingDetailLanguage higher = new PackagingDetailLanguage();
        PackagingDetailFile result = new PackagingDetailFile(higher);
        return result;
    }

    @Override
    public final IPackagingDetail newInstanceDetail(int index) {
        IPackagingDetail higher = super.getPackagingDetail(index);
        PackagingDetailFile result = new PackagingDetailFile(higher);
        return result;
    }

    @Override
    public final IPackagingItem update(IPackagingItemDefinition updated) {
        this.setArchived(updated.isArchived());
        this.setContextId(updated.getContextId());
        this.setIgnoredOnceForBuild(updated.isIgnoredOnceForBuild());
        this.setItemId(updated.getItemId());
        this.setMigratedItemId(updated.getMigratedItemId());
        this.setMigratedStateId(updated.getMigratedStateId());
        this.setNonImpacting(updated.isNonImpacting());
        this.setOrigin(updated.getOrigin());
        this.setProjectArea(updated.getProjectArea());
        this.setStateId(updated.getStateId());
        if (updated instanceof IPackagingItem) {
            IPackagingItem packagingItem = (IPackagingItem)updated;
            this.setDescription(packagingItem.getDescription(true));
            this.setName(packagingItem.getName(true));
            this.setFileVersionable(packagingItem.getFileVersionable(true));
            this.setFileName(packagingItem.getFileName(true));
            this.setJclin(packagingItem.getJclin(true));
            this.setIgnore(packagingItem.getIgnore(true));
            this.setAlias(packagingItem.getAlias(true));
            this.setClazz(packagingItem.getClazz(true));
            this.setCsect(packagingItem.getCsect(true));
            this.setDeleted(packagingItem.getDeleted(true));
            this.setDisttype(packagingItem.getDisttype(true));
            this.setFmid(packagingItem.getFmid(true));
            this.setHfsdata(packagingItem.getHfsdata(true));
            this.setHfspath(packagingItem.getHfspath(true));
            this.setLeparm(packagingItem.getLeparm(true));
            this.setMcsclass(packagingItem.getMcsclass(true));
            this.setModule(packagingItem.getModule(true));
            this.setOriginalFmid(packagingItem.getOriginalFmid(true));
            this.setOriginalStateId(packagingItem.getOriginalStateId(true));
            this.setTransform(packagingItem.getTransform(true));
            this.setUpdated(packagingItem.getUpdated(true));
            this.setVpl(packagingItem.getVpl(true));
            if (updated instanceof PackagingItemFile) {
                PackagingItemFile concrete = (PackagingItemFile)updated;
                this.setDescription = concrete.setDescription;
                this.setName = concrete.setName;
                this.setIgnore = concrete.setIgnore;
                this.setAlias = concrete.setAlias;
                this.setClazz = concrete.setClazz;
                this.setCsect = concrete.setCsect;
                this.setDeleted = concrete.setDeleted;
                this.setDisttype = concrete.setDisttype;
                this.setFmid = concrete.setFmid;
                this.setHfsdata = concrete.setHfsdata;
                this.setHfspath = concrete.setHfspath;
                this.setLeparm = concrete.setLeparm;
                this.setMcsclass = concrete.setMcsclass;
                this.setModule = concrete.setModule;
                this.setOriginalFmid = concrete.setOriginalFmid;
                this.setOriginalStateId = concrete.setOriginalStateId;
                this.setTransform = concrete.setTransform;
                this.setUpdated = concrete.setUpdated;
                this.setVpl = concrete.setVpl;
            }
        } else {
            this.setDescription(updated.getDescription());
            this.setName(updated.getName());
            this.setAlias(updated.getAlias());
            this.setClazz(updated.getClazz());
            this.setCsect(updated.getCsect());
            this.setDeleted(updated.getDeleted());
            this.setDisttype(updated.getDisttype());
            this.setFmid(updated.getFmid());
            this.setHfsdata(updated.getHfsdata());
            this.setHfspath(updated.getHfspath());
            this.setLeparm(updated.getLeparm());
            this.setMcsclass(updated.getMcsclass());
            this.setModule(updated.getModule());
            this.setOriginalFmid(updated.getOriginalFmid());
            this.setOriginalStateId(updated.getOriginalStateId());
            this.setTransform(updated.getTransform());
            this.setUpdated(updated.getUpdated());
            this.setVpl(updated.getVpl());
        }
        if (ItemUtil.isProtected((ItemHandle)this)) {
            ItemUtil.unprotect((ItemHandle)this);
            this.getPackagingDetails().clear();
            this.getPackagingDetails().addAll(updated.getPackagingDetails());
            this.getPackagingDetailStates().clear();
            this.getPackagingDetailStates().putAll(updated.getPackagingDetailStates());
            this.protect();
        } else {
            this.getPackagingDetails().clear();
            this.getPackagingDetails().addAll(updated.getPackagingDetails());
            this.getPackagingDetailStates().clear();
            this.getPackagingDetailStates().putAll(updated.getPackagingDetailStates());
        }
        return this;
    }

    @Override
    public final String getItemLabel() {
        return Packaging.getLabel(this.fileItem);
    }

    @Override
    public final IVersionable getFileVersionable() {
        return this.fileVersionable == null ? super.getFileVersionable() : this.fileVersionable;
    }

    @Override
    public final IVersionable getFileVersionable(boolean local) {
        if (local) {
            return this.fileVersionable;
        }
        return this.getFileVersionable();
    }

    @Override
    public final IPackagingItem getFileItem() {
        return this.fileItem == null ? super.getFileItem() : this.fileItem;
    }

    @Override
    public final IPackagingItem getFileItem(boolean local) {
        if (local) {
            return this.fileItem;
        }
        return this.getFileItem();
    }

    @Override
    public final String getFileName() {
        return this.fileName == null ? super.getFileName() : this.fileName;
    }

    @Override
    public final String getFileName(boolean local) {
        if (local) {
            return this.fileName;
        }
        return this.getFileName();
    }

    @Override
    public final Boolean getJclin() {
        return this.jclin == null ? super.getJclin() : this.jclin;
    }

    @Override
    public final Boolean getJclin(boolean local) {
        if (local) {
            return this.jclin;
        }
        return this.getJclin();
    }

    @Override
    public final boolean hasFileVersionable() {
        return Verification.isNonNull((Object)this.getFileVersionable());
    }

    @Override
    public final boolean hasFileVersionable(boolean local) {
        return Verification.isNonNull((Object)this.getFileVersionable(local));
    }

    @Override
    public final boolean hasFileItem() {
        return Verification.isNonNull((Object)this.getFileItem());
    }

    @Override
    public final boolean hasFileItem(boolean local) {
        return Verification.isNonNull((Object)this.getFileItem(local));
    }

    @Override
    public final boolean hasFileName() {
        return Verification.isNonBlank((String)this.getFileName());
    }

    @Override
    public final boolean hasFileName(boolean local) {
        return Verification.isNonBlank((String)this.getFileName(local));
    }

    @Override
    public final boolean hasJclin() {
        return Verification.isNonNull((Object)this.getJclin());
    }

    @Override
    public final boolean hasJclin(boolean local) {
        return Verification.isNonNull((Object)this.getJclin(local));
    }

    @Override
    public final boolean isJclin() {
        return this.getJclin();
    }

    @Override
    public final boolean isJclin(boolean local) {
        return this.getJclin(local);
    }

    @Override
    public final void setFileVersionable(IVersionable iFileVersionable) {
        this.fileVersionable = iFileVersionable;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItem)this.fileVersionable)});
        }
    }

    @Override
    public final void setFileName(String fileName) {
        this.fileName = fileName;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.fileName)});
        }
    }

    @Override
    public final void setJclin(Boolean jclin) {
        this.jclin = jclin;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Boolean)this.jclin)});
        }
    }

    @Override
    public final String toFilePath() {
        return String.valueOf(LogString.valueOf((String)this.toFolderPath())) + "/" + LogString.valueOf((String)this.getFileName());
    }

    @Override
    public final String toAncientFormat() {
        return this.getLeparm().replaceAll("REUS=(.*?)($|,)", "REUS($1)$2");
    }

    @Override
    public final String toName() {
        return this.hasFileName() ? this.getFileName().split("\\.")[0] : "";
    }

    @Override
    public final String toType() {
        return this.hasFileName() ? this.getFileName().split("\\.")[1] : "";
    }
}

