/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.impl.FunctionDefinitionImpl;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFunction;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.ItemHandle;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PackagingFunction
extends FunctionDefinitionImpl
implements IFunctionDefinition,
IPackagingFunction {
    private final IDebugger dbg;
    private final String simpleName;

    public PackagingFunction() {
        this((IDebugger)new Debugger(PackagingFunction.class));
    }

    public PackagingFunction(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.initNew();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingFunction(IFunctionDefinition packagingFunction) {
        this(packagingFunction, (IDebugger)new Debugger(PackagingFunction.class));
    }

    public PackagingFunction(IFunctionDefinition packagingFunction, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.copy(packagingFunction);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IPackagingFunction copy(IFunctionDefinition original) {
        if (original == null) {
            this.initNew();
            this.setDescription("");
            this.setName("");
            this.setId("");
            this.setMcsDescription("");
        } else {
            this.setArchived(original.isArchived());
            this.setContextId(original.getContextId());
            this.setDescription(original.getDescription());
            this.setIgnoredOnceForBuild(original.isIgnoredOnceForBuild());
            this.setImmutable(original.isImmutable());
            this.setItemId(original.getItemId());
            this.setMigratedItemId(original.getMigratedItemId());
            this.setMigratedStateId(original.getMigratedStateId());
            this.setModifiedBy(original.getModifiedBy());
            this.setModified(original.getRequestedModified());
            this.setName(original.getName());
            this.setNonImpacting(original.isNonImpacting());
            this.setOrigin(original.getOrigin());
            this.setProjectArea(original.getProjectArea());
            this.setRedactedCopy(original.isRedactedCopy());
            this.setStateId(original.getStateId());
            this.setWorkingCopy(original.isWorkingCopy());
            this.setId(original.getId());
            this.setMcsDescription(original.getMcsDescription());
            this.getScopedProperties().addAll(new EcoreUtil.Copier().copyAll(original.getScopedProperties()));
            if (this.isWorkingCopy()) {
                PackagingFunction auditableThis = this;
                Auditable auditableThat = (Auditable)original;
                auditableThis.setWorkingCopyPredecessor(auditableThat.getWorkingCopyPredecessor());
                auditableThis.setWorkingCopyMergePredecessor(auditableThat.getWorkingCopyMergePredecessor());
                auditableThis.setPredecessor(auditableThat.getPredecessor());
                auditableThis.setMergePredecessor(auditableThat.getMergePredecessor());
                this.protect();
            }
        }
        return this;
    }

    @Override
    public final IPackagingFunction newCopy() {
        return new PackagingFunction(this);
    }

    @Override
    public final ISystemDefinition newInstance() {
        return new PackagingFunction();
    }

    @Override
    public final IPackagingFunction update(IFunctionDefinition updated) {
        this.setArchived(updated.isArchived());
        this.setContextId(updated.getContextId());
        this.setDescription(updated.getDescription());
        this.setIgnoredOnceForBuild(updated.isIgnoredOnceForBuild());
        this.setItemId(updated.getItemId());
        this.setMigratedItemId(updated.getMigratedItemId());
        this.setMigratedStateId(updated.getMigratedStateId());
        this.setName(updated.getName());
        this.setNonImpacting(updated.isNonImpacting());
        this.setOrigin(updated.getOrigin());
        this.setProjectArea(updated.getProjectArea());
        this.setStateId(updated.getStateId());
        this.setId(updated.getId());
        this.setMcsDescription(updated.getMcsDescription());
        if (ItemUtil.isProtected((ItemHandle)this)) {
            ItemUtil.unprotect((ItemHandle)this);
            this.getScopedProperties().clear();
            this.getScopedProperties().addAll(new EcoreUtil.Copier().copyAll(updated.getScopedProperties()));
            this.protect();
        } else {
            this.getScopedProperties().clear();
            this.getScopedProperties().addAll(new EcoreUtil.Copier().copyAll(updated.getScopedProperties()));
        }
        return this;
    }

    @Override
    public final boolean hasDescription() {
        return Verification.isNonBlank((String)this.description);
    }

    @Override
    public final boolean hasName() {
        return Verification.isNonBlank((String)this.name);
    }

    @Override
    public boolean hasId() {
        return Verification.isNonBlank((String)this.id);
    }

    @Override
    public boolean hasMcsDescription() {
        return Verification.isNonBlank((String)this.mcsDescription);
    }

    @Override
    public final boolean hasScopedProperties() {
        return Verification.isNonEmpty((List)this.scopedProperties);
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)id)});
        }
    }

    @Override
    public void setMcsDescription(String mcsDescription) {
        super.setMcsDescription(mcsDescription);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsDescription)});
        }
    }
}

