/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.impl.FmidItemDefinitionImpl;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.OsPlatform;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingElements;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFmidItem;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionLogString;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.ItemHandle;
import java.math.BigDecimal;
import java.util.List;

public class PackagingFmidItem
extends FmidItemDefinitionImpl
implements IFmidItemDefinition,
IPackagingFmidItem {
    private final IDebugger dbg;
    private final String simpleName;
    private final boolean initialized;
    private String functionId;
    private String functionName;
    private String functionUuid;
    private boolean jclinOverride;
    private boolean referenced;

    public PackagingFmidItem() {
        this((IDebugger)new Debugger(PackagingFmidItem.class));
    }

    public PackagingFmidItem(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.initNew();
        this.initialized = true;
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingFmidItem(IFmidItemDefinition packagingFmidItem) {
        this(packagingFmidItem, (IDebugger)new Debugger(PackagingFmidItem.class));
    }

    public PackagingFmidItem(IFmidItemDefinition packagingFmidItem, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.initialized = true;
        this.copy(packagingFmidItem);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IPackagingFmidItem copy(IFmidItemDefinition original) {
        if (original == null) {
            this.initNew();
            this.setDescription("");
            this.setName("");
            this.setAlias("");
            this.setBase(false);
            this.setFesn("");
            this.setFullyResolved(false);
            this.setFunction(IPackagingElements.EDEFAULT_FMIDITEM_FUNCTION);
            this.setIgnore(false);
            this.setInitialRevision(IPackagingElements.EDEFAULT_FMIDITEM_INITIALREVISION);
            this.setJclinCalllibs(false);
            this.setJclinDistlib(IPackagingElements.EDEFAULT_FMIDITEM_JCLIN_DISTLIB);
            this.setJclinId("");
            this.setJclinInSource(false);
            this.setJclinLocation(IPackagingElements.EDEFAULT_FMIDITEM_JCLIN_LOCATION);
            this.setMcscpyrt("");
            this.setMcscpyrtId("");
            this.setMcscpyrtLocation(IPackagingElements.EDEFAULT_FMIDITEM_MCSCPYRT_LOCATION);
            this.setMcsDel("");
            this.setMcsDelFile("");
            this.setMcsNpr("");
            this.setMcsNprFile("");
            this.setMcsPre("");
            this.setMcsPreFile("");
            this.setMcsReq("");
            this.setMcsReqFile("");
            this.setMcsSup("");
            this.setMcsSupFile("");
            this.setMcsVer("");
            this.setMcsVerFile("");
            this.setOsPlatform(IPackagingElements.EDEFAULT_FMIDITEM_OSPLATFORM);
            this.setRfdsnpfx("IBM");
            this.setScp(false);
            this.setFunctionId("");
            this.setFunctionName("");
            this.setFunctionUuid("");
            this.setJclinOverride(false);
            this.setReferenced(false);
        } else {
            this.setArchived(original.isArchived());
            this.setContextId(original.getContextId());
            this.setDescription(original.getDescription());
            this.setIgnoredOnceForBuild(original.isIgnoredOnceForBuild());
            this.setImmutable(original.isImmutable());
            this.setItemId(original.getItemId());
            this.setMigratedItemId(original.getMigratedItemId());
            this.setMigratedStateId(original.getMigratedStateId());
            this.setModifiedBy(original.getModifiedBy());
            this.setModified(original.getRequestedModified());
            this.setName(original.getName());
            this.setNonImpacting(original.isNonImpacting());
            this.setOrigin(original.getOrigin());
            this.setProjectArea(original.getProjectArea());
            this.setRedactedCopy(original.isRedactedCopy());
            this.setStateId(original.getStateId());
            this.setWorkingCopy(original.isWorkingCopy());
            this.setAlias(original.getAlias());
            this.setBase(original.isBase());
            this.setFesn(original.getFesn());
            this.setFullyResolved(original.isFullyResolved());
            this.setFunction(original.getFunction());
            this.setIgnore(original.isIgnore());
            this.setInitialRevision(original.getInitialRevision());
            this.setJclinCalllibs(original.isJclinCalllibs());
            this.setJclinDistlib(original.getJclinDistlib());
            this.setJclinId(original.getJclinId());
            this.setJclinInSource(original.isJclinInSource());
            this.setJclinLocation(original.getJclinLocation());
            this.setMcscpyrt(original.getMcscpyrt());
            this.setMcscpyrtId(original.getMcscpyrtId());
            this.setMcscpyrtLocation(original.getMcscpyrtLocation());
            this.setMcsDel(original.getMcsDel());
            this.setMcsDelFile(original.getMcsDelFile());
            this.setMcsNpr(original.getMcsNpr());
            this.setMcsNprFile(original.getMcsNprFile());
            this.setMcsPre(original.getMcsPre());
            this.setMcsPreFile(original.getMcsPreFile());
            this.setMcsReq(original.getMcsReq());
            this.setMcsReqFile(original.getMcsReqFile());
            this.setMcsSup(original.getMcsSup());
            this.setMcsSupFile(original.getMcsSupFile());
            this.setMcsVer(original.getMcsVer());
            this.setMcsVerFile(original.getMcsVerFile());
            this.setOsPlatform(original.getOsPlatform());
            this.setRfdsnpfx(original.getRfdsnpfx());
            this.setScp(original.isScp());
            this.getRelfiles().addAll(original.getRelfiles());
            if (original instanceof IPackagingFmidItem) {
                this.setJclinOverride(((IPackagingFmidItem)original).isJclinOverride());
                this.setReferenced(((IPackagingFmidItem)original).isReferenced());
            } else {
                this.setJclinOverride(false);
                this.setReferenced(false);
            }
            if (this.isWorkingCopy()) {
                PackagingFmidItem auditableThis = this;
                Auditable auditableThat = (Auditable)original;
                auditableThis.setWorkingCopyPredecessor(auditableThat.getWorkingCopyPredecessor());
                auditableThis.setWorkingCopyMergePredecessor(auditableThat.getWorkingCopyMergePredecessor());
                auditableThis.setPredecessor(auditableThat.getPredecessor());
                auditableThis.setMergePredecessor(auditableThat.getMergePredecessor());
                this.protect();
            }
        }
        return this;
    }

    @Override
    public final IPackagingFmidItem newCopy() {
        return new PackagingFmidItem(this);
    }

    @Override
    public final ISystemDefinition newInstance() {
        return new PackagingFmidItem();
    }

    @Override
    public final IPackagingFmidItem update(IFmidItemDefinition updated) {
        this.setArchived(updated.isArchived());
        this.setContextId(updated.getContextId());
        this.setDescription(updated.getDescription());
        this.setIgnoredOnceForBuild(updated.isIgnoredOnceForBuild());
        this.setItemId(updated.getItemId());
        this.setMigratedItemId(updated.getMigratedItemId());
        this.setMigratedStateId(updated.getMigratedStateId());
        this.setName(updated.getName());
        this.setNonImpacting(updated.isNonImpacting());
        this.setOrigin(updated.getOrigin());
        this.setProjectArea(updated.getProjectArea());
        this.setStateId(updated.getStateId());
        this.setAlias(updated.getAlias());
        this.setBase(updated.isBase());
        this.setFesn(updated.getFesn());
        this.setFullyResolved(updated.isFullyResolved());
        this.setFunction(updated.getFunction());
        this.setIgnore(updated.isIgnore());
        this.setInitialRevision(updated.getInitialRevision());
        this.setJclinCalllibs(updated.isJclinCalllibs());
        this.setJclinDistlib(updated.getJclinDistlib());
        this.setJclinId(updated.getJclinId());
        this.setJclinInSource(updated.isJclinInSource());
        this.setJclinLocation(updated.getJclinLocation());
        this.setMcscpyrt(updated.getMcscpyrt());
        this.setMcscpyrtId(updated.getMcscpyrtId());
        this.setMcscpyrtLocation(updated.getMcscpyrtLocation());
        this.setMcsDel(updated.getMcsDel());
        this.setMcsDelFile(updated.getMcsDelFile());
        this.setMcsNpr(updated.getMcsNpr());
        this.setMcsNprFile(updated.getMcsNprFile());
        this.setMcsPre(updated.getMcsPre());
        this.setMcsPreFile(updated.getMcsPreFile());
        this.setMcsReq(updated.getMcsReq());
        this.setMcsReqFile(updated.getMcsReqFile());
        this.setMcsSup(updated.getMcsSup());
        this.setMcsSupFile(updated.getMcsSupFile());
        this.setMcsVer(updated.getMcsVer());
        this.setMcsVerFile(updated.getMcsVerFile());
        this.setOsPlatform(updated.getOsPlatform());
        this.setRfdsnpfx(updated.getRfdsnpfx());
        this.setScp(updated.isScp());
        if (ItemUtil.isProtected((ItemHandle)this)) {
            ItemUtil.unprotect((ItemHandle)this);
            this.getRelfiles().clear();
            this.getRelfiles().addAll(updated.getRelfiles());
            this.protect();
        } else {
            this.getRelfiles().clear();
            this.getRelfiles().addAll(updated.getRelfiles());
        }
        if (updated instanceof IPackagingFmidItem) {
            this.setJclinOverride(((IPackagingFmidItem)updated).isJclinOverride());
            this.setReferenced(((IPackagingFmidItem)updated).isReferenced());
        }
        return this;
    }

    @Override
    public final String getFunctionId() {
        return this.functionId;
    }

    @Override
    public final String getFunctionName() {
        return this.functionName;
    }

    @Override
    public final String getFunctionUuid() {
        return this.functionUuid;
    }

    @Override
    public final boolean hasDescription() {
        return Verification.isNonBlank((String)this.description);
    }

    @Override
    public final boolean hasName() {
        return Verification.isNonBlank((String)this.name);
    }

    @Override
    public final boolean hasAlias() {
        return Verification.isNonBlank((String)this.alias);
    }

    @Override
    public boolean hasFesn() {
        return Verification.isNonBlank((String)this.fesn);
    }

    @Override
    public final boolean hasFunction() {
        return Verification.isNonNull((Object)this.function);
    }

    @Override
    public final boolean hasFunctionId() {
        return Verification.isNonBlank((String)this.functionId);
    }

    @Override
    public final boolean hasFunctionName() {
        return Verification.isNonBlank((String)this.functionName);
    }

    @Override
    public final boolean hasFunctionUuid() {
        return Verification.isNonBlank((String)this.functionUuid);
    }

    @Override
    public final boolean hasInitialRevision() {
        return Verification.isNonNull((Object)this.initialRevision);
    }

    @Override
    public final boolean hasJclinDistlib() {
        return Verification.isNonNull((Object)this.jclinDistlib);
    }

    @Override
    public final boolean hasJclinId() {
        return Verification.isNonBlank((String)this.jclinId);
    }

    @Override
    public final boolean hasJclinLocation() {
        return Verification.isNonNull((Object)this.jclinLocation);
    }

    @Override
    public final boolean hasMcscpyrt() {
        return Verification.isNonBlank((String)this.mcscpyrt);
    }

    @Override
    public final boolean hasMcscpyrtId() {
        return Verification.isNonBlank((String)this.mcscpyrtId);
    }

    @Override
    public final boolean hasMcscpyrtLocation() {
        return Verification.isNonNull((Object)this.mcscpyrtLocation);
    }

    @Override
    public final boolean hasMcsDel() {
        return Verification.isNonBlank((String)this.mcsDel);
    }

    @Override
    public final boolean hasMcsDelFile() {
        return Verification.isNonBlank((String)this.mcsDelFile);
    }

    @Override
    public final boolean hasMcsNpr() {
        return Verification.isNonBlank((String)this.mcsNpr);
    }

    @Override
    public final boolean hasMcsNprFile() {
        return Verification.isNonBlank((String)this.mcsNprFile);
    }

    @Override
    public final boolean hasMcsPre() {
        return Verification.isNonBlank((String)this.mcsPre);
    }

    @Override
    public final boolean hasMcsPreFile() {
        return Verification.isNonBlank((String)this.mcsPreFile);
    }

    @Override
    public final boolean hasMcsReq() {
        return Verification.isNonBlank((String)this.mcsReq);
    }

    @Override
    public final boolean hasMcsReqFile() {
        return Verification.isNonBlank((String)this.mcsReqFile);
    }

    @Override
    public final boolean hasMcsSup() {
        return Verification.isNonBlank((String)this.mcsSup);
    }

    @Override
    public final boolean hasMcsSupFile() {
        return Verification.isNonBlank((String)this.mcsSupFile);
    }

    @Override
    public final boolean hasMcsVer() {
        return Verification.isNonBlank((String)this.mcsVer);
    }

    @Override
    public final boolean hasMcsVerFile() {
        return Verification.isNonBlank((String)this.mcsVerFile);
    }

    @Override
    public boolean hasOsPlatform() {
        return Verification.isNonNull((Object)((Object)this.osPlatform));
    }

    @Override
    public boolean hasRfdsnpfx() {
        return Verification.isNonBlank((String)this.rfdsnpfx);
    }

    @Override
    public final boolean hasRelfiles() {
        return Verification.isNonEmpty((List)this.relfiles);
    }

    @Override
    public final boolean isJclinOverride() {
        return this.jclinOverride;
    }

    @Override
    public final boolean isReferenced() {
        return this.referenced;
    }

    @Override
    public final void setAlias(String alias) {
        super.setAlias(alias);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)alias)});
        }
    }

    @Override
    public final void setBase(boolean base) {
        super.setBase(base);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)base)});
        }
    }

    @Override
    public final void setFesn(String fesn) {
        super.setFesn(fesn);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)fesn)});
        }
    }

    @Override
    public final void setFunction(IFunctionDefinitionHandle function) {
        super.setFunction(function);
        if (function instanceof IFunctionDefinition) {
            IFunctionDefinition functionDefinition = (IFunctionDefinition)function;
            this.setFunctionId(functionDefinition.getId());
            this.setFunctionName(functionDefinition.getName());
            this.setFunctionUuid(functionDefinition.getItemId().getUuidValue());
        }
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), SystemDefinitionLogString.valueOf(function)});
        }
    }

    @Override
    public final void setFunctionId(String functionId) {
        this.functionId = functionId;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)functionId)});
        }
    }

    @Override
    public final void setFunctionName(String functionName) {
        this.functionName = functionName;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)functionName)});
        }
    }

    @Override
    public final void setFunctionUuid(String functionUuid) {
        this.functionUuid = functionUuid;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)functionUuid)});
        }
    }

    @Override
    public final void setIgnore(boolean ignore) {
        super.setIgnore(ignore);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)ignore)});
        }
    }

    @Override
    public final void setInitialRevision(BigDecimal initialRevision) {
        super.setInitialRevision(initialRevision);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((BigDecimal)initialRevision)});
        }
    }

    @Override
    public final void setJclinCalllibs(boolean jclinCalllibs) {
        super.setJclinCalllibs(jclinCalllibs);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)jclinCalllibs)});
        }
    }

    @Override
    public final void setJclinDistlib(IDataSetDefinitionHandle jclinDistlib) {
        super.setJclinDistlib(jclinDistlib);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), SystemDefinitionLogString.valueOf(jclinDistlib)});
        }
    }

    @Override
    public final void setJclinId(String jclinId) {
        super.setJclinId(jclinId);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)jclinId)});
        }
    }

    @Override
    public final void setJclinInSource(boolean jclinInSource) {
        super.setJclinInSource(jclinInSource);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)jclinInSource)});
        }
    }

    @Override
    public final void setJclinLocation(IDataSetDefinitionHandle jclinLocation) {
        super.setJclinLocation(jclinLocation);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), SystemDefinitionLogString.valueOf(jclinLocation)});
        }
    }

    @Override
    public final void setJclinOverride(boolean jclinOverride) {
        this.jclinOverride = jclinOverride;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)jclinOverride)});
        }
    }

    @Override
    public final void setMcscpyrt(String mcscpyrt) {
        super.setMcscpyrt(mcscpyrt);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcscpyrt)});
        }
    }

    @Override
    public final void setMcscpyrtId(String mcscpyrtId) {
        super.setMcscpyrtId(mcscpyrtId);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcscpyrtId)});
        }
    }

    @Override
    public final void setMcscpyrtLocation(IDataSetDefinitionHandle mcscpyrtLocation) {
        super.setMcscpyrtLocation(mcscpyrtLocation);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), SystemDefinitionLogString.valueOf(mcscpyrtLocation)});
        }
    }

    @Override
    public final void setMcsDel(String mcsDel) {
        super.setMcsDel(mcsDel);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsDel)});
        }
    }

    @Override
    public final void setMcsDelFile(String mcsDelFile) {
        super.setMcsDelFile(mcsDelFile);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsDelFile)});
        }
    }

    @Override
    public final void setMcsNpr(String mcsNpr) {
        super.setMcsNpr(mcsNpr);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsNpr)});
        }
    }

    @Override
    public final void setMcsNprFile(String mcsNprFile) {
        super.setMcsNprFile(mcsNprFile);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsNprFile)});
        }
    }

    @Override
    public final void setMcsPre(String mcsPre) {
        super.setMcsPre(mcsPre);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsPre)});
        }
    }

    @Override
    public final void setMcsPreFile(String mcsPreFile) {
        super.setMcsPreFile(mcsPreFile);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsPreFile)});
        }
    }

    @Override
    public final void setMcsReq(String mcsReq) {
        super.setMcsReq(mcsReq);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsReq)});
        }
    }

    @Override
    public final void setMcsReqFile(String mcsReqFile) {
        super.setMcsReqFile(mcsReqFile);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsReqFile)});
        }
    }

    @Override
    public final void setMcsSup(String mcsSup) {
        super.setMcsSup(mcsSup);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsSup)});
        }
    }

    @Override
    public final void setMcsSupFile(String mcsSupFile) {
        super.setMcsSupFile(mcsSupFile);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsSupFile)});
        }
    }

    @Override
    public final void setMcsVer(String mcsVer) {
        super.setMcsVer(mcsVer);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsVer)});
        }
    }

    @Override
    public final void setMcsVerFile(String mcsVerFile) {
        super.setMcsVerFile(mcsVerFile);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)mcsVerFile)});
        }
    }

    @Override
    public final void setOsPlatform(OsPlatform osPlatform) {
        super.setOsPlatform(osPlatform);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Object)((Object)osPlatform))});
        }
    }

    @Override
    public final void setReferenced(boolean referenced) {
        this.referenced = referenced;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)referenced)});
        }
    }

    @Override
    public final void setRfdsnpfx(String rfdsnpfx) {
        super.setRfdsnpfx(rfdsnpfx);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)rfdsnpfx)});
        }
    }

    @Override
    public final void setScp(boolean scp) {
        super.setScp(scp);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)scp)});
        }
    }
}

