/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingDataset;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingDetailLanguage;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingFmidItem;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingFunction;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemLanguage;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingVersion;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PackagingFactory {
    private PackagingFactory() {
    }

    public static void addAllFmidItemDefinition(IVersionDefinition version, List<IFmidItemDefinition> fmidItems, Map<String, UUID> fmidStates) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)version))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)version));
            version.getFmidItemDefinitions().clear();
            version.getFmidItemDefinitions().addAll(fmidItems);
            version.getFmidItemStates().clear();
            version.getFmidItemStates().putAll(fmidStates);
            version.protect();
        } else {
            version.getFmidItemDefinitions().clear();
            version.getFmidItemDefinitions().addAll(fmidItems);
            version.getFmidItemStates().clear();
            version.getFmidItemStates().putAll(fmidStates);
        }
    }

    public static void addFmidItemDefinition(IVersionDefinition version, IFmidItemDefinition fmidItem) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)version))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)version));
            version.getFmidItemDefinitions().add(fmidItem);
            version.getFmidItemStates().put(fmidItem.getItemId().getUuidValue(), fmidItem.getStateId());
            version.protect();
        } else {
            version.getFmidItemDefinitions().add(fmidItem);
            version.getFmidItemStates().put(fmidItem.getItemId().getUuidValue(), fmidItem.getStateId());
        }
    }

    public static void addAllPackagingDetailDefinition(IPackagingItemDefinition packagingItem, List<IPackagingDetailDefinition> packagingDetails, Map<String, UUID> packagingDetailStates) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)packagingItem))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)packagingItem));
            packagingItem.getPackagingDetails().clear();
            packagingItem.getPackagingDetails().addAll(packagingDetails);
            packagingItem.getPackagingDetailStates().clear();
            packagingItem.getPackagingDetailStates().putAll(packagingDetailStates);
            packagingItem.protect();
        } else {
            packagingItem.getPackagingDetails().clear();
            packagingItem.getPackagingDetails().addAll(packagingDetails);
            packagingItem.getPackagingDetailStates().clear();
            packagingItem.getPackagingDetailStates().putAll(packagingDetailStates);
        }
    }

    public static void addPackagingDetailDefinition(IPackagingItemDefinition packagingItem, IPackagingDetailDefinition packagingDetail) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)packagingItem))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)packagingItem));
            packagingItem.getPackagingDetails().add(packagingDetail);
            packagingItem.getPackagingDetailStates().put(packagingDetail.getItemId().getUuidValue(), packagingDetail.getStateId());
            packagingItem.protect();
        } else {
            packagingItem.getPackagingDetails().add(packagingDetail);
            packagingItem.getPackagingDetailStates().put(packagingDetail.getItemId().getUuidValue(), packagingDetail.getStateId());
        }
    }

    public static void addPackagingDetailDefinition(IPackagingItemDefinition packagingItem, int index, IPackagingDetailDefinition packagingDetail) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)packagingItem))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)packagingItem));
            packagingItem.getPackagingDetails().add(index, packagingDetail);
            packagingItem.getPackagingDetailStates().put(packagingDetail.getItemId().getUuidValue(), packagingDetail.getStateId());
            packagingItem.protect();
        } else {
            packagingItem.getPackagingDetails().add(index, packagingDetail);
            packagingItem.getPackagingDetailStates().put(packagingDetail.getItemId().getUuidValue(), packagingDetail.getStateId());
        }
    }

    public static void addScopedProperty(IFunctionDefinition function, IScopedProperty scopedProperty) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)function))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)function));
            function.getScopedProperties().add(scopedProperty);
            function.protect();
        } else {
            function.getScopedProperties().add(scopedProperty);
        }
    }

    public static void addScopedProperty(IVersionDefinition version, IScopedProperty scopedProperty) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)version))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)version));
            version.getScopedProperties().add(scopedProperty);
            version.protect();
        } else {
            version.getScopedProperties().add(scopedProperty);
        }
    }

    public static void addScopedProperty(IFunctionDefinition function, int index, IScopedProperty scopedProperty) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)function))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)function));
            function.getScopedProperties().add(index, scopedProperty);
            function.protect();
        } else {
            function.getScopedProperties().add(index, scopedProperty);
        }
    }

    public static void addScopedProperty(IVersionDefinition version, int index, IScopedProperty scopedProperty) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)version))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)version));
            version.getScopedProperties().add(index, scopedProperty);
            version.protect();
        } else {
            version.getScopedProperties().add(index, scopedProperty);
        }
    }

    public static IPackagingItemDefinition copyLanguagePackagingItemDefinition(IPackagingItemDefinition original, String name) {
        return PackagingFactory.copyLanguagePackagingItemDefinition(original, name, (IDebugger)new Debugger(PackagingFactory.class));
    }

    public static IPackagingItemDefinition copyLanguagePackagingItemDefinition(IPackagingItemDefinition original, String name, IDebugger dbg) {
        PackagingItemLanguage packagingItemDefinition = new PackagingItemLanguage(dbg);
        IPackagingItem packagingItem = packagingItemDefinition;
        packagingItem.duplicate(original);
        packagingItem.setName(name);
        if (packagingItemDefinition.getPackagingDetails() != null && !packagingItemDefinition.getPackagingDetails().isEmpty()) {
            List<IPackagingDetailDefinitionHandle> itemHandles = packagingItemDefinition.getPackagingDetails();
            ArrayList<IPackagingDetail> items = new ArrayList<IPackagingDetail>(itemHandles.size());
            for (IPackagingDetailDefinitionHandle itemHandle : itemHandles) {
                if (itemHandle == null || !itemHandle.hasFullState()) continue;
                IPackagingDetailDefinition item = (IPackagingDetailDefinition)itemHandle;
                PackagingDetailLanguage packagingDetailDefinition = new PackagingDetailLanguage(dbg);
                IPackagingDetail packagingDetail = packagingDetailDefinition;
                packagingDetail.duplicate(item);
                items.add(packagingDetail);
                if (item.getFmidoverride() == null) continue;
                if (ItemUtil.isProtected((ItemHandle)((ItemHandle)item))) {
                    ItemUtil.unprotect((ItemHandle)((ItemHandle)item));
                    item.setFmidoverride(PackagingFactory.createFunctionDefinition((IFunctionDefinition)item.getFmidoverride()));
                    item.protect();
                    continue;
                }
                item.setFmidoverride(PackagingFactory.createFunctionDefinition((IFunctionDefinition)item.getFmidoverride()));
            }
            if (ItemUtil.isProtected((ItemHandle)((ItemHandle)packagingItemDefinition))) {
                ItemUtil.unprotect((ItemHandle)((ItemHandle)packagingItemDefinition));
                packagingItemDefinition.getPackagingDetails().clear();
                packagingItemDefinition.getPackagingDetails().addAll(items);
                packagingItemDefinition.protect();
            } else {
                packagingItemDefinition.getPackagingDetails().clear();
                packagingItemDefinition.getPackagingDetails().addAll(items);
            }
        }
        return packagingItemDefinition;
    }

    public static IDataSetDefinition createDatasetDefinition() {
        return new PackagingDataset();
    }

    public static IDataSetDefinition createDatasetDefinition(IDebugger dbg) {
        return new PackagingDataset(dbg);
    }

    public static IDataSetDefinition createDatasetDefinition(IDataSetDefinition original) {
        return new PackagingDataset(original);
    }

    public static IDataSetDefinition createDatasetDefinition(IDataSetDefinition original, IDebugger dbg) {
        return new PackagingDataset(original, dbg);
    }

    public static IFmidItemDefinition createFmidItemDefinition() {
        return new PackagingFmidItem();
    }

    public static IFmidItemDefinition createFmidItemDefinition(IDebugger dbg) {
        return new PackagingFmidItem(dbg);
    }

    public static IFmidItemDefinition createFmidItemDefinition(IFmidItemDefinition original) {
        return new PackagingFmidItem(original);
    }

    public static IFmidItemDefinition createFmidItemDefinition(IFmidItemDefinition original, IDebugger dbg) {
        return new PackagingFmidItem(original, dbg);
    }

    public static IFunctionDefinition createFunctionDefinition() {
        return new PackagingFunction();
    }

    public static IFunctionDefinition createFunctionDefinition(IDebugger dbg) {
        return new PackagingFunction(dbg);
    }

    public static IFunctionDefinition createFunctionDefinition(IFunctionDefinition original) {
        return new PackagingFunction(original);
    }

    public static IFunctionDefinition createFunctionDefinition(IFunctionDefinition original, IDebugger dbg) {
        return new PackagingFunction(original, dbg);
    }

    public static IPackagingDetailDefinition createLanguagePackagingDetailDefinition() {
        return new PackagingDetailLanguage();
    }

    public static IPackagingDetailDefinition createLanguagePackagingDetailDefinition(IDebugger dbg) {
        return new PackagingDetailLanguage(dbg);
    }

    public static IPackagingItemDefinition createLanguagePackagingItemDefinition() {
        return new PackagingItemLanguage();
    }

    public static IPackagingItemDefinition createLanguagePackagingItemDefinition(IDebugger dbg) {
        return new PackagingItemLanguage(dbg);
    }

    public static IPackagingItemDefinition createLanguagePackagingItemDefinition(IPackagingItemDefinition original) {
        return PackagingFactory.createLanguagePackagingItemDefinition(original, (IDebugger)new Debugger(PackagingFactory.class));
    }

    public static IPackagingItemDefinition createLanguagePackagingItemDefinition(IPackagingItemDefinition original, IDebugger dbg) {
        PackagingItemLanguage packagingItem = new PackagingItemLanguage(original, dbg);
        if (packagingItem.getPackagingDetails() != null && !packagingItem.getPackagingDetails().isEmpty()) {
            List<IPackagingDetailDefinitionHandle> itemHandles = packagingItem.getPackagingDetails();
            ArrayList<PackagingDetailLanguage> items = new ArrayList<PackagingDetailLanguage>(itemHandles.size());
            for (IPackagingDetailDefinitionHandle itemHandle : itemHandles) {
                if (itemHandle == null || !itemHandle.hasFullState()) continue;
                IPackagingDetailDefinition item = (IPackagingDetailDefinition)itemHandle;
                if (packagingItem.isWorkingCopy()) {
                    items.add(new PackagingDetailLanguage((IPackagingDetailDefinition)item.getWorkingCopy(), dbg));
                } else {
                    items.add(new PackagingDetailLanguage(item, dbg));
                }
                if (item.getFmidoverride() == null) continue;
                if (ItemUtil.isProtected((ItemHandle)((ItemHandle)item))) {
                    ItemUtil.unprotect((ItemHandle)((ItemHandle)item));
                    item.setFmidoverride(PackagingFactory.createFunctionDefinition((IFunctionDefinition)item.getFmidoverride()));
                    item.protect();
                    continue;
                }
                item.setFmidoverride(PackagingFactory.createFunctionDefinition((IFunctionDefinition)item.getFmidoverride()));
            }
            if (ItemUtil.isProtected((ItemHandle)((ItemHandle)packagingItem))) {
                ItemUtil.unprotect((ItemHandle)((ItemHandle)packagingItem));
                packagingItem.getPackagingDetails().clear();
                packagingItem.getPackagingDetails().addAll(items);
                packagingItem.protect();
            } else {
                packagingItem.getPackagingDetails().clear();
                packagingItem.getPackagingDetails().addAll(items);
            }
        }
        return packagingItem;
    }

    public static IVersionDefinition createVersionDefinition() {
        return new PackagingVersion();
    }

    public static IVersionDefinition createVersionDefinition(IDebugger dbg) {
        return new PackagingVersion(dbg);
    }

    public static IVersionDefinition createVersionDefinition(IVersionDefinition original) {
        return PackagingFactory.createVersionDefinition(original, (IDebugger)new Debugger(PackagingFactory.class));
    }

    public static IVersionDefinition createVersionDefinition(IVersionDefinition original, IDebugger dbg) {
        PackagingVersion version = new PackagingVersion(original, dbg);
        if (version.getFmidItemDefinitions() != null && !version.getFmidItemDefinitions().isEmpty()) {
            List<IFmidItemDefinitionHandle> itemHandles = version.getFmidItemDefinitions();
            ArrayList<PackagingFmidItem> items = new ArrayList<PackagingFmidItem>(itemHandles.size());
            for (IFmidItemDefinitionHandle itemHandle : itemHandles) {
                if (itemHandle == null || !itemHandle.hasFullState()) continue;
                IFmidItemDefinition item = (IFmidItemDefinition)itemHandle;
                if (version.isWorkingCopy()) {
                    items.add(new PackagingFmidItem((IFmidItemDefinition)item.getWorkingCopy(), dbg));
                } else {
                    items.add(new PackagingFmidItem(item, dbg));
                }
                if (item.getFunction() == null) continue;
                if (ItemUtil.isProtected((ItemHandle)((ItemHandle)item))) {
                    ItemUtil.unprotect((ItemHandle)((ItemHandle)item));
                    item.setFunction(PackagingFactory.createFunctionDefinition((IFunctionDefinition)item.getFunction()));
                    item.protect();
                    continue;
                }
                item.setFunction(PackagingFactory.createFunctionDefinition((IFunctionDefinition)item.getFunction()));
            }
            if (ItemUtil.isProtected((ItemHandle)((ItemHandle)version))) {
                ItemUtil.unprotect((ItemHandle)((ItemHandle)version));
                version.getFmidItemDefinitions().clear();
                version.getFmidItemDefinitions().addAll(items);
                version.protect();
            } else {
                version.getFmidItemDefinitions().clear();
                version.getFmidItemDefinitions().addAll(items);
            }
        }
        return version;
    }

    public static void movePackagingDetailDefinition(IPackagingItemDefinition packagingItem, IPackagingDetailDefinition packagingDetail) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)packagingItem))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)packagingItem));
            packagingItem.getPackagingDetails().remove(packagingDetail);
            packagingItem.getPackagingDetailStates().remove(packagingDetail.getItemId().getUuidValue());
            packagingItem.protect();
        } else {
            packagingItem.getPackagingDetails().remove(packagingDetail);
            packagingItem.getPackagingDetailStates().remove(packagingDetail.getItemId().getUuidValue());
        }
    }

    public static void removeFmidItemDefinition(IVersionDefinition version, IFmidItemDefinition fmidItem) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)version))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)version));
            version.getFmidItemDefinitions().remove(fmidItem);
            version.getFmidItemStates().remove(fmidItem.getItemId().getUuidValue());
            version.getFmidItemStates().put("-" + fmidItem.getItemId().getUuidValue(), fmidItem.getItemId());
            version.protect();
        } else {
            version.getFmidItemDefinitions().remove(fmidItem);
            version.getFmidItemStates().remove(fmidItem.getItemId().getUuidValue());
            version.getFmidItemStates().put("-" + fmidItem.getItemId().getUuidValue(), fmidItem.getItemId());
        }
    }

    public static void removePackagingDetailDefinition(IPackagingItemDefinition packagingItem, IPackagingDetailDefinition packagingDetail) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)packagingItem))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)packagingItem));
            packagingItem.getPackagingDetails().remove(packagingDetail);
            packagingItem.getPackagingDetailStates().remove(packagingDetail.getItemId().getUuidValue());
            packagingItem.getPackagingDetailStates().put("-" + packagingDetail.getItemId().getUuidValue(), packagingDetail.getItemId());
            packagingItem.protect();
        } else {
            packagingItem.getPackagingDetails().remove(packagingDetail);
            packagingItem.getPackagingDetailStates().remove(packagingDetail.getItemId().getUuidValue());
            packagingItem.getPackagingDetailStates().put("-" + packagingDetail.getItemId().getUuidValue(), packagingDetail.getItemId());
        }
    }

    public static void removeScopedProperty(IFunctionDefinition function, IScopedProperty scopedProperty) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)function))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)function));
            function.getScopedProperties().remove(scopedProperty);
            function.protect();
        } else {
            function.getScopedProperties().remove(scopedProperty);
        }
    }

    public static void removeScopedProperty(IVersionDefinition version, IScopedProperty scopedProperty) {
        if (ItemUtil.isProtected((ItemHandle)((ItemHandle)version))) {
            ItemUtil.unprotect((ItemHandle)((ItemHandle)version));
            version.getScopedProperties().remove(scopedProperty);
            version.protect();
        } else {
            version.getScopedProperties().remove(scopedProperty);
        }
    }
}

