/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.impl;

import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.Id;
import com.ibm.team.enterprise.systemdefinition.common.model.Mcstype;
import com.ibm.team.enterprise.systemdefinition.common.model.Processor;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import java.util.ArrayList;
import java.util.List;

public class PackagingDetails {
    private final IPackagingItem packagingItem;

    public PackagingDetails(IPackagingItem packagingItem) {
        this.packagingItem = packagingItem;
    }

    public final List<Boolean> getBinary() {
        return this.getCommand(new GetBinary());
    }

    public final List<String> getDescription() {
        return this.getCommand(new GetDescription());
    }

    public final List<IDataSetDefinitionHandle> getDistlib() {
        return this.getCommand(new GetDistlib());
    }

    public final List<String> getDistname() {
        return this.getCommand(new GetDistname());
    }

    public final List<String> getExtension() {
        return this.getCommand(new GetExtension());
    }

    public final List<IFunctionDefinitionHandle> getFmidoverride() {
        return this.getCommand(new GetFmidoverride());
    }

    public final List<String> getFolder() {
        return this.getCommand(new GetFolder());
    }

    public final List<Id> getId() {
        return this.getCommand(new GetId());
    }

    public final List<IDataSetDefinitionHandle> getLocation() {
        return this.getCommand(new GetLocation());
    }

    public final List<String> getName() {
        return this.getCommand(new GetName());
    }

    public final List<Mcstype> getMcstype() {
        return this.getCommand(new GetMcstype());
    }

    public final List<IDataSetDefinitionHandle> getOriginalDistlib() {
        return this.getCommand(new GetOriginalDistlib());
    }

    public final List<IFunctionDefinitionHandle> getOriginalFmidoverride() {
        return this.getCommand(new GetOriginalFmidoverride());
    }

    public final List<IDataSetDefinitionHandle> getOriginalSyslib() {
        return this.getCommand(new GetOriginalSyslib());
    }

    public final List<Processor> getProcessor() {
        return this.getCommand(new GetProcessor());
    }

    public final List<String> getShipalias() {
        return this.getCommand(new GetShipalias());
    }

    public final List<IDataSetDefinitionHandle> getSyslib() {
        return this.getCommand(new GetSyslib());
    }

    public final List<String> getUuid() {
        return this.getCommand(new GetUuid());
    }

    public final List<Boolean> getBinary(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetBinary(), new RemoveBinary(), packagingDetail);
    }

    public final List<String> getDescription(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetDescription(), new RemoveDescription(), packagingDetail);
    }

    public final List<IDataSetDefinitionHandle> getDistlib(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetDistlib(), new RemoveDistlib(), packagingDetail);
    }

    public final List<String> getDistname(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetDistname(), new RemoveDistname(), packagingDetail);
    }

    public final List<String> getExtension(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetExtension(), new RemoveExtension(), packagingDetail);
    }

    public final List<IFunctionDefinitionHandle> getFmidoverride(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetFmidoverride(), new RemoveFmidoverride(), packagingDetail);
    }

    public final List<String> getFolder(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetFolder(), new RemoveFolder(), packagingDetail);
    }

    public final List<Id> getId(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetId(), new RemoveId(), packagingDetail);
    }

    public final List<IDataSetDefinitionHandle> getLocation(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetLocation(), new RemoveLocation(), packagingDetail);
    }

    public final List<String> getName(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetName(), new RemoveName(), packagingDetail);
    }

    public final List<Mcstype> getParttype(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetMcstype(), new RemoveMcstype(), packagingDetail);
    }

    public final List<IDataSetDefinitionHandle> getOriginalDistlib(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetOriginalDistlib(), new RemoveOriginalDistlib(), packagingDetail);
    }

    public final List<IFunctionDefinitionHandle> getOriginalFmidoverride(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetOriginalFmidoverride(), new RemoveOriginalFmidoverride(), packagingDetail);
    }

    public final List<IDataSetDefinitionHandle> getOriginalSyslib(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetOriginalSyslib(), new RemoveOriginalSyslib(), packagingDetail);
    }

    public final List<Processor> getProcessor(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetProcessor(), new RemoveProcessor(), packagingDetail);
    }

    public final List<String> getShipalias(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetShipalias(), new RemoveShipalias(), packagingDetail);
    }

    public final List<IDataSetDefinitionHandle> getSyslib(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetSyslib(), new RemoveSyslib(), packagingDetail);
    }

    public final List<String> getUuid(IPackagingDetail packagingDetail) {
        return this.getCommand(new GetUuid(), new RemoveUuid(), packagingDetail);
    }

    private List<?> getCommand(GetCommand getCommand, RemoveCommand removeCommand, IPackagingDetail packagingDetail) {
        List<?> result = this.getCommand(getCommand);
        removeCommand.execute(result, packagingDetail);
        return result;
    }

    private List<?> getCommand(GetCommand getCommand) {
        ArrayList result = new ArrayList(this.packagingItem.getPackagingDetails().size());
        for (IPackagingDetail iPackagingDetail : this.packagingItem.getPackagingDetails()) {
            getCommand.execute(result, iPackagingDetail);
        }
        return result;
    }

    private class GetBinary
    implements GetCommand<Boolean> {
        private GetBinary() {
        }

        @Override
        public void execute(List<Boolean> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getBinary());
        }
    }

    private static interface GetCommand<L> {
        public void execute(List<L> var1, IPackagingDetail var2);
    }

    private class GetDescription
    implements GetCommand<String> {
        private GetDescription() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getDescription());
        }
    }

    private class GetDistlib
    implements GetCommand<IDataSetDefinitionHandle> {
        private GetDistlib() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getDistlib());
        }
    }

    private class GetDistname
    implements GetCommand<String> {
        private GetDistname() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getDistname());
        }
    }

    private class GetExtension
    implements GetCommand<String> {
        private GetExtension() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getExtension());
        }
    }

    private class GetFmidoverride
    implements GetCommand<IFunctionDefinitionHandle> {
        private GetFmidoverride() {
        }

        @Override
        public void execute(List<IFunctionDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getFmidoverride());
        }
    }

    private class GetFolder
    implements GetCommand<String> {
        private GetFolder() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getFolder());
        }
    }

    private class GetId
    implements GetCommand<Id> {
        private GetId() {
        }

        @Override
        public void execute(List<Id> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getId());
        }
    }

    private class GetLocation
    implements GetCommand<IDataSetDefinitionHandle> {
        private GetLocation() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getLocation());
        }
    }

    private class GetMcstype
    implements GetCommand<Mcstype> {
        private GetMcstype() {
        }

        @Override
        public void execute(List<Mcstype> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getMcstype());
        }
    }

    private class GetName
    implements GetCommand<String> {
        private GetName() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getName());
        }
    }

    private class GetOriginalDistlib
    implements GetCommand<IDataSetDefinitionHandle> {
        private GetOriginalDistlib() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getOriginalDistlib());
        }
    }

    private class GetOriginalFmidoverride
    implements GetCommand<IFunctionDefinitionHandle> {
        private GetOriginalFmidoverride() {
        }

        @Override
        public void execute(List<IFunctionDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getOriginalFmidoverride());
        }
    }

    private class GetOriginalSyslib
    implements GetCommand<IDataSetDefinitionHandle> {
        private GetOriginalSyslib() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getOriginalSyslib());
        }
    }

    private class GetProcessor
    implements GetCommand<Processor> {
        private GetProcessor() {
        }

        @Override
        public void execute(List<Processor> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getProcessor());
        }
    }

    private class GetShipalias
    implements GetCommand<String> {
        private GetShipalias() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getShipalias());
        }
    }

    private class GetSyslib
    implements GetCommand<IDataSetDefinitionHandle> {
        private GetSyslib() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getSyslib());
        }
    }

    private class GetUuid
    implements GetCommand<String> {
        private GetUuid() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.add(packagingDetail.getItemId().getUuidValue());
        }
    }

    private class RemoveBinary
    implements RemoveCommand<Boolean> {
        private RemoveBinary() {
        }

        @Override
        public void execute(List<Boolean> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getBinary());
        }
    }

    private static interface RemoveCommand<L> {
        public void execute(List<L> var1, IPackagingDetail var2);
    }

    private class RemoveDescription
    implements RemoveCommand<String> {
        private RemoveDescription() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getDescription());
        }
    }

    private class RemoveDistlib
    implements RemoveCommand<IDataSetDefinitionHandle> {
        private RemoveDistlib() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getDistlib());
        }
    }

    private class RemoveDistname
    implements RemoveCommand<String> {
        private RemoveDistname() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getDistname());
        }
    }

    private class RemoveExtension
    implements RemoveCommand<String> {
        private RemoveExtension() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getExtension());
        }
    }

    private class RemoveFmidoverride
    implements RemoveCommand<IFunctionDefinitionHandle> {
        private RemoveFmidoverride() {
        }

        @Override
        public void execute(List<IFunctionDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getFmidoverride());
        }
    }

    private class RemoveFolder
    implements RemoveCommand<String> {
        private RemoveFolder() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getFolder());
        }
    }

    private class RemoveId
    implements RemoveCommand<Id> {
        private RemoveId() {
        }

        @Override
        public void execute(List<Id> result, IPackagingDetail packagingDetail) {
            result.remove((Object)packagingDetail.getId());
        }
    }

    private class RemoveLocation
    implements RemoveCommand<IDataSetDefinitionHandle> {
        private RemoveLocation() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getLocation());
        }
    }

    private class RemoveMcstype
    implements RemoveCommand<Mcstype> {
        private RemoveMcstype() {
        }

        @Override
        public void execute(List<Mcstype> result, IPackagingDetail packagingDetail) {
            result.remove((Object)packagingDetail.getMcstype());
        }
    }

    private class RemoveName
    implements RemoveCommand<String> {
        private RemoveName() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getName());
        }
    }

    private class RemoveOriginalDistlib
    implements RemoveCommand<IDataSetDefinitionHandle> {
        private RemoveOriginalDistlib() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getOriginalDistlib());
        }
    }

    private class RemoveOriginalFmidoverride
    implements RemoveCommand<IFunctionDefinitionHandle> {
        private RemoveOriginalFmidoverride() {
        }

        @Override
        public void execute(List<IFunctionDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getOriginalFmidoverride());
        }
    }

    private class RemoveOriginalSyslib
    implements RemoveCommand<IDataSetDefinitionHandle> {
        private RemoveOriginalSyslib() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getOriginalSyslib());
        }
    }

    private class RemoveProcessor
    implements RemoveCommand<Processor> {
        private RemoveProcessor() {
        }

        @Override
        public void execute(List<Processor> result, IPackagingDetail packagingDetail) {
            result.remove((Object)packagingDetail.getProcessor());
        }
    }

    private class RemoveShipalias
    implements RemoveCommand<String> {
        private RemoveShipalias() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getShipalias());
        }
    }

    private class RemoveSyslib
    implements RemoveCommand<IDataSetDefinitionHandle> {
        private RemoveSyslib() {
        }

        @Override
        public void execute(List<IDataSetDefinitionHandle> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getSyslib());
        }
    }

    private class RemoveUuid
    implements RemoveCommand<String> {
        private RemoveUuid() {
        }

        @Override
        public void execute(List<String> result, IPackagingDetail packagingDetail) {
            result.remove(packagingDetail.getItemId().getUuidValue());
        }
    }
}

