/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.impl.DataSetDefinitionImpl;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDataset;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.ItemHandle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PackagingDataset
extends DataSetDefinitionImpl
implements IDataSetDefinition,
IPackagingDataset {
    private final IDebugger dbg;
    private final String simpleName;
    private final boolean initialized;
    private boolean dsDlibReference = false;
    private boolean dsTlibReference = false;
    private Set<String> dsDlibFmidList = new HashSet<String>();
    private Set<String> dsTlibFmidList = new HashSet<String>();

    public PackagingDataset() {
        this((IDebugger)new Debugger(PackagingDataset.class));
    }

    public PackagingDataset(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.initNew();
        this.initialized = true;
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingDataset(IDataSetDefinition original) {
        this(original, (IDebugger)new Debugger(PackagingDataset.class));
    }

    public PackagingDataset(IDataSetDefinition original, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.initialized = true;
        this.copy(original);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IPackagingDataset copy(IDataSetDefinition original) {
        if (original == null) {
            this.initNew();
            this.setDescription("");
            this.setName("");
            this.setAdditionalParm("");
            this.setBlockSize("");
            this.setCompact(false);
            this.setDataClass("");
            this.setDirectoryBlocks("");
            this.setDsMember("");
            this.setDsName("");
            this.setDsType(0);
            this.setExpirationDate("");
            this.setGenericUnit("");
            this.setManagementClass("");
            this.setPrefixDSN(true);
            this.setPrimaryQuantity("");
            this.setRecordFormat("");
            this.setRecordLength("");
            this.setResourceName("");
            this.setSecondaryQuantity("");
            this.setSpaceUnits("");
            this.setStorageClass("");
            this.setUsageType(0);
            this.setVolumeSerial("");
        } else {
            this.setArchived(original.isArchived());
            this.setContextId(original.getContextId());
            this.setDescription(original.getDescription());
            this.setIgnoredOnceForBuild(original.isIgnoredOnceForBuild());
            this.setImmutable(original.isImmutable());
            this.setItemId(original.getItemId());
            this.setMigratedItemId(original.getMigratedItemId());
            this.setMigratedStateId(original.getMigratedStateId());
            this.setModifiedBy(original.getModifiedBy());
            this.setModified(original.getRequestedModified());
            this.setName(original.getName());
            this.setNonImpacting(original.isNonImpacting());
            this.setOrigin(original.getOrigin());
            this.setProjectArea(original.getProjectArea());
            this.setRedactedCopy(original.isRedactedCopy());
            this.setStateId(original.getStateId());
            this.setWorkingCopy(original.isWorkingCopy());
            this.setAdditionalParm(original.getAdditionalParm());
            this.setBlockSize(original.getBlockSize());
            this.setCompact(original.isCompact());
            this.setDataClass(original.getDataClass());
            this.setDirectoryBlocks(original.getDirectoryBlocks());
            this.setDsMember(original.getDsMember());
            this.setDsName(original.getDsName());
            this.setDsType(original.getDsType());
            this.setExpirationDate(original.getExpirationDate());
            this.setGenericUnit(original.getGenericUnit());
            this.setManagementClass(original.getManagementClass());
            this.setPrefixDSN(original.isPrefixDSN());
            this.setPrimaryQuantity(original.getPrimaryQuantity());
            this.setRecordFormat(original.getRecordFormat());
            this.setRecordLength(original.getRecordLength());
            this.setResourceName(original.getResourceName());
            this.setSecondaryQuantity(original.getSecondaryQuantity());
            this.setSpaceUnits(original.getSpaceUnits());
            this.setStorageClass(original.getStorageClass());
            this.setUsageType(original.getUsageType());
            this.setVolumeSerial(original.getVolumeSerial());
            if (original instanceof PackagingDataset) {
                this.setDsDlibReference(((IPackagingDataset)original).getDsDlibReference());
                this.setDsTlibReference(((IPackagingDataset)original).getDsTlibReference());
                this.getDsDlibFmidList().clear();
                this.getDsDlibFmidList().addAll(((IPackagingDataset)original).getDsDlibFmidList());
                this.getDsTlibFmidList().clear();
                this.getDsTlibFmidList().addAll(((IPackagingDataset)original).getDsTlibFmidList());
            }
            if (this.isWorkingCopy()) {
                PackagingDataset auditableThis = this;
                Auditable auditableThat = (Auditable)original;
                auditableThis.setWorkingCopyPredecessor(auditableThat.getWorkingCopyPredecessor());
                auditableThis.setWorkingCopyMergePredecessor(auditableThat.getWorkingCopyMergePredecessor());
                auditableThis.setPredecessor(auditableThat.getPredecessor());
                auditableThis.setMergePredecessor(auditableThat.getMergePredecessor());
                this.protect();
            }
        }
        return this;
    }

    @Override
    public final IPackagingDataset newCopy() {
        return new PackagingDataset(this);
    }

    @Override
    public final ISystemDefinition newInstance() {
        return new PackagingDataset();
    }

    @Override
    public final IPackagingDataset update(IDataSetDefinition updated) {
        this.setArchived(updated.isArchived());
        this.setContextId(updated.getContextId());
        this.setDescription(updated.getDescription());
        this.setIgnoredOnceForBuild(updated.isIgnoredOnceForBuild());
        this.setItemId(updated.getItemId());
        this.setMigratedItemId(updated.getMigratedItemId());
        this.setMigratedStateId(updated.getMigratedStateId());
        this.setName(updated.getName());
        this.setNonImpacting(updated.isNonImpacting());
        this.setOrigin(updated.getOrigin());
        this.setProjectArea(updated.getProjectArea());
        this.setStateId(updated.getStateId());
        this.setAdditionalParm(updated.getAdditionalParm());
        this.setBlockSize(updated.getBlockSize());
        this.setCompact(updated.isCompact());
        this.setDataClass(updated.getDataClass());
        this.setDirectoryBlocks(updated.getDirectoryBlocks());
        this.setDsMember(updated.getDsMember());
        this.setDsName(updated.getDsName());
        this.setDsType(updated.getDsType());
        this.setExpirationDate(updated.getExpirationDate());
        this.setGenericUnit(updated.getGenericUnit());
        this.setManagementClass(updated.getManagementClass());
        this.setPrefixDSN(updated.isPrefixDSN());
        this.setPrimaryQuantity(updated.getPrimaryQuantity());
        this.setRecordFormat(updated.getRecordFormat());
        this.setRecordLength(updated.getRecordLength());
        this.setResourceName(updated.getResourceName());
        this.setSecondaryQuantity(updated.getSecondaryQuantity());
        this.setSpaceUnits(updated.getSpaceUnits());
        this.setStorageClass(updated.getStorageClass());
        this.setUsageType(updated.getUsageType());
        this.setVolumeSerial(updated.getVolumeSerial());
        if (updated instanceof PackagingDataset) {
            this.setDsDlibReference(((IPackagingDataset)updated).getDsDlibReference());
            this.setDsTlibReference(((IPackagingDataset)updated).getDsTlibReference());
            if (ItemUtil.isProtected((ItemHandle)this)) {
                ItemUtil.unprotect((ItemHandle)this);
                this.getDsDlibFmidList().clear();
                this.getDsDlibFmidList().addAll(((IPackagingDataset)updated).getDsDlibFmidList());
                this.getDsTlibFmidList().clear();
                this.getDsTlibFmidList().addAll(((IPackagingDataset)updated).getDsTlibFmidList());
                this.protect();
            } else {
                this.getDsDlibFmidList().clear();
                this.getDsDlibFmidList().addAll(((IPackagingDataset)updated).getDsDlibFmidList());
                this.getDsTlibFmidList().clear();
                this.getDsTlibFmidList().addAll(((IPackagingDataset)updated).getDsTlibFmidList());
            }
        }
        return this;
    }

    @Override
    public final boolean getCompact() {
        return this.isCompact();
    }

    @Override
    public final boolean getPrefixDSN() {
        return this.isPrefixDSN();
    }

    @Override
    public final Set<String> getDsDlibFmidList() {
        return this.dsDlibFmidList;
    }

    @Override
    public final boolean getDsDlibReference() {
        return this.dsDlibReference;
    }

    @Override
    public final Set<String> getDsTlibFmidList() {
        return this.dsTlibFmidList;
    }

    @Override
    public final boolean getDsTlibReference() {
        return this.dsTlibReference;
    }

    @Override
    public final boolean hasDescription() {
        return Verification.isNonBlank((String)this.getDescription());
    }

    @Override
    public final boolean hasName() {
        return Verification.isNonBlank((String)this.getName());
    }

    @Override
    public final boolean hasAdditionalParm() {
        return Verification.isNonBlank((String)this.getAdditionalParm());
    }

    @Override
    public final boolean hasBlockSize() {
        return Verification.isNonBlank((String)this.getBlockSize());
    }

    @Override
    public final boolean hasDataClass() {
        return Verification.isNonBlank((String)this.getDataClass());
    }

    @Override
    public final boolean hasDirectoryBlocks() {
        return Verification.isNonBlank((String)this.getDirectoryBlocks());
    }

    @Override
    public final boolean hasDsMember() {
        return Verification.isNonBlank((String)this.getDsMember());
    }

    @Override
    public final boolean hasDsName() {
        return Verification.isNonBlank((String)this.getDsName());
    }

    @Override
    public final boolean hasExpirationDate() {
        return Verification.isNonBlank((String)this.getExpirationDate());
    }

    @Override
    public final boolean hasGenericUnit() {
        return Verification.isNonBlank((String)this.getGenericUnit());
    }

    @Override
    public final boolean hasManagementClass() {
        return Verification.isNonBlank((String)this.getManagementClass());
    }

    @Override
    public final boolean hasPrimaryQuantity() {
        return Verification.isNonBlank((String)this.getPrimaryQuantity());
    }

    @Override
    public final boolean hasRecordFormat() {
        return Verification.isNonBlank((String)this.getRecordFormat());
    }

    @Override
    public final boolean hasRecordLength() {
        return Verification.isNonBlank((String)this.getRecordLength());
    }

    @Override
    public final boolean hasSecondaryQuantity() {
        return Verification.isNonBlank((String)this.getSecondaryQuantity());
    }

    @Override
    public final boolean hasSpaceUnits() {
        return Verification.isNonBlank((String)this.getSpaceUnits());
    }

    @Override
    public final boolean hasStorageClass() {
        return Verification.isNonBlank((String)this.getStorageClass());
    }

    @Override
    public final boolean hasVolumeSerial() {
        return Verification.isNonBlank((String)this.getVolumeSerial());
    }

    @Override
    public final boolean hasDlibFmid(String fmid) {
        return this.dsDlibFmidList == null ? false : this.dsDlibFmidList.contains(fmid);
    }

    @Override
    public final boolean hasDsDlibFmidList() {
        return Verification.isNonEmpty((List)((List)((Object)this.dsDlibFmidList)));
    }

    @Override
    public final boolean hasTlibFmid(String fmid) {
        return this.dsTlibFmidList == null ? false : this.dsTlibFmidList.contains(fmid);
    }

    @Override
    public final boolean hasDsTlibFmidList() {
        return Verification.isNonEmpty((List)((List)((Object)this.dsTlibFmidList)));
    }

    @Override
    public final boolean isDlib() {
        return this.dsDlibReference;
    }

    @Override
    public final boolean isTlib() {
        return this.dsTlibReference;
    }

    @Override
    public final boolean isDsDlibReference() {
        return this.dsDlibReference;
    }

    @Override
    public final boolean isDsTlibReference() {
        return this.dsTlibReference;
    }

    @Override
    public final void setDescription(String description) {
        super.setDescription(description);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)description)});
        }
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)name)});
        }
    }

    @Override
    public final void setAdditionalParm(String additionalParm) {
        super.setAdditionalParm(additionalParm);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)additionalParm)});
        }
    }

    @Override
    public final void setBlockSize(String blockSize) {
        super.setBlockSize(blockSize);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)blockSize)});
        }
    }

    @Override
    public final void setCompact(boolean compact) {
        super.setCompact(compact);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)compact)});
        }
    }

    @Override
    public final void setDataClass(String dataClass) {
        super.setDataClass(dataClass);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)dataClass)});
        }
    }

    @Override
    public final void setDirectoryBlocks(String directoryBlocks) {
        super.setDirectoryBlocks(directoryBlocks);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)directoryBlocks)});
        }
    }

    @Override
    public final void setDsMember(String dsMember) {
        super.setDsMember(dsMember);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)dsMember)});
        }
    }

    @Override
    public final void setDsName(String dsName) {
        super.setDsName(dsName);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)dsName)});
        }
    }

    @Override
    public final void setDsType(int dsType) {
        super.setDsType(dsType);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((int)dsType)});
        }
    }

    @Override
    public final void setExpirationDate(String expirationDate) {
        super.setExpirationDate(expirationDate);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)expirationDate)});
        }
    }

    @Override
    public final void setGenericUnit(String genericUnit) {
        super.setGenericUnit(genericUnit);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)genericUnit)});
        }
    }

    @Override
    public final void setManagementClass(String managementClass) {
        super.setManagementClass(managementClass);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)managementClass)});
        }
    }

    @Override
    public final void setPrefixDSN(boolean prefixDSN) {
        super.setPrefixDSN(prefixDSN);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)prefixDSN)});
        }
    }

    @Override
    public final void setPrimaryQuantity(String primaryQuantity) {
        super.setPrimaryQuantity(primaryQuantity);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)primaryQuantity)});
        }
    }

    @Override
    public final void setRecordFormat(String recordFormat) {
        super.setRecordFormat(recordFormat);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)recordFormat)});
        }
    }

    @Override
    public final void setRecordLength(String recordLength) {
        super.setRecordLength(recordLength);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)recordLength)});
        }
    }

    @Override
    public final void setSecondaryQuantity(String secondaryQuantity) {
        super.setSecondaryQuantity(secondaryQuantity);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)secondaryQuantity)});
        }
    }

    @Override
    public final void setSpaceUnits(String spaceUnits) {
        super.setSpaceUnits(spaceUnits);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)spaceUnits)});
        }
    }

    @Override
    public final void setStorageClass(String storageClass) {
        super.setStorageClass(storageClass);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)storageClass)});
        }
    }

    @Override
    public final void setUsageType(int usageType) {
        super.setUsageType(usageType);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((int)usageType)});
        }
    }

    @Override
    public final void setVolumeSerial(String volumeSerial) {
        super.setVolumeSerial(volumeSerial);
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)volumeSerial)});
        }
    }

    @Override
    public final void setDsDlibFmidList(Set<String> dsDlibFmidList) {
        this.dsDlibFmidList = dsDlibFmidList;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((int)this.dsDlibFmidList.size())});
        }
    }

    @Override
    public final void setDsDlibReference(boolean dsDlibReference) {
        this.dsDlibReference = dsDlibReference;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.dsDlibReference)});
        }
    }

    @Override
    public final void setDsTlibFmidList(Set<String> dsTlibFmidList) {
        this.dsTlibFmidList = dsTlibFmidList;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((int)this.dsTlibFmidList.size())});
        }
    }

    @Override
    public final void setDsTlibReference(boolean dsTlibReference) {
        this.dsTlibReference = dsTlibReference;
        if (this.initialized && this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (int)this.dbg.getDebugLevel(), (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.dsTlibReference)});
        }
    }

    @Override
    public final String toDsn(String prefix) {
        return this.isPrefixDSN() ? String.valueOf(prefix.toUpperCase()) + "." + this.getDsName().toUpperCase() : this.getDsName().toUpperCase();
    }

    @Override
    public final String toDsnMbr(String prefix, String member) {
        return this.isPrefixDSN() ? String.valueOf(prefix.toUpperCase()) + "." + this.getDsName().toUpperCase() + "(" + member.toUpperCase() + ")" : String.valueOf(this.getDsName().toUpperCase()) + "(" + member.toUpperCase() + ")";
    }

    @Override
    public final String toLibraryName() {
        return this.getDsName().split("\\.")[this.getDsName().split("\\.").length - 1].toUpperCase();
    }

    @Override
    public final String toQuotedDsn(String prefix) {
        return this.isPrefixDSN() ? "'" + prefix.toUpperCase() + "." + this.getDsName().toUpperCase() + "'" : "'" + this.getDsName().toUpperCase() + "'";
    }

    @Override
    public final String toQuotedDsnMbr(String prefix, String member) {
        return this.isPrefixDSN() ? "'" + prefix.toUpperCase() + "." + this.getDsName().toUpperCase() + "(" + member.toUpperCase() + ")" + "'" : "'" + this.getDsName().toUpperCase() + "(" + member.toUpperCase() + ")" + "'";
    }
}

