/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.internal.impl;

import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionLogString;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public class Packaging {
    public static final String className = Packaging.class.getSimpleName();

    public static final boolean containsExtension(String defaultPatterns, String extension) {
        if (defaultPatterns == null || extension == null) {
            return false;
        }
        return Arrays.asList(defaultPatterns.toLowerCase().split(",")).contains(extension.toLowerCase());
    }

    public static final boolean containsExtension(ILanguageDefinition language, String extension) {
        if (language == null) {
            return false;
        }
        if (Verification.isEmpty(language.getDefaultPatterns())) {
            return false;
        }
        for (IStringHelper s : language.getDefaultPatterns()) {
            if (!(s.getValue() == null ? extension == null : s.getValue().trim().equalsIgnoreCase(extension))) continue;
            return true;
        }
        return false;
    }

    public static final boolean containsFolder(ILanguageDefinition language, String folders, String folder) {
        if (language == null || folders == null || folder == null) {
            return false;
        }
        if (Verification.isNonEmpty(language.getDefaultPatterns()) && folder.equalsIgnoreCase(language.getDefaultPatterns().get(0).getValue())) {
            return true;
        }
        return Arrays.asList(folders.toUpperCase().split(",")).contains(folder.toUpperCase());
    }

    public static final boolean containsFolder(ILanguageDefinition language, String folder) {
        if (language == null || folder == null) {
            return false;
        }
        if (!(language instanceof IZosLanguageDefinition)) {
            return false;
        }
        if (Verification.isNonEmpty(language.getDefaultPatterns()) && folder.equalsIgnoreCase(language.getDefaultPatterns().get(0).getValue())) {
            return true;
        }
        if (!((IZosLanguageDefinition)language).hasSmpePackaging()) {
            return false;
        }
        if (!((IZosLanguageDefinition)language).getSmpePackaging().hasFullState()) {
            return false;
        }
        String folders = ((IPackagingItemDefinition)((IZosLanguageDefinition)language).getSmpePackaging()).getFolders();
        if (folders == null) {
            return false;
        }
        return Arrays.asList(folders.toUpperCase().split(",")).contains(folder.toUpperCase());
    }

    public static final List<String> getArrayList(String s) {
        return new ArrayList<String>(Arrays.asList(s.split(",", s.contains(",") ? 1 + s.length() - s.replace(",", "").length() : 0)));
    }

    public static final String getElementFunctionName(IVersionDefinition version, IFmidItemDefinition fmid) {
        return String.valueOf(version.getComponentPrefix()) + "-" + version.getComponentId().replaceFirst(version.getComponentPrefix(), "") + "-" + fmid.getName();
    }

    public static final String[] getFunctionArray(List<?> functions) {
        String[] result = new String[functions.size() + 1];
        result[0] = "";
        int i = 1;
        while (i < functions.size() + 1) {
            result[i] = ((IFunctionDefinition)functions.get(i - 1)).getName();
            ++i;
        }
        return result;
    }

    public static final int getFunctionIndex(List<?> functions, IFunctionDefinitionHandle function) {
        int i = 0;
        while (i < functions.size()) {
            if (((IFunctionDefinition)functions.get(i)).sameItemId((IItemHandle)function)) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    public static final String getFunctionName(List<?> functions, IFunctionDefinitionHandle function) {
        int i = 0;
        while (i < functions.size()) {
            IFunctionDefinition current = (IFunctionDefinition)functions.get(i);
            if (current.sameItemId((IItemHandle)function)) {
                return current.getName();
            }
            ++i;
        }
        return "";
    }

    public static final IFunctionDefinitionHandle getFunctionValue(List<?> functions, int i) {
        if (i > 0) {
            return (IFunctionDefinitionHandle)functions.get(i - 1);
        }
        return null;
    }

    public static final JSONObject getJsonObject(String jsonString) {
        JSONObject jsonObject = new JSONObject();
        if (jsonString != null) {
            try {
                jsonObject = JSONObject.parse((Reader)new StringReader(jsonString));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    public static final String getLabel(IPackagingItem packagingItem) {
        if (packagingItem.getFolderNameExtended() == null) {
            return packagingItem.getName() + "." + SystemDefinitionLogString.getName((Enumerator)packagingItem.getItemtype());
        }
        if (packagingItem.getFileName() == null) {
            return packagingItem.getLanguageItem().getName() + "." + SystemDefinitionLogString.getName((Enumerator)packagingItem.getItemtype()) + "/" + LogString.valueOf((String)packagingItem.getFolderNameExtended());
        }
        return packagingItem.getLanguageItem().getName() + "." + SystemDefinitionLogString.getName((Enumerator)packagingItem.getItemtype()) + "/" + LogString.valueOf((String)packagingItem.getFolderNameExtended()) + "/" + LogString.valueOf((String)packagingItem.getFileName());
    }

    public static final boolean isFunction(List<?> functions, IFunctionDefinition function) {
        int i = 1;
        while (i < functions.size()) {
            if (((IFunctionDefinition)functions.get(i)).sameItemId((IItemHandle)function)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

