/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.helper;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BindingsParser
extends DefaultHandler {
    private final XMLReader parser;
    private String[] bindingValues;
    private String[] bindingQNames;

    public BindingsParser(String[] bindingQNames) throws Exception {
        if (bindingQNames != null) {
            this.bindingQNames = new String[bindingQNames.length];
            System.arraycopy(bindingQNames, 0, this.bindingQNames, 0, bindingQNames.length);
        } else {
            this.bindingQNames = new String[0];
        }
        this.parser = XMLReaderFactory.createXMLReader();
        this.parser.setContentHandler(new BindingContentHandler());
        this.parser.setDTDHandler(this);
        this.parser.setEntityResolver(this);
        this.parser.setErrorHandler(this);
    }

    public String[] getBindingValues(String selectResults) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(selectResults.getBytes("UTF-8"));
        return this.getBindingValues(bais);
    }

    public String[] getBindingValues(InputStream inputStream) throws Exception {
        this.parser.parse(new InputSource(inputStream));
        return this.bindingValues;
    }

    class BindingContentHandler
    implements ContentHandler {
        private int index;

        BindingContentHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            BindingsParser.this.bindingValues = new String[BindingsParser.this.bindingQNames.length];
            this.index = -1;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            int i = 0;
            while (i < BindingsParser.this.bindingQNames.length) {
                if (BindingsParser.this.bindingQNames[i].equals(qName)) {
                    this.index = i;
                }
                ++i;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.index > 0) {
                ((BindingsParser)BindingsParser.this).bindingValues[this.index] = new String(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.index = -1;
            String[] stringArray = BindingsParser.this.bindingValues;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String bindingValue = stringArray[n2];
                if (bindingValue == null) {
                    return;
                }
                ++n2;
            }
            throw new EnoughDataFoundException();
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }

    class EnoughDataFoundException
    extends SAXException {
    }
}

