/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.export.util;

import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.LanguageExtensionDetails;
import com.ibm.team.enterprise.systemdefinition.common.export.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.export.util.AbstractExportSysDefs;
import com.ibm.team.enterprise.systemdefinition.common.export.util.ExportException;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingFactory;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingFunction;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IHFSDD;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFmidItem;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFunction;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingVersion;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ZosExportSysDefs
extends AbstractExportSysDefs {
    private static final String OUTPUT_NAME_ATTR = "outputName";
    private static final String OUTPUT_NAME_KIND_ATTR = "outputNameKind";
    private static final String ALLOCATION_TAG = "allocation";
    private static final String BLOCK_SIZE_ATTR = "blockSize";
    private static final String CALL_METHOD_ATTR = "callMethod";
    private static final String COMMAND_MEMBER_ATTR = "commandMember";
    private static final String ANT_SNIPPET_ATTR = "antSnippet";
    private static final String CONCATENATION = "concatenation";
    private static final String DATA_CLASS_ATTR = "dataClass";
    private static final String DATA_SET_DEFINITION_ATTR = "dataSetDefinition";
    private static final String DDNAMELIST_ATTR = "ddnamelist";
    private static final String DEFAULT_OPTIONS_ATTR = "defaultOptions";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String DIRECTORY_BLOCKS_ATTR = "directoryBlocks";
    private static final String DS_DEF_USAGE_TYPE_ATTR = "dsDefUsageType";
    private static final String DS_MEMBER_ATTR = "dsMember";
    private static final String DS_NAME_ATTR = "dsName";
    private static final String DS_TYPE_ATTR = "dsType";
    private static final String DSDEF = "dsdef";
    private static final String DSDEFS = "dsdefs";
    private static final String GENERIC_UNIT_ATTR = "genericUnit";
    private static final String INPUT_ATTR = "input";
    private static final String KEEP_ATTR = "keep";
    private static final String MOD_ATTR = "mod";
    public static final String LD_NS = "antlib:com.ibm.team.enterprise.zos.systemdefinition.toolkit";
    public static final String LD_PREFIX = "ld";
    private static final String MANAGEMENT_CLASS_ATTR = "managementClass";
    private static final String MAX_RC_ATTR = "maxRC";
    private static final String MEMBER_ATTR = "member";
    private static final String NAME_ATTR = "name";
    private static final String CONDITION_ATTR = "condition";
    private static final String OUTPUT_ATTR = "output";
    private static final String PREFIX_DSN_ATTR = "prefixDSN";
    private static final String PRIMARY_QUANTITY_ATTR = "primaryQuantity";
    private static final String PROPERTY_NAME_ATTR = "propertyName";
    private static final String BUILD_PROPERTY_PREFIX = "${";
    private static final String BUILD_PROPERTY_SUFFIX = "}";
    private static final String PUBLISH_ATTR = "publish";
    private static final String PUBLISH_TYPE_ATTR = "publishType";
    private static final String USED_AS_INPUT_ATTR = "usedAsInput";
    private static final String CONSOLIDATE_LOG_ATTR = "consolidateLog";
    private static final String COMPACT_ATTR = "compact";
    private static final String DEPLOY_TYPE_ATTR = "deployType";
    private static final String RECORD_FORMAT_ATTR = "recordFormat";
    private static final String RECORD_LENGTH_ATTR = "recordLength";
    private static final String SECONDARY_QUANTITY_ATTR = "secondaryQuantity";
    private static final String SPACE_UNITS_ATTR = "spaceUnits";
    private static final String STORAGE_CLASS_ATTR = "storageClass";
    private static final String TRANSLATOR = "translator";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String VOLUME_SERIAL_ATTR = "volumeSerial";
    private static final String LINKEDIT_ATTR = "linkedit";
    private static final String INSTREAMDD_ATTR = "instream";
    private static final String PATH_ATTR = "path";
    private static final String DISP_ATTR = "disp";
    private static final String PERM_ATTR = "perm";
    private static final String OPTIONS_ATTR = "options";
    private static final String FILETYPE_ATTR = "fileType";
    private static final String ISPF_LOG_PUBLISH_TYPE_ATTR = "ispfLogPublishType";
    private static final String ISPF_LOG_CONSOLIDATE_ATTR = "ispfLogConsolidate";
    private static final String ISPF_LOG_COMPACT_ATTR = "ispfLogCompact";
    private static final String COMMA = ",";
    private static final String DSDEFS__TRANSLATORS_LANGDEFS_VERSIONS_FUNCTIONS = "dsdefs,funcdefs,versdefs,translators,langdefs";
    private Element dsdefsTarget;
    private Element functionDefinitionTarget;
    private Element versionDefinitionTarget;
    private List<Element> dsdefsString;
    private List<Element> functionDefinitionString;
    private List<Element> versionDefinitionString;
    private final Map<String, String> datasetMap = new HashMap<String, String>();
    private final Map<String, String> functionMap = new HashMap<String, String>();
    private Supplier<Set<ITranslator>> getTranslators;
    private Function<Object, IDataSetDefinition> getDataSetDefinition;
    private Set<IResourceDefinition> dsDefs;
    private Set<ITranslator> translatorSet;
    private Set<ILanguageDefinition> langDefs;
    private List<IFunctionDefinition> functions;
    private List<IVersionDefinition> versions;

    private ZosExportSysDefs(String file) throws ParserConfigurationException, ExportException {
        this.setFile(file);
        this.checkOutputFile();
        this.createDocument();
    }

    private ZosExportSysDefs(Set<IResourceDefinition> datasets, Set<IFunctionDefinition> functions, String file) throws ParserConfigurationException, ExportException {
        this.setFile(file);
        this.checkOutputFile();
        this.setDataSetMap(datasets);
        this.setFunctionMap(functions);
        this.createDocument();
    }

    private ZosExportSysDefs() throws ParserConfigurationException, ExportException {
        this.setFile(null);
        this.createDocumentForStringExport();
    }

    private ZosExportSysDefs(Set<IResourceDefinition> datasets, Set<IFunctionDefinition> functions) throws ParserConfigurationException, ExportException {
        this.setDataSetMap(datasets);
        this.setFunctionMap(functions);
        this.setFile(null);
        this.createDocumentForStringExport();
    }

    public static ZosExportSysDefs create(Set<IResourceDefinition> datasets, Set<IFunctionDefinition> functions) throws ParserConfigurationException, ExportException {
        return new ZosExportSysDefs(datasets, functions);
    }

    public static ZosExportSysDefs create() throws ParserConfigurationException, ExportException {
        return new ZosExportSysDefs();
    }

    public static ZosExportSysDefs create(Set<IResourceDefinition> datasets, Set<IFunctionDefinition> functions, String file) throws ParserConfigurationException, ExportException {
        return new ZosExportSysDefs(datasets, functions, file);
    }

    public static ZosExportSysDefs create(String file) throws ParserConfigurationException, ExportException {
        return new ZosExportSysDefs(file);
    }

    public ZosExportSysDefs setDataSetMap(Set<IResourceDefinition> datasets) {
        this.datasetMap.putAll(datasets.stream().collect(Collectors.toMap(d -> d.getItemId().getUuidValue(), d -> d.getName())));
        return this;
    }

    public ZosExportSysDefs setFunctionMap(Set<IFunctionDefinition> functions) {
        this.functionMap.putAll(functions.stream().collect(Collectors.toMap(f -> f.getItemId().getUuidValue(), f -> f.getName())));
        return this;
    }

    public ZosExportSysDefs dataSetDefinitions(Set<IResourceDefinition> dsDefs) throws IllegalArgumentException, TeamRepositoryException {
        this.dsDefs = dsDefs != null ? dsDefs : Collections.EMPTY_SET;
        return this;
    }

    public ZosExportSysDefs translators(Set<ITranslator> translators) throws IllegalArgumentException, TeamRepositoryException {
        this.translatorSet = translators != null ? translators : Collections.EMPTY_SET;
        return this;
    }

    public ZosExportSysDefs languageDefinitions(Set<ILanguageDefinition> langDefs) throws IllegalArgumentException, TeamRepositoryException {
        this.langDefs = langDefs != null ? langDefs : Collections.EMPTY_SET;
        return this;
    }

    public ZosExportSysDefs functionDefinitions(List<IFunctionDefinition> functions) throws IllegalArgumentException, TeamRepositoryException {
        this.functions = functions != null ? functions : Collections.EMPTY_LIST;
        return this;
    }

    public ZosExportSysDefs versionDefinitions(List<IVersionDefinition> versions) throws IllegalArgumentException, TeamRepositoryException {
        this.versions = versions != null ? versions : Collections.EMPTY_LIST;
        return this;
    }

    public ZosExportSysDefs setGetTranslatorsFunction(Supplier<Set<ITranslator>> getTranslators) {
        this.getTranslators = getTranslators;
        return this;
    }

    public ZosExportSysDefs setGetDataSetDefinitionFunction(Function<Object, IDataSetDefinition> getDataSetDefinition) {
        this.getDataSetDefinition = getDataSetDefinition;
        return this;
    }

    public ZosExportSysDefs logger(AbstractExportSysDefs.LogFunction<String, AbstractExportSysDefs.LOGGER_INFO> logger) {
        this.setLogger(logger);
        return this;
    }

    public void export() throws IllegalArgumentException, TeamRepositoryException, ExportException {
        if (this.getFile() == null) {
            throw new ExportException(Messages.EXPORT_EXCEPTION_INCORRECT_EXPORT);
        }
        this.addDataSetDefinitions(e -> {
            Node node = this.dsdefsTarget.appendChild((Node)e);
        });
        this.addTranslators(e -> {
            Node node = this.translatorsTarget.appendChild((Node)e);
        });
        this.addLanguageDefinitions(this.langDefs, e -> {
            Node node = this.langdefsTarget.appendChild((Node)e);
        });
        this.addFunctionDefinitions(e -> {
            Node node = this.functionDefinitionTarget.appendChild((Node)e);
        });
        this.addVersionDefinitions(e -> {
            Node node = this.versionDefinitionTarget.appendChild((Node)e);
        });
        this.printDocument();
    }

    public String exportToString() throws IllegalArgumentException, TeamRepositoryException, ExportException {
        return this.exportToString(false);
    }

    public String exportToString(boolean removeNS) throws IllegalArgumentException, TeamRepositoryException, ExportException {
        this.addDataSetDefinitions(e -> {
            boolean bl = this.dsdefsString.add((Element)e);
        });
        this.addTranslators(e -> {
            boolean bl = this.translatorsString.add(e);
        });
        this.addLanguageDefinitions(this.langDefs, e -> {
            boolean bl = this.langdefsString.add(e);
        });
        this.addFunctionDefinitions(e -> {
            boolean bl = this.functionDefinitionString.add((Element)e);
        });
        this.addVersionDefinitions(e -> {
            boolean bl = this.versionDefinitionString.add((Element)e);
        });
        return this.createString(removeNS);
    }

    @Override
    public Set<ITranslator> getTranslators() {
        if (this.getTranslators != null) {
            return this.getTranslators.get();
        }
        return Collections.EMPTY_SET;
    }

    public IDataSetDefinition getDataSetDefinition(Object obj) {
        if (this.getDataSetDefinition != null) {
            return this.getDataSetDefinition.apply(obj);
        }
        return null;
    }

    @Override
    protected void addPlatformDependentTargets(Element projectElement) {
        this.dsdefsTarget = this.getTargetElement();
        this.dsdefsTarget.setAttribute(NAME_ATTR, DSDEFS);
        this.dsdefsTarget.setAttribute(DESCRIPTION_ATTR, Messages.CREATE_DS_DEFS_DESCRIPTION);
        projectElement.appendChild(this.dsdefsTarget);
        this.functionDefinitionTarget = this.getTargetElement();
        this.functionDefinitionTarget.setAttribute(NAME_ATTR, "funcdefs");
        this.functionDefinitionTarget.setAttribute(DESCRIPTION_ATTR, "Function definitions");
        projectElement.appendChild(this.functionDefinitionTarget);
        this.versionDefinitionTarget = this.getTargetElement();
        this.versionDefinitionTarget.setAttribute(NAME_ATTR, "versdefs");
        this.versionDefinitionTarget.setAttribute(DESCRIPTION_ATTR, "Version definitions");
        projectElement.appendChild(this.versionDefinitionTarget);
    }

    @Override
    protected void addPlatformDependentStrings(StringBuilder builder) throws ExportException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        try {
            for (Element e : this.dsdefsString) {
                ZosExportSysDefs.transform(result, e, true);
            }
            for (Element e : this.functionDefinitionString) {
                ZosExportSysDefs.transform(result, e, true);
            }
            for (Element e : this.versionDefinitionString) {
                ZosExportSysDefs.transform(result, e, true);
            }
            builder.append(outputStream.toString("UTF-8"));
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    @Override
    protected void addPlatformDependentTargetsForStringExport() {
        this.dsdefsString = new ArrayList<Element>();
        this.functionDefinitionString = new ArrayList<Element>();
        this.versionDefinitionString = new ArrayList<Element>();
    }

    @Override
    protected String getDefaultTargets() {
        return DSDEFS__TRANSLATORS_LANGDEFS_VERSIONS_FUNCTIONS;
    }

    @Override
    protected String getNamespace() {
        return LD_NS;
    }

    @Override
    protected void addTranslators(Consumer<Element> consumer) throws IllegalArgumentException, TeamRepositoryException {
        if (this.translatorSet != null && this.translatorSet.size() > 0) {
            ITranslator[] translators = new ITranslator[this.translatorSet.size()];
            this.translatorSet.toArray(translators);
            Arrays.sort(translators, 0, translators.length, new Comparator<ITranslator>(){

                @Override
                public int compare(ITranslator t0, ITranslator t1) {
                    return t0.getName().compareTo(t1.getName());
                }
            });
            ITranslator[] iTranslatorArray = translators;
            int n = translators.length;
            int n2 = 0;
            while (n2 < n) {
                ITranslator translator = iTranslatorArray[n2];
                this.log(NLS.bind((String)Messages.TRANSLATOR_FOUND, (Object)translator.getName()), AbstractExportSysDefs.LOGGER_INFO.MSG_INFO);
                consumer.accept(this.getTranslatorTask(translator));
                ++n2;
            }
        }
    }

    @Override
    protected Element getTranslatorTask(ITranslator tr) throws IllegalArgumentException, TeamRepositoryException {
        List<IDDAllocation> allocationList;
        IZosTranslator translator = (IZosTranslator)tr;
        Element element = this.getDocument().createElementNS(LD_NS, TRANSLATOR);
        element.setPrefix(LD_PREFIX);
        element.setAttribute(NAME_ATTR, translator.getName());
        String s = translator.getDescription();
        if (s != null && s.length() > 0) {
            element.setAttribute(DESCRIPTION_ATTR, s);
        }
        int callMethod = translator.getCallMethod();
        element.setAttribute(CALL_METHOD_ATTR, String.valueOf(callMethod));
        switch (callMethod) {
            case 1: 
            case 2: {
                s = translator.getCommandMember();
                if (s != null && s.length() > 0) {
                    element.setAttribute(COMMAND_MEMBER_ATTR, s);
                }
                if (translator.getISPFLogConsolidate() != 0) {
                    element.setAttribute(ISPF_LOG_CONSOLIDATE_ATTR, Integer.toString(translator.getISPFLogConsolidate()));
                }
                if (translator.getISPFLogPublishType() != 1) {
                    element.setAttribute(ISPF_LOG_PUBLISH_TYPE_ATTR, Integer.toString(translator.getISPFLogPublishType()));
                }
                if (!translator.isISPFLogCompact()) break;
                element.setAttribute(ISPF_LOG_COMPACT_ATTR, Boolean.TRUE.toString());
                break;
            }
            case 4: {
                s = translator.getCommandMember();
                if (s != null && s.length() > 0) {
                    element.setAttribute(COMMAND_MEMBER_ATTR, s);
                }
                if ((s = translator.getDdNameList()) != null && s.length() > 0) {
                    element.setAttribute(DDNAMELIST_ATTR, s);
                }
                if ((s = translator.getDefaultOptions()) == null || s.length() <= 0) break;
                element.setAttribute(DEFAULT_OPTIONS_ATTR, s);
                break;
            }
            case 0: {
                IDataSetDefinitionHandle dsd = translator.getDataSetDefinition();
                if (dsd != null) {
                    IDataSetDefinition dsdef = this.getDataSetDefinition(dsd);
                    element.setAttribute(DATA_SET_DEFINITION_ATTR, dsdef.getName());
                }
                if ((s = translator.getDefaultOptions()) != null && s.length() > 0) {
                    element.setAttribute(DEFAULT_OPTIONS_ATTR, s);
                }
                if ((s = translator.getDdNameList()) != null && s.length() > 0) {
                    element.setAttribute(DDNAMELIST_ATTR, s);
                }
                if (!translator.isLinkEdit()) break;
                element.setAttribute(LINKEDIT_ATTR, TRUE);
                break;
            }
            case 3: {
                s = translator.getAntSnippet();
                if (s == null || s.length() <= 0) break;
                element.setAttribute(ANT_SNIPPET_ATTR, s);
            }
        }
        boolean nonImpacting = translator.isNonImpacting();
        if (nonImpacting) {
            element.setAttribute("nonImpacting", Boolean.TRUE.toString());
        }
        element.setAttribute(MAX_RC_ATTR, String.valueOf(translator.getMaxRC()));
        List<IConcatenation> concatenationList = translator.getConcatenations();
        if (concatenationList != null && concatenationList.size() > 0) {
            for (IConcatenation concat : concatenationList) {
                element.appendChild(this.getConcatenationTask(concat));
            }
        }
        if ((allocationList = translator.getDDAllocations()) != null && allocationList.size() > 0) {
            for (IDDAllocation alloc : allocationList) {
                element.appendChild(this.getAllocationTask(alloc));
            }
        }
        this.addVariables(translator, this.getDocument(), element, LD_NS);
        this.addHFSOutputs(translator, this.getDocument(), element, LD_NS);
        return element;
    }

    private Element getConcatenationTask(IConcatenation concat) throws IllegalArgumentException, TeamRepositoryException {
        Document document = this.getDocument();
        Element element = document.createElementNS(LD_NS, CONCATENATION);
        element.setPrefix(LD_PREFIX);
        element.setAttribute(NAME_ATTR, concat.getName());
        if (concat.getCondition() != null && !concat.getCondition().isEmpty()) {
            element.setAttribute(CONDITION_ATTR, concat.getCondition());
        }
        List<IDataDefinitionEntry> entries = concat.getDataDefinitionEntries();
        for (IDataDefinitionEntry entry : entries) {
            Element allocElement = document.createElementNS(LD_NS, ALLOCATION_TAG);
            allocElement.setPrefix(LD_PREFIX);
            this.setDataDefinitonEntry(allocElement, entry);
            element.appendChild(allocElement);
        }
        return element;
    }

    private Element getAllocationTask(IDDAllocation alloc) throws IllegalArgumentException, TeamRepositoryException {
        IHFSDD hfsEntry;
        String s;
        Element element = this.getDocument().createElementNS(LD_NS, ALLOCATION_TAG);
        element.setPrefix(LD_PREFIX);
        element.setAttribute(NAME_ATTR, alloc.getName());
        if (alloc.getCondition() != null && !alloc.getCondition().isEmpty()) {
            element.setAttribute(CONDITION_ATTR, alloc.getCondition());
        }
        if (alloc.isOutput()) {
            element.setAttribute(OUTPUT_ATTR, TRUE);
        }
        if (alloc.isKeep()) {
            element.setAttribute(KEEP_ATTR, TRUE);
        }
        if (alloc.isMod()) {
            element.setAttribute(MOD_ATTR, TRUE);
        }
        if (alloc.isMember()) {
            element.setAttribute(MEMBER_ATTR, TRUE);
        }
        if (alloc.isPublish()) {
            element.setAttribute(PUBLISH_ATTR, TRUE);
            if (1 != alloc.getPublishType()) {
                element.setAttribute(PUBLISH_TYPE_ATTR, String.valueOf(alloc.getPublishType()));
            }
        }
        if (!alloc.isUsedAsInput()) {
            element.setAttribute(USED_AS_INPUT_ATTR, FALSE);
        }
        if (alloc.getConsolidateLog() != 0) {
            element.setAttribute(CONSOLIDATE_LOG_ATTR, Integer.toString(alloc.getConsolidateLog()));
        }
        if (alloc.getCompact() != 0) {
            element.setAttribute(COMPACT_ATTR, Integer.toString(alloc.getCompact()));
        }
        if ((s = alloc.getDeployType()) != null && !s.isEmpty()) {
            element.setAttribute(DEPLOY_TYPE_ATTR, s);
        }
        if (alloc.getOutputNameKind() != OutputNameKind.SAME_AS_INPUT_LITERAL) {
            element.setAttribute(OUTPUT_NAME_KIND_ATTR, alloc.getOutputNameKind().getLiteral());
            if (alloc.getOutputName() != null) {
                element.setAttribute(OUTPUT_NAME_ATTR, alloc.getOutputName());
            }
        }
        if ((hfsEntry = alloc.getHfs()) != null && !hfsEntry.getPath().isEmpty()) {
            this.sethfsEntry(element, hfsEntry);
        } else {
            IDataDefinitionEntry entry = alloc.getDataDefinitionEntry();
            this.setDataDefinitonEntry(element, entry);
        }
        return element;
    }

    private void sethfsEntry(Element element, IHFSDD entry) throws IllegalArgumentException, TeamRepositoryException {
        element.setAttribute(PATH_ATTR, entry.getPath());
        if (entry.getPathDisp() != null) {
            element.setAttribute(DISP_ATTR, entry.getPathDisp().getName());
        }
        if (entry.getPathOpts() != null) {
            String options = null;
            for (IStringHelper s : entry.getPathOpts()) {
                options = options == null || options.isEmpty() ? s.getValue() : String.valueOf(options) + COMMA + s.getValue();
            }
            element.setAttribute(OPTIONS_ATTR, options);
        }
        if (entry.getPathPerm() != null) {
            element.setAttribute(PERM_ATTR, entry.getPathPerm());
        }
        if (entry.getFileType() != null) {
            element.setAttribute(FILETYPE_ATTR, entry.getFileType().getName());
        }
    }

    private void setDataDefinitonEntry(Element element, IDataDefinitionEntry entry) throws IllegalArgumentException, TeamRepositoryException {
        String kind = entry.getKind();
        String value = entry.getValue();
        if ("com.ibm.teamz.langdef.entry.data_definition".equals(kind)) {
            IDataSetDefinition dsdef = this.getDataSetDefinition(UUID.valueOf((String)value));
            element.setAttribute(DATA_SET_DEFINITION_ATTR, dsdef.getName());
            if (entry.isMember()) {
                element.setAttribute(MEMBER_ATTR, TRUE);
            }
        } else if ("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable".equals(kind)) {
            if (value.startsWith(BUILD_PROPERTY_PREFIX) && value.endsWith(BUILD_PROPERTY_SUFFIX)) {
                int len = value.length();
                String valueOnly = value.substring(BUILD_PROPERTY_PREFIX.length(), len - BUILD_PROPERTY_SUFFIX.length());
                element.setAttribute(PROPERTY_NAME_ATTR, valueOnly);
            } else {
                element.setAttribute(PROPERTY_NAME_ATTR, value);
            }
            if (entry.isMember()) {
                element.setAttribute(MEMBER_ATTR, TRUE);
            }
        } else if ("com.ibm.teamz.langdef.entry.constant.instream".equals(kind)) {
            element.setAttribute(INSTREAMDD_ATTR, value);
        } else {
            element.setAttribute(INPUT_ATTR, TRUE);
        }
    }

    private void addDataSetDefinitions(Consumer<Element> consumer) throws IllegalArgumentException, TeamRepositoryException {
        if (this.dsDefs != null && this.dsDefs.size() > 0) {
            IResourceDefinition[] resDefs = new IResourceDefinition[this.dsDefs.size()];
            this.dsDefs.toArray(resDefs);
            Arrays.sort(resDefs, 0, resDefs.length, new Comparator<IResourceDefinition>(){

                @Override
                public int compare(IResourceDefinition r0, IResourceDefinition r1) {
                    return r0.getName().compareTo(r1.getName());
                }
            });
            if (this.dsdefsTarget == null) {
                this.dsdefsTarget = this.getTargetElement();
                this.dsdefsTarget.setAttribute(NAME_ATTR, DSDEFS);
                this.dsdefsTarget.setAttribute(DESCRIPTION_ATTR, Messages.CREATE_DS_DEFS_DESCRIPTION);
            }
            IResourceDefinition[] iResourceDefinitionArray = resDefs;
            int n = resDefs.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDefinition resDef = iResourceDefinitionArray[n2];
                this.log(NLS.bind((String)Messages.DS_DEF_FOUND, (Object)resDef.getName()), AbstractExportSysDefs.LOGGER_INFO.MSG_INFO);
                consumer.accept(this.getDsDefTask(resDef));
                this.dsdefsTarget.appendChild(this.getDsDefTask(resDef));
                ++n2;
            }
        }
    }

    private Element getDsDefTask(IResourceDefinition resDef) throws IllegalArgumentException, TeamRepositoryException {
        boolean compact;
        boolean prefixDSN;
        boolean nonImpacting;
        IDataSetDefinition dsdef = (IDataSetDefinition)resDef;
        Element element = this.getDocument().createElementNS(LD_NS, DSDEF);
        element.setPrefix(LD_PREFIX);
        element.setAttribute(NAME_ATTR, dsdef.getName());
        element.setAttribute(DS_NAME_ATTR, dsdef.getDsName());
        element.setAttribute(DS_DEF_USAGE_TYPE_ATTR, String.valueOf(dsdef.getUsageType()));
        String s = dsdef.getDescription();
        if (s != null && s.length() > 0) {
            element.setAttribute(DESCRIPTION_ATTR, s);
        }
        if ((s = dsdef.getDsMember()) != null && s.length() > 0) {
            element.setAttribute(DS_MEMBER_ATTR, s);
        }
        if (nonImpacting = dsdef.isNonImpacting()) {
            element.setAttribute("nonImpacting", Boolean.TRUE.toString());
        }
        if (!(prefixDSN = dsdef.isPrefixDSN())) {
            element.setAttribute(PREFIX_DSN_ATTR, Boolean.FALSE.toString());
        }
        if (compact = dsdef.isCompact()) {
            element.setAttribute(COMPACT_ATTR, Boolean.TRUE.toString());
        }
        if ((s = dsdef.getGenericUnit()) != null && s.length() > 0) {
            element.setAttribute(GENERIC_UNIT_ATTR, s);
        }
        if ((s = dsdef.getVolumeSerial()) != null && s.length() > 0) {
            element.setAttribute(VOLUME_SERIAL_ATTR, s);
        }
        if (dsdef.getUsageType() != 3) {
            element.setAttribute(DS_TYPE_ATTR, String.valueOf(dsdef.getDsType()));
            s = dsdef.getBlockSize();
            if (s != null && s.length() > 0) {
                element.setAttribute(BLOCK_SIZE_ATTR, s);
            }
            if ((s = dsdef.getDataClass()) != null && s.length() > 0) {
                element.setAttribute(DATA_CLASS_ATTR, s);
            }
            if ((s = dsdef.getDirectoryBlocks()) != null && s.length() > 0) {
                element.setAttribute(DIRECTORY_BLOCKS_ATTR, s);
            }
            if ((s = dsdef.getManagementClass()) != null && s.length() > 0) {
                element.setAttribute(MANAGEMENT_CLASS_ATTR, s);
            }
            if ((s = dsdef.getPrimaryQuantity()) != null && s.length() > 0) {
                element.setAttribute(PRIMARY_QUANTITY_ATTR, s);
            }
            if ((s = dsdef.getRecordFormat()) != null && s.length() > 0) {
                element.setAttribute(RECORD_FORMAT_ATTR, s);
            }
            if ((s = dsdef.getRecordLength()) != null && s.length() > 0) {
                element.setAttribute(RECORD_LENGTH_ATTR, s);
            }
            if ((s = dsdef.getSecondaryQuantity()) != null && s.length() > 0) {
                element.setAttribute(SECONDARY_QUANTITY_ATTR, s);
            }
            if ((s = dsdef.getSpaceUnits()) != null && s.length() > 0) {
                element.setAttribute(SPACE_UNITS_ATTR, s);
            }
            if ((s = dsdef.getStorageClass()) != null && s.length() > 0) {
                element.setAttribute(STORAGE_CLASS_ATTR, s);
            }
        }
        return element;
    }

    @Override
    protected Element addLanguageExtension(Document document, ILanguageDefinition langDef) throws TeamRepositoryException {
        Element languageExtensionElement = null;
        if (langDef instanceof IZosPlatformObject) {
            LanguageExtensionDetails languageExtensionDetails = new LanguageExtensionDetails("zos");
            String className = String.valueOf(languageExtensionDetails.getPackageName()) + "." + languageExtensionDetails.getExportClass();
            String methodName = languageExtensionDetails.getExportMethod();
            Class<?>[] paramTypes = languageExtensionDetails.getExportParamTypes();
            Object[] args = new Object[]{document, langDef};
            languageExtensionElement = this.invokeExportTask(className, methodName, paramTypes, args);
        }
        return languageExtensionElement;
    }

    private void addFunctionDefinitions(Consumer<Element> consumer) throws IllegalArgumentException, TeamRepositoryException {
        if (Verification.isNonEmpty(this.functions)) {
            Collections.sort(this.functions, new Comparator<IFunctionDefinition>(){

                @Override
                public int compare(IFunctionDefinition o1, IFunctionDefinition o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (IFunctionDefinition functionDefinition : this.functions) {
                this.log(NLS.bind((String)Messages.FND_FOUND_FUNCTION_DEFINITION, (Object)functionDefinition.getName()), AbstractExportSysDefs.LOGGER_INFO.MSG_INFO);
                consumer.accept(this.addFunctionDefinition(functionDefinition));
            }
        }
    }

    private Element addFunctionDefinition(IFunctionDefinition functionDefinition) throws IllegalArgumentException, TeamRepositoryException {
        PackagingFunction packagingFunction = new PackagingFunction(functionDefinition);
        Element functionElement = this.getDocument().createElementNS(LD_NS, "function");
        functionElement.setPrefix(LD_PREFIX);
        if (Verification.isNonBlank((String)functionDefinition.getDescription())) {
            functionElement.setAttribute(DESCRIPTION_ATTR, functionDefinition.getDescription());
        }
        if (Verification.isNonBlank((String)functionDefinition.getName())) {
            functionElement.setAttribute(NAME_ATTR, functionDefinition.getName());
        }
        functionElement.setAttribute("nonImpacting", Boolean.toString(functionDefinition.isNonImpacting()));
        if (Verification.isNonBlank((String)packagingFunction.getId())) {
            functionElement.setAttribute("id", packagingFunction.getId());
        }
        if (Verification.isNonBlank((String)packagingFunction.getMcsDescription())) {
            functionElement.setAttribute("mcsDescription", packagingFunction.getMcsDescription());
        }
        if (packagingFunction.hasScopedProperties()) {
            this.addScopedProperties(functionElement, packagingFunction);
        }
        return functionElement;
    }

    private final void addScopedProperties(Element functionElement, IPackagingFunction packagingFunction) {
        for (IScopedProperty scopedProperty : packagingFunction.getScopedProperties()) {
            Element scopedPropertyElement = this.getDocument().createElementNS(LD_NS, "scopedProperty");
            scopedPropertyElement.setPrefix(LD_PREFIX);
            if (Verification.isNonBlank((String)scopedProperty.getCondition())) {
                scopedPropertyElement.setAttribute(CONDITION_ATTR, scopedProperty.getCondition());
            }
            if (Verification.isNonBlank((String)scopedProperty.getName())) {
                scopedPropertyElement.setAttribute(NAME_ATTR, scopedProperty.getName());
            }
            if (Verification.isNonBlank((String)scopedProperty.getValue())) {
                scopedPropertyElement.setAttribute("value", scopedProperty.getValue());
            }
            functionElement.appendChild(scopedPropertyElement);
        }
    }

    private final void addVersionDefinitions(Consumer<Element> consumer) throws IllegalArgumentException, TeamRepositoryException {
        if (Verification.isNonEmpty(this.versions)) {
            Collections.sort(this.versions, new Comparator<IVersionDefinition>(){

                @Override
                public int compare(IVersionDefinition o1, IVersionDefinition o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (IVersionDefinition versionDefinition : this.versions) {
                this.log(NLS.bind((String)Messages.VND_FOUND_VERSION_DEFINITION, (Object)versionDefinition.getName()), AbstractExportSysDefs.LOGGER_INFO.MSG_INFO);
                consumer.accept(this.addVersionDefinition(versionDefinition));
            }
        }
    }

    private final Element addVersionDefinition(IVersionDefinition version) throws IllegalArgumentException, TeamRepositoryException {
        IPackagingVersion packagingVersion = (IPackagingVersion)PackagingFactory.createVersionDefinition(version);
        Element versionElement = this.getDocument().createElementNS(LD_NS, "version");
        versionElement.setPrefix(LD_PREFIX);
        if (Verification.isNonBlank((String)packagingVersion.getDescription())) {
            versionElement.setAttribute(DESCRIPTION_ATTR, packagingVersion.getDescription());
        }
        if (Verification.isNonBlank((String)packagingVersion.getName())) {
            versionElement.setAttribute(NAME_ATTR, packagingVersion.getName());
        }
        versionElement.setAttribute("nonImpacting", Boolean.toString(packagingVersion.isNonImpacting()));
        if (Verification.isNonNull((Object)packagingVersion.getBaseFmid())) {
            versionElement.setAttribute("baseFmid", packagingVersion.getBaseFmidItem().getName());
        }
        if (Verification.isNonNull((Object)packagingVersion.getBaseFunction())) {
            versionElement.setAttribute("baseFunction", this.functionMap.get(packagingVersion.getBaseFunction().getUuid()));
        }
        if (Verification.isNonBlank((String)packagingVersion.getChangeTeam())) {
            versionElement.setAttribute("changeTeam", packagingVersion.getChangeTeam());
        }
        if (Verification.isNonBlank((String)packagingVersion.getComponentId())) {
            versionElement.setAttribute("componentId", packagingVersion.getComponentId());
        }
        if (Verification.isNonBlank((String)packagingVersion.getCopyright())) {
            versionElement.setAttribute("copyright", packagingVersion.getCopyright());
        }
        if (Verification.isNonNull((Object)packagingVersion.getDefaultFunction())) {
            versionElement.setAttribute("defaultFunction", this.functionMap.get(packagingVersion.getDefaultFunction().getUuid()));
        }
        versionElement.setAttribute("extendedService", Boolean.toString(packagingVersion.isExtendedService()));
        versionElement.setAttribute("generallyAvailable", Boolean.toString(packagingVersion.isGenerallyAvailable()));
        if (Verification.isNonBlank((String)packagingVersion.getId())) {
            versionElement.setAttribute("id", packagingVersion.getId());
        }
        if (Verification.isNonNull((Object)packagingVersion.getLevelCreated())) {
            versionElement.setAttribute("levelCreated", Long.toString(packagingVersion.getLevelCreated().getTime()));
        }
        if (Verification.isNonNull((Object)packagingVersion.getLevelCreatedBy())) {
            versionElement.setAttribute("levelCreatedBy", packagingVersion.getLevelCreatedByItem().getUserId());
        }
        if (Verification.isNonNull((Object)((Object)packagingVersion.getLevelStatus()))) {
            versionElement.setAttribute("levelStatus", packagingVersion.getLevelStatus().getName());
        }
        if (Verification.isNonBlank((String)packagingVersion.getLevelSupFile())) {
            versionElement.setAttribute("levelSupFile", packagingVersion.getLevelSupFile());
        }
        if (Verification.isNonBlank((String)packagingVersion.getLevelSupList())) {
            versionElement.setAttribute("levelSupList", packagingVersion.getLevelSupList());
        }
        if (Verification.isNonNull((Object)((Object)packagingVersion.getLevelType()))) {
            versionElement.setAttribute("levelType", packagingVersion.getLevelType().getName());
        }
        versionElement.setAttribute("neverSup", Boolean.toString(packagingVersion.isNeverSup()));
        versionElement.setAttribute("outOfService", Boolean.toString(packagingVersion.isOutOfService()));
        if (Verification.isNonBlank((String)packagingVersion.getReleaseId())) {
            versionElement.setAttribute("releaseId", packagingVersion.getReleaseId());
        }
        versionElement.setAttribute("singleFunction", Boolean.toString(packagingVersion.isSingleFunction()));
        if (Verification.isNonBlank((String)packagingVersion.getSystemRelease())) {
            versionElement.setAttribute("systemRelease", packagingVersion.getSystemRelease());
        }
        if (Verification.isNonBlank((String)packagingVersion.getUsermodPrefix())) {
            versionElement.setAttribute("usermodPrefix", packagingVersion.getUsermodPrefix());
        }
        this.addFmidItems(versionElement, packagingVersion);
        if (packagingVersion.hasScopedProperties()) {
            this.addScopedProperties(versionElement, packagingVersion);
        }
        return versionElement;
    }

    private final void addFmidItems(Element versionElement, IPackagingVersion packagingVersion) throws TeamRepositoryException {
        for (IPackagingFmidItem packagingFmidItem : packagingVersion.getFmidItems()) {
            Element fmidElement = this.getDocument().createElementNS(LD_NS, "fmid");
            fmidElement.setPrefix(LD_PREFIX);
            this.log(NLS.bind((String)Messages.VND_FOUND_FMID_DEFINITION, (Object)packagingFmidItem.getName()), AbstractExportSysDefs.LOGGER_INFO.MSG_INFO);
            if (Verification.isNonBlank((String)packagingFmidItem.getDescription())) {
                fmidElement.setAttribute(DESCRIPTION_ATTR, packagingFmidItem.getDescription());
            }
            if (Verification.isNonBlank((String)packagingFmidItem.getName())) {
                fmidElement.setAttribute(NAME_ATTR, packagingFmidItem.getName());
            }
            fmidElement.setAttribute("nonImpacting", Boolean.toString(packagingFmidItem.isNonImpacting()));
            if (Verification.isNonBlank((String)packagingFmidItem.getAlias())) {
                fmidElement.setAttribute("alias", packagingFmidItem.getAlias());
            }
            fmidElement.setAttribute("base", Boolean.toString(packagingFmidItem.isBase()));
            if (Verification.isNonBlank((String)packagingFmidItem.getFesn())) {
                fmidElement.setAttribute("fesn", packagingFmidItem.getFesn());
            }
            if (Verification.isNonNull((Object)packagingFmidItem.getFunction())) {
                fmidElement.setAttribute("function", this.functionMap.get(packagingFmidItem.getFunction().getUuid()));
            }
            fmidElement.setAttribute("ignore", Boolean.toString(packagingFmidItem.isIgnore()));
            if (Verification.isNonNull((Object)packagingFmidItem.getInitialRevision())) {
                fmidElement.setAttribute("initialRevision", packagingFmidItem.getInitialRevision().toPlainString());
            }
            if (Verification.isNonNull((Object)((Object)packagingFmidItem.getOsPlatform()))) {
                fmidElement.setAttribute("osPlatform", packagingFmidItem.getOsPlatform().getName());
            }
            if (Verification.isNonBlank((String)packagingFmidItem.getRfdsnpfx())) {
                fmidElement.setAttribute("rfdsnpfx", packagingFmidItem.getRfdsnpfx());
            }
            fmidElement.setAttribute("scp", Boolean.toString(packagingFmidItem.isScp()));
            if (packagingFmidItem.hasJclinDistlib()) {
                this.addJclin(fmidElement, packagingFmidItem);
            }
            if (packagingFmidItem.hasMcscpyrt() || packagingFmidItem.hasMcscpyrtLocation()) {
                this.addMcsCpyrt(fmidElement, packagingFmidItem);
            }
            if (packagingFmidItem.hasMcsDel() || packagingFmidItem.hasMcsDelFile()) {
                this.addMcsDel(fmidElement, packagingFmidItem);
            }
            if (packagingFmidItem.hasMcsNpr() || packagingFmidItem.hasMcsNprFile()) {
                this.addMcsNpr(fmidElement, packagingFmidItem);
            }
            if (packagingFmidItem.hasMcsPre() || packagingFmidItem.hasMcsPreFile()) {
                this.addMcsPre(fmidElement, packagingFmidItem);
            }
            if (packagingFmidItem.hasMcsReq() || packagingFmidItem.hasMcsReqFile()) {
                this.addMcsReq(fmidElement, packagingFmidItem);
            }
            if (packagingFmidItem.hasMcsSup() || packagingFmidItem.hasMcsSupFile()) {
                this.addMcsSup(fmidElement, packagingFmidItem);
            }
            if (packagingFmidItem.hasMcsVer() || packagingFmidItem.hasMcsVerFile()) {
                this.addMcsVer(fmidElement, packagingFmidItem);
            }
            if (packagingFmidItem.hasRelfiles()) {
                this.addRelFiles(fmidElement, packagingFmidItem);
            }
            versionElement.appendChild(fmidElement);
        }
    }

    private final void addJclin(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        Element jclinElement = this.getDocument().createElementNS(LD_NS, "jclin");
        jclinElement.setPrefix(LD_PREFIX);
        fmidElement.appendChild(jclinElement);
        jclinElement.setAttribute("calllibs", Boolean.toString(packagingFmidItem.isJclinCalllibs()));
        if (Verification.isNonNull((Object)packagingFmidItem.getJclinDistlib())) {
            jclinElement.setAttribute("distlib", this.datasetMap.get(packagingFmidItem.getJclinDistlib().getItemId().getUuidValue()));
        }
        if (Verification.isNonBlank((String)packagingFmidItem.getJclinId())) {
            jclinElement.setAttribute("id", packagingFmidItem.getJclinId());
        }
        jclinElement.setAttribute("inSource", Boolean.toString(packagingFmidItem.isJclinInSource()));
        if (Verification.isNonNull((Object)packagingFmidItem.getJclinLocation())) {
            jclinElement.setAttribute("location", this.datasetMap.get(packagingFmidItem.getJclinLocation().getItemId().getUuidValue()));
        }
    }

    private final void addMcsCpyrt(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        Element mcsCpyrtElement = this.getDocument().createElementNS(LD_NS, "mcscpyrt");
        mcsCpyrtElement.setPrefix(LD_PREFIX);
        fmidElement.appendChild(mcsCpyrtElement);
        if (Verification.isNonBlank((String)packagingFmidItem.getMcscpyrtId())) {
            mcsCpyrtElement.setAttribute("id", packagingFmidItem.getMcscpyrtId());
        }
        if (Verification.isNonNull((Object)packagingFmidItem.getMcscpyrtLocation())) {
            mcsCpyrtElement.setAttribute("location", this.datasetMap.get(packagingFmidItem.getMcscpyrtLocation().getItemId().getUuidValue()));
        }
        if (Verification.isNonBlank((String)packagingFmidItem.getMcscpyrt())) {
            mcsCpyrtElement.setAttribute("text", packagingFmidItem.getMcscpyrt());
        }
    }

    private final void addMcsDel(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        Element mcsdelElement = this.getDocument().createElementNS(LD_NS, "mcsdel");
        mcsdelElement.setPrefix(LD_PREFIX);
        fmidElement.appendChild(mcsdelElement);
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsDelFile())) {
            mcsdelElement.setAttribute("file", packagingFmidItem.getMcsDelFile());
        }
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsDel())) {
            mcsdelElement.setAttribute("text", packagingFmidItem.getMcsDel());
        }
    }

    private final void addMcsNpr(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        Element mcsnprElement = this.getDocument().createElementNS(LD_NS, "mcsnpr");
        mcsnprElement.setPrefix(LD_PREFIX);
        fmidElement.appendChild(mcsnprElement);
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsNprFile())) {
            mcsnprElement.setAttribute("file", packagingFmidItem.getMcsNprFile());
        }
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsNpr())) {
            mcsnprElement.setAttribute("text", packagingFmidItem.getMcsNpr());
        }
    }

    private final void addMcsPre(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        Element mcspreElement = this.getDocument().createElementNS(LD_NS, "mcspre");
        mcspreElement.setPrefix(LD_PREFIX);
        fmidElement.appendChild(mcspreElement);
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsPreFile())) {
            mcspreElement.setAttribute("file", packagingFmidItem.getMcsPreFile());
        }
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsPre())) {
            mcspreElement.setAttribute("text", packagingFmidItem.getMcsPre());
        }
    }

    private final void addMcsReq(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        Element mcsreqElement = this.getDocument().createElementNS(LD_NS, "mcsreq");
        mcsreqElement.setPrefix(LD_PREFIX);
        fmidElement.appendChild(mcsreqElement);
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsReqFile())) {
            mcsreqElement.setAttribute("file", packagingFmidItem.getMcsReqFile());
        }
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsReq())) {
            mcsreqElement.setAttribute("text", packagingFmidItem.getMcsReq());
        }
    }

    private final void addMcsSup(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        Element mcssupElement = this.getDocument().createElementNS(LD_NS, "mcssup");
        mcssupElement.setPrefix(LD_PREFIX);
        fmidElement.appendChild(mcssupElement);
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsSupFile())) {
            mcssupElement.setAttribute("file", packagingFmidItem.getMcsSupFile());
        }
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsSup())) {
            mcssupElement.setAttribute("text", packagingFmidItem.getMcsSup());
        }
    }

    private final void addMcsVer(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        Element mcsverElement = this.getDocument().createElementNS(LD_NS, "mcsver");
        mcsverElement.setPrefix(LD_PREFIX);
        fmidElement.appendChild(mcsverElement);
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsVerFile())) {
            mcsverElement.setAttribute("file", packagingFmidItem.getMcsVerFile());
        }
        if (Verification.isNonBlank((String)packagingFmidItem.getMcsVer())) {
            mcsverElement.setAttribute("text", packagingFmidItem.getMcsVer());
        }
    }

    private final void addRelFiles(Element fmidElement, IPackagingFmidItem packagingFmidItem) {
        for (IDataSetDefinition relfile : packagingFmidItem.getRelfileItems()) {
            Element relfileElement = this.getDocument().createElementNS(LD_NS, "relfile");
            relfileElement.setPrefix(LD_PREFIX);
            if (Verification.isNonNull((Object)relfile)) {
                relfileElement.setAttribute(DSDEF, relfile.getName());
            }
            fmidElement.appendChild(relfileElement);
        }
    }

    private final void addScopedProperties(Element versionElement, IPackagingVersion packagingVersion) {
        for (IScopedProperty scopedProperty : packagingVersion.getScopedProperties()) {
            Element scopedPropertyElement = this.getDocument().createElementNS(LD_NS, "scopedProperty");
            scopedPropertyElement.setPrefix(LD_PREFIX);
            if (Verification.isNonBlank((String)scopedProperty.getCondition())) {
                scopedPropertyElement.setAttribute(CONDITION_ATTR, scopedProperty.getCondition());
            }
            if (Verification.isNonBlank((String)scopedProperty.getName())) {
                scopedPropertyElement.setAttribute(NAME_ATTR, scopedProperty.getName());
            }
            if (Verification.isNonBlank((String)scopedProperty.getValue())) {
                scopedPropertyElement.setAttribute("value", scopedProperty.getValue());
            }
            versionElement.appendChild(scopedPropertyElement);
        }
    }
}

