/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.export.util;

import com.ibm.team.enterprise.systemdefinition.common.export.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.export.util.AbstractExportSysDefs;
import com.ibm.team.enterprise.systemdefinition.common.export.util.ExportException;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.common.util.SearchPathUtils;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IbmiExportSysDefs
extends AbstractExportSysDefs {
    private static final String BUILD_PROPERTY_SUFFIX = "}";
    private static final String BUILD_PROPERTY_PREFIX = "${";
    private static final String OUTPUT_NAME_ATTR = "outputName";
    private static final String OUTPUT_NAME_KIND_ATTR = "outputNameKind";
    private static final String OUTPUT_TYPE_ATTR = "outputtype";
    private static final String DEPLOY_TYPE_ATTR = "deployType";
    private static final String SEARCH_PATH_ATTR = "searchpath";
    private static final String INTROSPECTION_ATTR = "introspection";
    private static final String COMMANDIFOBJECTEXISTS_ATTR = "commandifobjectexists";
    private static final String COMMANDIFOBJECTDOESNTEXIST_ATTR = "commandifobjectdoesntexist";
    private static final String TRANSLATOR = "translator";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String NAME_ATTR = "name";
    private static final String LD_PREFIX = "ld";
    private static final String LD_NS = "antlib:com.ibm.team.enterprise.ibmi.systemdefinition.toolkit";
    private static final String RESDEFS = "resdefs";
    private static final String SEARCHPATHS = "searchpaths";
    private static final String RESDEF = "resdef";
    private static final String RESOURCENAME = "resourcename";
    private static final String USAGETYPE = "usagetype";
    private static final String SEARCHPATH = "searchpath";
    private static final String RESOURCEDEFINITIONS_ATTR = "resourcedefinitions";
    private static final String SOURCE_LIBRARY_ATTR = "sourcelibrary";
    private static final String OBJECT_LIBRARY_ATTR = "objectlibrary";
    public static final String PROPERTY_SEARCH_PATH = "com.ibm.team.enterprise.ibmi.build.searchPath";
    private static final String COMMA = ",";
    private static final String ZERO_LENGTH_STRING = "";
    private static final String RESDEFS_SEARCHPATHS_TRANSLATORS_LANGDEFS = "resdefs,searchpaths,translators,langdefs";
    private Element resdefsTarget;
    private Element searchpathsTarget;
    private Set<ITranslator> translatorSet;
    private Set<IResourceDefinition> resDefSet;
    private Set<ISearchPath> searchPathSet;
    private Set<ILanguageDefinition> langDefs;
    private Supplier<Set<ISearchPath>> getSearchPaths;
    private Supplier<Set<IResourceDefinition>> getResourceDefinitions;
    private Supplier<Set<ITranslator>> getTranslators;

    @Override
    protected Set<ITranslator> getTranslators() {
        if (this.getTranslators != null) {
            return this.getTranslators.get();
        }
        return Collections.emptySet();
    }

    protected Set<ISearchPath> getSearchPaths() {
        if (this.getSearchPaths != null) {
            return this.getSearchPaths.get();
        }
        return Collections.emptySet();
    }

    protected Set<IResourceDefinition> getResourceDefinitions() {
        if (this.getResourceDefinitions != null) {
            return this.getResourceDefinitions.get();
        }
        return Collections.emptySet();
    }

    private IbmiExportSysDefs(String file) throws ParserConfigurationException, ExportException {
        this.setFile(file);
        this.checkOutputFile();
        this.createDocument();
    }

    public static IbmiExportSysDefs create(String file) throws ParserConfigurationException, ExportException {
        return new IbmiExportSysDefs(file);
    }

    public IbmiExportSysDefs resourceDefinitions(Set<IResourceDefinition> resDefSet) {
        this.resDefSet = resDefSet != null ? resDefSet : Collections.emptySet();
        return this;
    }

    public IbmiExportSysDefs searchPaths(Set<ISearchPath> searchPathSet) {
        this.searchPathSet = searchPathSet != null ? searchPathSet : Collections.emptySet();
        return this;
    }

    public IbmiExportSysDefs translators(Set<ITranslator> translatorSet) {
        this.translatorSet = translatorSet != null ? translatorSet : Collections.emptySet();
        return this;
    }

    public IbmiExportSysDefs languageDefinitions(Set<ILanguageDefinition> langDefs) {
        this.langDefs = langDefs != null ? langDefs : Collections.emptySet();
        return this;
    }

    public IbmiExportSysDefs setGetTranslatorsFunction(Supplier<Set<ITranslator>> getTranslators) {
        this.getTranslators = getTranslators;
        return this;
    }

    public IbmiExportSysDefs setGetSearchPathsFunction(Supplier<Set<ISearchPath>> getSearchPaths) {
        this.getSearchPaths = getSearchPaths;
        return this;
    }

    public IbmiExportSysDefs setGetDataSetDefinitionFunction(Supplier<Set<IResourceDefinition>> getResourceDefinitions) {
        this.getResourceDefinitions = getResourceDefinitions;
        return this;
    }

    public IbmiExportSysDefs logger(AbstractExportSysDefs.LogFunction<String, AbstractExportSysDefs.LOGGER_INFO> logger) {
        this.setLogger(logger);
        return this;
    }

    public void export() throws ExportException, IllegalArgumentException, TeamRepositoryException {
        this.addResourceDefinitions();
        this.addSearchPaths();
        this.addTranslators(e -> {
            Node node = this.getTranslatorsTarget().appendChild((Node)e);
        });
        this.addLanguageDefinitions(this.langDefs, e -> {
            Node node = this.langdefsTarget.appendChild((Node)e);
        });
        this.printDocument();
    }

    @Override
    protected void addPlatformDependentTargets(Element projectElement) {
        this.resdefsTarget = this.getTargetElement();
        this.resdefsTarget.setAttribute(NAME_ATTR, RESDEFS);
        this.resdefsTarget.setAttribute(DESCRIPTION_ATTR, Messages.CREATE_RES_DEFS_DESCRIPTION);
        projectElement.appendChild(this.resdefsTarget);
        this.searchpathsTarget = this.getTargetElement();
        this.searchpathsTarget.setAttribute(NAME_ATTR, SEARCHPATHS);
        this.searchpathsTarget.setAttribute(DESCRIPTION_ATTR, Messages.CREATE_SEARCH_PATHS_DESCRIPTION);
        projectElement.appendChild(this.searchpathsTarget);
    }

    @Override
    protected String getDefaultTargets() {
        return RESDEFS_SEARCHPATHS_TRANSLATORS_LANGDEFS;
    }

    @Override
    protected String getNamespace() {
        return LD_NS;
    }

    @Override
    protected void addTranslators(Consumer<Element> consumer) throws IllegalArgumentException, TeamRepositoryException {
        if (this.translatorSet != null && this.translatorSet.size() > 0) {
            ITranslator[] translators = new ITranslator[this.translatorSet.size()];
            this.translatorSet.toArray(translators);
            Arrays.sort(translators, 0, translators.length, new Comparator<ITranslator>(){

                @Override
                public int compare(ITranslator t0, ITranslator t1) {
                    return t0.getName().compareTo(t1.getName());
                }
            });
            ITranslator[] iTranslatorArray = translators;
            int n = translators.length;
            int n2 = 0;
            while (n2 < n) {
                ITranslator translator = iTranslatorArray[n2];
                this.log(NLS.bind((String)Messages.TRANSLATOR_FOUND, (Object)translator.getName()), AbstractExportSysDefs.LOGGER_INFO.MSG_INFO);
                consumer.accept(this.getTranslatorTask(translator));
                ++n2;
            }
        }
    }

    @Override
    protected Element getTranslatorTask(ITranslator translator) throws IllegalArgumentException, TeamRepositoryException {
        boolean needsIntrospection;
        boolean nonImpacting;
        Document document = this.getDocument();
        Element element = document.createElementNS(LD_NS, TRANSLATOR);
        element.setPrefix(LD_PREFIX);
        element.setAttribute(NAME_ATTR, translator.getName());
        String s = translator.getDescription();
        if (s != null && s.length() > 0) {
            element.setAttribute(DESCRIPTION_ATTR, s);
        }
        if (nonImpacting = translator.isNonImpacting()) {
            element.setAttribute("nonImpacting", Boolean.TRUE.toString());
        }
        if (needsIntrospection = ((IIBMiTranslator)translator).isIntrospection()) {
            element.setAttribute(INTROSPECTION_ATTR, Boolean.TRUE.toString());
        }
        if ((s = ((IIBMiTranslator)translator).getCommandIfObjectExists()) != null && s.length() > 0) {
            element.setAttribute(COMMANDIFOBJECTEXISTS_ATTR, s);
        }
        if ((s = ((IIBMiTranslator)translator).getCommandIfObjectDoesntExist()) != null && s.length() > 0) {
            element.setAttribute(COMMANDIFOBJECTDOESNTEXIST_ATTR, s);
        }
        if ((s = ((IIBMiTranslator)translator).getSearchPath()) != null && s.length() > 0) {
            if (this.isValidBuildProperty(s)) {
                String propertyName = this.getBuildPropertyName(s);
                if (!PROPERTY_SEARCH_PATH.equals(propertyName)) {
                    element.setAttribute("searchpath", propertyName);
                }
            } else {
                Set<ISearchPath> searchPaths = this.getSearchPaths();
                ISearchPath searchPath = null;
                if (searchPaths != null) {
                    for (ISearchPath sp : searchPaths) {
                        if (!s.equals(sp.getItemId().getUuidValue())) continue;
                        searchPath = sp;
                        break;
                    }
                }
                if (searchPath != null) {
                    element.setAttribute("searchpath", searchPath.getName());
                }
            }
        }
        this.addVariables(translator, document, element, LD_NS);
        if (((IIBMiTranslator)translator).getOutputNameKind() != OutputNameKind.SAME_AS_INPUT_LITERAL) {
            element.setAttribute(OUTPUT_NAME_KIND_ATTR, ((IIBMiTranslator)translator).getOutputNameKind().getLiteral());
            if (((IIBMiTranslator)translator).getOutputName() != null) {
                element.setAttribute(OUTPUT_NAME_ATTR, ((IIBMiTranslator)translator).getOutputName());
            }
        }
        element.setAttribute(OUTPUT_TYPE_ATTR, ((IIBMiTranslator)translator).getOutputType());
        s = ((IIBMiTranslator)translator).getDeployType();
        if (s != null && s.length() > 0) {
            element.setAttribute(DEPLOY_TYPE_ATTR, s);
        }
        return element;
    }

    private boolean isValidBuildProperty(String value) {
        return value != null && value.startsWith(BUILD_PROPERTY_PREFIX) && value.endsWith(BUILD_PROPERTY_SUFFIX);
    }

    private String getBuildPropertyName(String value) {
        if (this.isValidBuildProperty(value)) {
            return value.substring(2, value.length() - 1);
        }
        return null;
    }

    private void addResourceDefinitions() throws IllegalArgumentException, TeamRepositoryException {
        if (this.resDefSet != null && this.resDefSet.size() > 0) {
            IResourceDefinition[] resDefs = new IResourceDefinition[this.resDefSet.size()];
            this.resDefSet.toArray(resDefs);
            Arrays.sort(resDefs, 0, resDefs.length, new Comparator<IResourceDefinition>(){

                @Override
                public int compare(IResourceDefinition r0, IResourceDefinition r1) {
                    return r0.getName().compareTo(r1.getName());
                }
            });
            IResourceDefinition[] iResourceDefinitionArray = resDefs;
            int n = resDefs.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDefinition resDef = iResourceDefinitionArray[n2];
                this.log(NLS.bind((String)Messages.RES_DEF_FOUND, (Object)resDef.getName()), AbstractExportSysDefs.LOGGER_INFO.MSG_INFO);
                this.resdefsTarget.appendChild(this.getResDefTask(resDef));
                ++n2;
            }
        }
    }

    private void addSearchPaths() throws IllegalArgumentException, TeamRepositoryException {
        if (this.searchPathSet != null && this.searchPathSet.size() > 0) {
            ISearchPath[] searchPaths = new ISearchPath[this.searchPathSet.size()];
            this.searchPathSet.toArray(searchPaths);
            Arrays.sort(searchPaths, 0, searchPaths.length, new Comparator<ISearchPath>(){

                @Override
                public int compare(ISearchPath s0, ISearchPath s1) {
                    return s0.getName().compareTo(s1.getName());
                }
            });
            ISearchPath[] iSearchPathArray = searchPaths;
            int n = searchPaths.length;
            int n2 = 0;
            while (n2 < n) {
                ISearchPath searchPath = iSearchPathArray[n2];
                this.log(NLS.bind((String)Messages.SEARCH_PATH_FOUND, (Object)searchPath.getName()), AbstractExportSysDefs.LOGGER_INFO.MSG_INFO);
                this.searchpathsTarget.appendChild(this.getSearchPathTask(searchPath));
                ++n2;
            }
        }
    }

    private Element getResDefTask(IResourceDefinition resDef) throws IllegalArgumentException, TeamRepositoryException {
        boolean nonImpacting;
        Element element = this.getDocument().createElementNS(LD_NS, RESDEF);
        element.setPrefix(LD_PREFIX);
        element.setAttribute(NAME_ATTR, resDef.getName());
        String s = resDef.getDescription();
        if (s != null && s.length() > 0) {
            element.setAttribute(DESCRIPTION_ATTR, s);
        }
        if (nonImpacting = resDef.isNonImpacting()) {
            element.setAttribute("nonImpacting", Boolean.TRUE.toString());
        }
        element.setAttribute(RESOURCENAME, resDef.getResourceName());
        element.setAttribute(USAGETYPE, String.valueOf(resDef.getUsageType()));
        return element;
    }

    private Element getSearchPathTask(ISearchPath searchPath) throws IllegalArgumentException, TeamRepositoryException {
        Set<IResourceDefinition> defs;
        List<String> resDefUuids;
        boolean nonImpacting;
        Element element = this.getDocument().createElementNS(LD_NS, "searchpath");
        element.setPrefix(LD_PREFIX);
        element.setAttribute(NAME_ATTR, searchPath.getName());
        String s = searchPath.getDescription();
        if (s != null && s.length() > 0) {
            element.setAttribute(DESCRIPTION_ATTR, s);
        }
        if (nonImpacting = searchPath.isNonImpacting()) {
            element.setAttribute("nonImpacting", Boolean.TRUE.toString());
        }
        String sourceLibraryUuid = (String)searchPath.getProperties().get("source.library.key");
        String objectLibraryUuid = (String)searchPath.getProperties().get("object.library.key");
        List<String> list = resDefUuids = sourceLibraryUuid == null && objectLibraryUuid == null ? SystemDefinitionUtil.toStringArray(searchPath.getPath()) : SearchPathUtils.getReferencedLibrariesUUIDs(searchPath);
        if (resDefUuids != null) {
            s = ZERO_LENGTH_STRING;
            block0: for (String uuid : resDefUuids) {
                if (s.length() > 0) {
                    s = String.valueOf(s) + COMMA;
                }
                Set<IResourceDefinition> defs2 = this.getResourceDefinitions();
                for (IResourceDefinition def : defs2) {
                    if (!uuid.equals(def.getItemId().getUuidValue())) continue;
                    s = String.valueOf(s) + def.getName();
                    continue block0;
                }
            }
            element.setAttribute(RESOURCEDEFINITIONS_ATTR, s);
        }
        if (sourceLibraryUuid != null) {
            if (!sourceLibraryUuid.trim().isEmpty()) {
                defs = this.getResourceDefinitions();
                for (IResourceDefinition def : defs) {
                    if (!sourceLibraryUuid.equals(def.getItemId().getUuidValue())) continue;
                    element.setAttribute(SOURCE_LIBRARY_ATTR, def.getName());
                    break;
                }
            } else {
                element.setAttribute(SOURCE_LIBRARY_ATTR, ZERO_LENGTH_STRING);
            }
        }
        if (objectLibraryUuid != null) {
            if (!objectLibraryUuid.trim().isEmpty()) {
                defs = this.getResourceDefinitions();
                for (IResourceDefinition def : defs) {
                    if (!objectLibraryUuid.equals(def.getItemId().getUuidValue())) continue;
                    element.setAttribute(OBJECT_LIBRARY_ATTR, def.getName());
                    break;
                }
            } else {
                element.setAttribute(OBJECT_LIBRARY_ATTR, ZERO_LENGTH_STRING);
            }
        }
        return element;
    }

    @Override
    protected Element addLanguageExtension(Document document, ILanguageDefinition langDef) throws TeamRepositoryException {
        return null;
    }

    @Override
    protected void addPlatformDependentTargetsForStringExport() {
    }

    @Override
    protected void addPlatformDependentStrings(StringBuilder builder) throws ExportException {
    }
}

