/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.export.util;

import com.ibm.team.enterprise.systemdefinition.common.export.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.export.util.ExportException;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.IHFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractExportSysDefs {
    private static final String VARIABLE = "variable";
    private static final String HFSOUTPUT = "hfsOutput";
    private static final String VALUE_ATTR = "value";
    private static final String CONDITION_ATTR = "condition";
    private static final String PATH_ATTR = "path";
    private static final String DEPLOYTYPE_ATTR = "deployType";
    private static final String FULL_BUILD = "full build";
    private static final String SCANNER = "scanner";
    private static final String BUILD_PROPERTY_SUFFIX = "}";
    private static final String BUILD_PROPERTY_PREFIX = "${";
    private static final String LANGUAGE_CODE_ATTR = "languageCode";
    private static final String DEFAULT_PATTERNS_ATTR = "defaultpatterns";
    private static final String LANGDEF = "langdef";
    private static final String DEPENDS_ATTR = "depends";
    private static final String LANGDEFS = "langdefs";
    private static final String TRANSLATORS = "translators";
    private static final String CONDITIONS = "conditions";
    private static final String STEPNAMES = "stepNames";
    private static final String PROJECT_AREA_PROPERTY = "${projectArea}";
    private static final String PROJECT_AREA = "projectArea";
    private static final String PASSWORD_PROPERTY = "${password}";
    private static final String PASSWORD = "password";
    private static final String USER_ID_PROPERTY = "${userId}";
    private static final String USER_ID = "userId";
    private static final String REPOSITORY_ADDRESS_PROPERTY = "${repositoryAddress}";
    private static final String REPOSITORY_ADDRESS = "repositoryAddress";
    private static final String INIT = "init";
    private static final String EXPORTED2 = "Exported";
    private static final String XMLNS_ATTR = "xmlns:";
    private static final String XMLNS_LD = "xmlns:ld";
    private static final String XML_NS = "http://www.w3.org/2000/xmlns/";
    private static final String ALL = "all";
    private static final String DEFAULT = "default";
    private static final String EXPORTED = "exported";
    private static final String TARGET_TAG = "target";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String NAME_ATTR = "name";
    private static final String PROJECT_TAG = "project";
    private static final String LD_PREFIX = "ld";
    protected static final String UTF_8 = "UTF-8";
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    private static final String DEFAULT_SCANNER_ATTR = "defaultScanner";
    private static final String DEPENDENCY_TYPE = "dependencytype";
    private static final String SCOPED_PROPERTY = "scopedProperty";
    private static final String EMPTY = "";
    public static final String NON_IMPACTING_ATTR = "nonImpacting";
    protected static final String CALCULATE_IMPACTS_ATTR = "calculateImpacts";
    protected static final String CONSOLIDATE_LOGS_ATTR = "consolidateLogs";
    private static final String COMMA = ",";
    private static final String ZERO_LENGTH_STRING = "";
    protected static final int DEFAULT_BUFFER_SIZE = 4096;
    protected Element translatorsTarget;
    protected List<Element> translatorsString;
    protected Element langdefsTarget;
    protected List<Element> langdefsString;
    protected Element allTarget;
    protected List<Element> allTargetString;
    private Document document;
    private String file;
    private boolean global;
    private LogFunction<String, LOGGER_INFO> log;

    protected void log(String msg, LOGGER_INFO info) {
        if (this.log != null) {
            this.log.apply(msg, info);
        }
    }

    protected void setLogger(LogFunction<String, LOGGER_INFO> logger) {
        this.log = logger;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    protected void createDocumentForStringExport() throws ParserConfigurationException {
        this.addPlatformDependentTargetsForStringExport();
        this.translatorsString = new ArrayList<Element>();
        this.langdefsString = new ArrayList<Element>();
        this.allTargetString = new ArrayList<Element>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.document = documentBuilderFactory.newDocumentBuilder().newDocument();
    }

    protected void createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element projectElement = this.document.createElement(PROJECT_TAG);
        projectElement.setAttribute(NAME_ATTR, EXPORTED);
        projectElement.setAttribute(DEFAULT, ALL);
        Attr attr = this.document.createAttributeNS(XML_NS, XMLNS_LD);
        attr.setValue(this.getNamespace());
        projectElement.setAttributeNode(attr);
        this.document.appendChild(projectElement);
        Element descriptionElement = this.document.createElement(DESCRIPTION_ATTR);
        descriptionElement.setTextContent(EXPORTED2);
        projectElement.appendChild(descriptionElement);
        Element initTask = this.document.createElementNS(this.getNamespace(), INIT);
        initTask.setPrefix(LD_PREFIX);
        initTask.setAttribute(REPOSITORY_ADDRESS, REPOSITORY_ADDRESS_PROPERTY);
        initTask.setAttribute(USER_ID, USER_ID_PROPERTY);
        initTask.setAttribute(PASSWORD, PASSWORD_PROPERTY);
        initTask.setAttribute(PROJECT_AREA, PROJECT_AREA_PROPERTY);
        projectElement.appendChild(initTask);
        this.addPlatformDependentTargets(projectElement);
        this.translatorsTarget = this.getTargetElement();
        this.translatorsTarget.setAttribute(NAME_ATTR, TRANSLATORS);
        this.translatorsTarget.setAttribute(DESCRIPTION_ATTR, Messages.CREATE_TRANSLATORS_DESCRIPTION);
        projectElement.appendChild(this.translatorsTarget);
        this.langdefsTarget = this.getTargetElement();
        this.langdefsTarget.setAttribute(NAME_ATTR, LANGDEFS);
        this.langdefsTarget.setAttribute(DESCRIPTION_ATTR, Messages.CREATE_LANG_DEFS_DESCRIPTION);
        projectElement.appendChild(this.langdefsTarget);
        this.allTarget = this.getTargetElement();
        this.allTarget.setAttribute(NAME_ATTR, ALL);
        this.allTarget.setAttribute(DEPENDS_ATTR, this.getDefaultTargets());
        this.allTarget.setAttribute(DESCRIPTION_ATTR, FULL_BUILD);
        projectElement.appendChild(this.allTarget);
    }

    protected Element getTranslatorsTarget() {
        return this.translatorsTarget;
    }

    protected abstract void addPlatformDependentTargets(Element var1);

    protected abstract void addPlatformDependentTargetsForStringExport();

    protected abstract void addPlatformDependentStrings(StringBuilder var1) throws ExportException;

    protected abstract String getDefaultTargets();

    protected abstract String getNamespace();

    protected Element getTargetElement() {
        return this.document.createElement(TARGET_TAG);
    }

    protected abstract void addTranslators(Consumer<Element> var1) throws IllegalArgumentException, TeamRepositoryException;

    protected void addLanguageDefinitions(Set<ILanguageDefinition> languageDefinitionSet, Consumer<Element> consumer) throws IllegalArgumentException, TeamRepositoryException {
        if (languageDefinitionSet != null && languageDefinitionSet.size() > 0) {
            ILanguageDefinition[] languageDefinitions = new ILanguageDefinition[languageDefinitionSet.size()];
            languageDefinitionSet.toArray(languageDefinitions);
            Arrays.sort(languageDefinitions, 0, languageDefinitions.length, new Comparator<ILanguageDefinition>(){

                @Override
                public int compare(ILanguageDefinition ld0, ILanguageDefinition ld1) {
                    return ld0.getName().compareTo(ld1.getName());
                }
            });
            ILanguageDefinition[] iLanguageDefinitionArray = languageDefinitions;
            int n = languageDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                ILanguageDefinition langdef = iLanguageDefinitionArray[n2];
                this.log(NLS.bind((String)Messages.LANG_DEF_FOUND, (Object)langdef.getName()), LOGGER_INFO.MSG_INFO);
                consumer.accept(this.getLangDefTask(langdef));
                ++n2;
            }
        }
    }

    protected abstract Element getTranslatorTask(ITranslator var1) throws IllegalArgumentException, TeamRepositoryException;

    private Element getLangDefTask(ILanguageDefinition langdef) throws IllegalArgumentException, TeamRepositoryException {
        Element languageExtensionElement;
        String stepName;
        String conditions;
        String s;
        Element element = this.document.createElementNS(this.getNamespace(), LANGDEF);
        element.setPrefix(LD_PREFIX);
        List<IStringHelper> patterns = langdef.getDefaultPatterns();
        if (patterns != null && !patterns.isEmpty()) {
            element.setAttribute(DEFAULT_PATTERNS_ATTR, SystemDefinitionUtil.joinStringHelper(patterns, COMMA));
        }
        if ((s = langdef.getDescription()) != null && s.length() > 0) {
            element.setAttribute(DESCRIPTION_ATTR, s);
        }
        if ((s = langdef.getLanguageCode()) != null && s.length() > 0) {
            element.setAttribute(LANGUAGE_CODE_ATTR, s);
        }
        element.setAttribute(NAME_ATTR, langdef.getName());
        String translators = this.getTranslatorsString(langdef.getTranslators());
        if (translators != null) {
            element.setAttribute(TRANSLATORS, translators);
        }
        if ((conditions = this.getTranslatorsConditionString(langdef.getTranslators())) != null) {
            element.setAttribute(CONDITIONS, conditions);
        }
        if ((stepName = this.getTranslatorsStepNamesString(langdef.getTranslators())) != null) {
            element.setAttribute(STEPNAMES, stepName);
        }
        this.addScopedProperties(langdef, this.document, element);
        if (langdef.isNonImpacting()) {
            element.setAttribute(NON_IMPACTING_ATTR, Boolean.TRUE.toString());
        }
        if (!langdef.isCalculateImpacts()) {
            element.setAttribute(CALCULATE_IMPACTS_ATTR, Boolean.FALSE.toString());
        }
        if (langdef.isConsolidateLogs()) {
            element.setAttribute(CONSOLIDATE_LOGS_ATTR, Boolean.TRUE.toString());
        }
        element.setAttribute(DEFAULT_SCANNER_ATTR, Boolean.FALSE.toString());
        List<IStringHelper> scanners = langdef.getSourceCodeDataScanners();
        if (scanners != null) {
            for (IStringHelper scanner : scanners) {
                Element scannerElement = this.document.createElementNS(this.getNamespace(), SCANNER);
                scannerElement.setPrefix(LD_PREFIX);
                scannerElement.setAttribute(NAME_ATTR, scanner.getValue());
                element.appendChild(scannerElement);
            }
        }
        List<IDependencyType> dependencyTypes = langdef.getDependencyTypes();
        for (IDependencyType type : dependencyTypes) {
            Element depTypeElement = this.document.createElementNS(this.getNamespace(), DEPENDENCY_TYPE);
            depTypeElement.setPrefix(LD_PREFIX);
            depTypeElement.setAttribute(NAME_ATTR, type.getName());
            String depTypeTranslators = null;
            switch (type.getLevel()) {
                case 0: {
                    break;
                }
                case 1: {
                    depTypeTranslators = "";
                    break;
                }
                case 2: {
                    depTypeTranslators = this.getTranslatorsString(type.getTranslators());
                }
            }
            if (depTypeTranslators != null) {
                depTypeElement.setAttribute(TRANSLATORS, depTypeTranslators);
            }
            element.appendChild(depTypeElement);
        }
        if (langdef instanceof IZosLanguageDefinition && ((IZosLanguageDefinition)langdef).getSmpePackaging() != null && (languageExtensionElement = this.addLanguageExtension(this.document, langdef)) != null) {
            element.appendChild(languageExtensionElement);
        }
        return element;
    }

    protected void addScopedProperties(ILanguageDefinition langDef, Document document, Element element) {
        List<IScopedProperty> propertySet = langDef.getScopedProperties();
        if (propertySet != null && !propertySet.isEmpty()) {
            for (IScopedProperty property : propertySet) {
                Element e = document.createElementNS(this.getNamespace(), SCOPED_PROPERTY);
                e.setPrefix(LD_PREFIX);
                e.setAttribute(NAME_ATTR, property.getName());
                e.setAttribute(VALUE_ATTR, property.getValue());
                if (property.getCondition() != null && !property.getCondition().isEmpty()) {
                    e.setAttribute(CONDITION_ATTR, property.getCondition());
                }
                element.appendChild(e);
            }
        }
    }

    private String getTranslatorsConditionString(List<ITranslatorEntry> entries) throws TeamRepositoryException {
        String conditions = null;
        boolean conditionFound = false;
        for (ITranslatorEntry entry : entries) {
            String condition = "";
            if (entry.getCondition() != null && !entry.getCondition().isEmpty()) {
                conditionFound = true;
                condition = entry.getCondition();
            }
            conditions = conditions != null ? String.valueOf(conditions) + COMMA + condition : condition;
        }
        if (conditionFound) {
            return conditions;
        }
        return null;
    }

    private String getTranslatorsStepNamesString(List<ITranslatorEntry> entries) throws TeamRepositoryException {
        String stepNames = null;
        boolean conditionFound = false;
        for (ITranslatorEntry entry : entries) {
            String stepName = "";
            if (entry.getStepName() != null && !entry.getStepName().isEmpty()) {
                conditionFound = true;
                stepName = entry.getStepName();
            }
            stepNames = stepNames != null ? String.valueOf(stepNames) + COMMA + stepName : stepName;
        }
        if (conditionFound) {
            return stepNames;
        }
        return null;
    }

    protected abstract Set<ITranslator> getTranslators();

    protected String getTranslatorsString(List<ITranslatorEntry> entries) throws TeamRepositoryException {
        String translators = null;
        for (ITranslatorEntry entry : entries) {
            String value = entry.getValue();
            if ("com.ibm.team.enterprise.systemdefinition.entry.translator".equals(entry.getKind())) {
                ITranslator translator = null;
                Set<ITranslator> trs = this.getTranslators();
                for (ITranslator tr : trs) {
                    if (!value.equals(tr.getItemId().getUuidValue())) continue;
                    translator = tr;
                    break;
                }
                if (translator == null) continue;
                String name = translator.getName();
                if (translators != null) {
                    translators = String.valueOf(translators) + COMMA + name;
                    continue;
                }
                translators = name;
                continue;
            }
            if (value.startsWith(BUILD_PROPERTY_PREFIX) && value.endsWith(BUILD_PROPERTY_SUFFIX)) {
                int len = value.length();
                value = value.substring(BUILD_PROPERTY_PREFIX.length(), len - BUILD_PROPERTY_SUFFIX.length());
            }
            translators = translators != null ? String.valueOf(translators) + COMMA + value : value;
        }
        return translators;
    }

    protected void checkOutputFile() throws ExportException {
        if (this.getFile() == null) {
            this.log(Messages.OUTPUT_FILE_NOT_SPECIFIED, LOGGER_INFO.MSG_WARN);
        } else {
            File f = new File(this.getFile());
            if (f.exists()) {
                throw new ExportException(NLS.bind((String)Messages.EXPORT_EXCEPTION_FILE_EXISTS, (Object)this.getFile()));
            }
        }
    }

    protected void printDocument() throws ExportException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        try {
            AbstractExportSysDefs.transform(result, this.document);
            String s = outputStream.toString(UTF_8);
            s = s.replaceFirst("\\?\\><", "?>\n<");
            if (this.getFile() != null) {
                File f = new File(this.getFile());
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(s.getBytes(UTF_8));
                fos.flush();
                fos.close();
            } else {
                System.out.write(s.getBytes(UTF_8));
            }
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    protected String createString(boolean removeNS) throws ExportException {
        StringBuilder builder = new StringBuilder();
        this.addPlatformDependentStrings(builder);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        try {
            for (Element e : this.translatorsString) {
                AbstractExportSysDefs.transform(result, e, true);
            }
            for (Element e : this.langdefsString) {
                AbstractExportSysDefs.transform(result, e, true);
            }
            for (Element e : this.allTargetString) {
                AbstractExportSysDefs.transform(result, e, true);
            }
            builder.append(outputStream.toString(UTF_8));
            return removeNS ? AbstractExportSysDefs.removeNamespaces(builder.toString()) : builder.toString();
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    public static String removeNamespaces(String xmlString) {
        return xmlString.replaceAll("xmlns.*?(\"|').*?(\"|') ", "");
    }

    protected static void transform(Result result, Node node) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        AbstractExportSysDefs.transform(result, node, false);
    }

    protected static void transform(Result result, Node node, boolean omit) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(node);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        TransformerFactory.newInstance().newTransformer();
        if (!omit) {
            transformer.setOutputProperty("indent", YES);
            transformer.setOutputProperty(INDENT_AMOUNT, THREE);
        }
        if (omit) {
            transformer.setOutputProperty("omit-xml-declaration", YES);
        }
        transformer.transform(source, result);
    }

    protected Document getDocument() {
        return this.document;
    }

    protected void addVariables(ITranslator translator, Document document, Element element, String namespace) {
        List<IVariable> variableSet = translator.getVariables();
        if (variableSet != null && variableSet.size() > 0) {
            for (IVariable variable : variableSet) {
                Element e = document.createElementNS(namespace, VARIABLE);
                e.setPrefix(LD_PREFIX);
                e.setAttribute(NAME_ATTR, variable.getName());
                e.setAttribute(VALUE_ATTR, variable.getValue());
                element.appendChild(e);
            }
        }
    }

    protected void addHFSOutputs(ITranslator translator, Document document, Element element, String namespace) {
        List<IHFSOutput> outputSet;
        if (translator instanceof IZosTranslator && (outputSet = ((IZosTranslator)translator).getHFSOutputs()) != null && outputSet.size() > 0) {
            for (IHFSOutput output : outputSet) {
                Element e = document.createElementNS(namespace, HFSOUTPUT);
                e.setPrefix(LD_PREFIX);
                e.setAttribute(PATH_ATTR, output.getPath());
                e.setAttribute(CONDITION_ATTR, output.getCondition());
                e.setAttribute(DEPLOYTYPE_ATTR, output.getDeployType());
                element.appendChild(e);
            }
        }
    }

    protected abstract Element addLanguageExtension(Document var1, ILanguageDefinition var2) throws TeamRepositoryException;

    protected void addXmlNsToProject(Document document, String prefix, String nameSpace) {
        NodeList projectList = document.getElementsByTagName(PROJECT_TAG);
        Element projectElement = (Element)projectList.item(0);
        Attr attr = document.createAttributeNS(XML_NS, XMLNS_ATTR + prefix);
        attr.setValue(nameSpace);
        projectElement.setAttributeNode(attr);
    }

    protected Element invokeExportTask(String className, String methodName, Class<?>[] paramTypes, Object[] args) throws TeamRepositoryException {
        Element languageExtensionElement = null;
        try {
            Class<?> cls = Class.forName(className);
            Object thisClass = cls.newInstance();
            Method method = thisClass.getClass().getMethod(methodName, paramTypes);
            languageExtensionElement = (Element)method.invoke(thisClass, args);
        }
        catch (ClassNotFoundException ex) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.EXTENSION_CLASS_NOT_FOUND, (Object)className));
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            throw new TeamRepositoryException(NLS.bind((String)Messages.EXTENSION_TASK_FAILED, (Object)cause.getMessage()));
        }
        catch (Exception ex) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.EXTENSION_TASK_FAILED, (Object)ex));
        }
        return languageExtensionElement;
    }

    public static enum LOGGER_INFO {
        MSG_INFO,
        MSG_WARN;

    }

    @FunctionalInterface
    public static interface LogFunction<T, U> {
        public void apply(T var1, U var2);
    }
}

