/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.export.jcl;

import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDDAmp;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDDCopies;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDDDisp;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDDLabel;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDDSpace;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDDVolume;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDataSet;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class JCLSystemDefInterpreterFunctions {
    private static String DATACLAS = "DATACLAS";
    private static String COMMA = ",";
    private static String UNDERSCORE = "_";
    private static String LRECL = "LRECL";
    private static String RECFM = "RECFM";
    private static String BLKSIZE = "BLKSIZE";
    private static long MAX_BLKSIZE = 32760L;
    public static List<BiConsumer<IJclResultDataSet, IDataSetDefinition>> dsFunctions = new ArrayList<BiConsumer<IJclResultDataSet, IDataSetDefinition>>();

    static {
        dsFunctions.add((result, dsDef) -> {
            if (result.hasSpaceParameters()) {
                IJclResultDDSpace spaceParms = result.getSpaceParameter();
                dsDef.setDirectoryBlocks(spaceParms.getDirectory());
                dsDef.setPrimaryQuantity(spaceParms.getPrimary());
                dsDef.setSecondaryQuantity(spaceParms.getSecondary());
                SpaceUnit unit = SpaceUnit.of(spaceParms.getUnits());
                if (unit.coding != null) {
                    dsDef.setSpaceUnits(unit.coding);
                }
            }
        });
        dsFunctions.add((result, dsDef) -> {
            IJclResultDDDisp dispParms = result.getDispParameter();
            dispParms.getAbnormal();
            dispParms.getNormal();
            dispParms.getStatus();
        });
        dsFunctions.add((result, dsDef) -> {
            Map parms = result.getParameters();
            if (parms.containsKey(DATACLAS)) {
                dsDef.setDataClass((String)parms.get(DATACLAS));
            }
        });
        dsFunctions.add((result, dsDef) -> {
            IJclResultDDVolume volumeParms = result.getVolParameter();
            String serial = volumeParms.getVolume();
            List multiVolumes = volumeParms.getVolumes();
            if (!multiVolumes.isEmpty()) {
                dsDef.setAllocationMultipleVolumes(String.join((CharSequence)COMMA, multiVolumes));
            }
            if (serial != null) {
                dsDef.setVolumeSerial(serial);
            }
        });
        dsFunctions.add((result, dsDef) -> {
            IJclResultDDCopies copiesParm = result.getCopiesParameter();
            List groups = copiesParm.getGroups();
            String string = copiesParm.getNumber();
        });
        dsFunctions.add((result, dsDef) -> {
            if (result.hasCharsParameters()) {
                List list = result.getCharsParameters();
            }
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getDcbParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getDestParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getDsidParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List dsnTypeParms;
            String subParm;
            int dsType;
            if (result.hasDsntypeParameters() && (dsType = DsnType.of(subParm = String.join((CharSequence)JCLSystemDefInterpreterFunctions.UNDERSCORE, (dsnTypeParms = result.getDsntypeParameters()).stream().map(sub -> sub.getValue()).collect(Collectors.toList()))).dsType) > -1) {
                dsDef.setDsType(dsType);
            }
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getFcbParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getFlashParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            IJclResultDDLabel labelParms = result.getLabelParameter();
            labelParms.getExpdt();
            labelParms.getInout();
            labelParms.getLabel();
            labelParms.getPassword();
            labelParms.getRetpd();
            labelParms.getSequence();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getModifyParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getOutputParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getPathDispParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getPathModeParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getPathOptsParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getSecmodelParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getSubsysParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getSysoutParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            List list = result.getUcsParameters();
        });
        dsFunctions.add((result, dsDef) -> {
            if (result.hasUnitParameters()) {
                List unitParms = result.getUnitParameters();
                String genericUnit = String.join((CharSequence)COMMA, unitParms.stream().map(p -> p.getValue()).collect(Collectors.toList()));
                dsDef.setGenericUnit(genericUnit);
            }
        });
        dsFunctions.add((result, dsDef) -> {
            Map recfmParms = result.getParameters();
            if (recfmParms.containsKey(RECFM)) {
                dsDef.setRecordFormat((String)recfmParms.get(RECFM));
            }
        });
        dsFunctions.add((result, dsDef) -> {
            IJclResultDDAmp ampParms = result.getAmpParameter();
            ampParms.getAmorg();
            ampParms.getKeywords();
        });
        dsFunctions.add((result, dsDef) -> {
            Map lreclParms = result.getParameters();
            if (lreclParms.containsKey(LRECL)) {
                dsDef.setRecordLength((String)lreclParms.get(LRECL));
            }
        });
        dsFunctions.add((result, dsDef) -> {
            Map blockSizeParms = result.getParameters();
            if (blockSizeParms.containsKey(BLKSIZE)) {
                String blockSize;
                String bytes = blockSize = (String)blockSizeParms.get(BLKSIZE);
                if (Character.isAlphabetic(blockSize.charAt(blockSize.length() - 1))) {
                    MemorySize ordinal = MemorySize.valueOf(Character.toString(blockSize.charAt(blockSize.length() - 1)));
                    long b = Long.parseLong(blockSize.substring(0, blockSize.length() - 1));
                    switch (ordinal) {
                        case K: {
                            b *= 1024L;
                            break;
                        }
                        case M: {
                            b = b * 1024L * 1014L;
                            break;
                        }
                        case G: {
                            b = b * 1024L * 1024L * 1024L;
                        }
                    }
                    bytes = Long.toString(Math.min(MAX_BLKSIZE, b));
                }
                dsDef.setBlockSize(bytes);
            }
        });
    }

    private static enum DsnType {
        LIBRARY(0),
        LIBRARY_1(4),
        LIBRARY_2(5),
        HFS(-1),
        PDS(3),
        PIPE(-1),
        EXTREQ(-1),
        EXTPREF(-1),
        LARGE(1),
        BASIC(1),
        DEFAULT(-1);

        private int dsType;

        private DsnType(int dsType) {
            this.dsType = dsType;
        }

        private static DsnType of(String value) {
            DsnType[] dsnTypeArray = DsnType.values();
            int n = dsnTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DsnType v = dsnTypeArray[n2];
                if (v.name().equalsIgnoreCase(value)) {
                    return v;
                }
                ++n2;
            }
            return DEFAULT;
        }
    }

    private static enum MemorySize {
        K,
        M,
        G;

    }

    private static enum SpaceUnit {
        TRK("trks"),
        CYL("cyls"),
        ABSTR(null),
        BLKLGTH("blks"),
        RECLGTH(null),
        DEFAULT(null);

        private String coding;

        private SpaceUnit(String coding) {
            this.coding = coding;
        }

        private static SpaceUnit of(String value) {
            SpaceUnit[] spaceUnitArray = SpaceUnit.values();
            int n = spaceUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpaceUnit v = spaceUnitArray[n2];
                if (v.name().equalsIgnoreCase(value)) {
                    return v;
                }
                ++n2;
            }
            return DEFAULT;
        }
    }
}

