/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common.export.jcl;

import com.ibm.team.enterprise.common.common.parser.jcl.IJclResult;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDataDef;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDataSet;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultStep;
import com.ibm.team.enterprise.systemdefinition.common.export.jcl.JCLOptions;
import com.ibm.team.enterprise.systemdefinition.common.export.jcl.JCLSystemDefInterpreterFunctions;
import com.ibm.team.enterprise.systemdefinition.common.export.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.export.util.ExportException;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.Concatenation;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.TranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.ZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.ZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class JCLSystemDefInterpreter {
    private static String COMMENTS = "COMMENTS\n";
    private static String JCL = "ORIGINAL JCL\n";
    private static String SPACER = "==============================\n";
    private static String EMPTY = "";
    private static String DEFAULT_LANG_DEF_NAME = "Language Def";
    private static String UNDERSCORE = "_";
    private static String DSN = "DSN";
    private static String JCL_SOURCE = "jclSource";
    private Set<ITranslator> translators;
    private List<ITranslatorEntry> translatorEntries;
    private Set<ILanguageDefinition> langDefs;
    private List<IFunctionDefinition> functions;
    private List<IVersionDefinition> versions;
    private JCLOptions options;
    private List<IJclResult> results;
    private Set<IResourceDefinition> dsDefs = new HashSet<IResourceDefinition>();
    private int tempCounter = 0;

    private void createTranslator(IJclResultStep step) {
        IZosTranslator translator = this.createNewTranslator();
        translator.setName(step.getName());
        translator.setDescription(step.getComments());
        this.addDataSetDefs(translator, step.getDataDefs());
        this.translators.add(translator);
        this.translatorEntries.add(this.createNewTranslatorEntry(translator));
    }

    private DDAllocation createAllocation(IJclResultDataDef dataDef) {
        IDataDefinitionEntry entry = this.handleDataSetDefinition(dataDef);
        DDAllocation alloc = this.createNewAllocation();
        String name = dataDef.getName();
        alloc.setName(name);
        alloc.setPublish(this.options.getPublishNameList().contains(name));
        alloc.setOutput(this.options.getOutputNameList().contains(name));
        alloc.setUsedAsInput(this.options.getInputNameList().contains(name));
        alloc.setDataDefinitionEntry(entry);
        return alloc;
    }

    private DDAllocation createAllocation(IJclResultDataSet dataSet) {
        IDataDefinitionEntry entry = this.handleDataSetDefinition(dataSet);
        DDAllocation alloc = this.createNewAllocation();
        alloc.setName((String)dataSet.getParameters().get(DSN));
        alloc.setDataDefinitionEntry(entry);
        return alloc;
    }

    private Concatenation createConcat(IJclResultDataDef dataDef) {
        this.handleDataSetDefinition(dataDef);
        Concatenation concat = this.createNewConcatenation();
        List allocs = dataDef.getDatasets().stream().map(this::createAllocation).collect(Collectors.toList());
        concat.setName(dataDef.getName());
        concat.getDataDefinitionEntries().addAll(allocs.stream().filter(a -> a != null).map(a -> a.getDataDefinitionEntry()).collect(Collectors.toList()));
        return concat;
    }

    private IDataDefinitionEntry handleDataSetDefinition(IJclResultDataDef dataDef) {
        boolean output = false;
        if (this.options.getOutputNameList().contains(dataDef.getName())) {
            output = true;
        }
        return this.handleDataSetDefinition(dataDef.getDataset(), output, this.getDescription(dataDef));
    }

    private IDataDefinitionEntry handleDataSetDefinition(IJclResultDataSet dataSet) {
        return this.handleDataSetDefinition(dataSet, false, null);
    }

    private IDataDefinitionEntry handleDataSetDefinition(IJclResultDataSet dataSet, boolean output, String description) {
        String dsn = (String)dataSet.getParameters().get(DSN);
        boolean member = false;
        boolean prefixed = false;
        String property = null;
        int dsUsageType = -1;
        if (output) {
            property = "com.ibm.teamz.langdef.entry.data_definition";
            dsUsageType = 1;
        } else if (dsn == null || dsn.startsWith("&&")) {
            property = "com.ibm.teamz.langdef.entry.data_definition";
            dsUsageType = 2;
        } else if (dsn.startsWith(this.options.getPrefix())) {
            property = "com.ibm.teamz.langdef.entry.data_definition";
            member = true;
            prefixed = true;
            dsUsageType = 0;
        } else {
            property = "com.ibm.teamz.langdef.entry.data_definition";
            dsUsageType = 3;
        }
        IDataSetDefinition dsDef = this.createNewDatasetDefinition();
        dsDef.setDsName(dsn == null ? EMPTY : dsn);
        dsDef.setUsageType(dsUsageType);
        dsDef.setName(dsn == null ? this.getTemporaryDSN() : dsn);
        dsDef.setPrefixDSN(prefixed);
        dsDef.setDescription(description == null ? EMPTY : description);
        this.addDataSetParms(dataSet, dsDef);
        this.dsDefs.add(dsDef);
        return this.createDataDefEntry(property, dsDef.getItemId().getUuidValue(), member);
    }

    private void addDataSetParms(IJclResultDataSet dataSet, IDataSetDefinition dsDef) {
        JCLSystemDefInterpreterFunctions.dsFunctions.stream().forEach(fun -> fun.accept(dataSet, dsDef));
    }

    private IDataSetDefinition createNewDatasetDefinition() {
        DataSetDefinition dsDef = ModelFactory.eINSTANCE.createDataSetDefinition();
        return (IDataSetDefinition)dsDef.getWorkingCopy();
    }

    private DDAllocation createNewAllocation() {
        return ModelFactory.eINSTANCE.createDDAllocation();
    }

    private Concatenation createNewConcatenation() {
        return ModelFactory.eINSTANCE.createConcatenation();
    }

    private ILanguageDefinition createNewLanguageDefinition() {
        ZosLanguageDefinition langDef = ModelFactory.eINSTANCE.createZosLanguageDefinition();
        return (ILanguageDefinition)langDef.getWorkingCopy();
    }

    private IZosTranslator createNewTranslator() {
        ZosTranslator translator = ModelFactory.eINSTANCE.createZosTranslator();
        return (IZosTranslator)translator.getWorkingCopy();
    }

    private ITranslatorEntry createNewTranslatorEntry(IZosTranslator translator) {
        TranslatorEntry entry = ModelFactory.eINSTANCE.createTranslatorEntry();
        entry.setValue(translator.getItemId().getUuidValue());
        entry.setKind("com.ibm.team.enterprise.systemdefinition.entry.translator");
        entry.setStepName(translator.getName());
        return entry;
    }

    private String getLanguageDefName(String name) {
        if (name != null) {
            return name;
        }
        StringBuilder newName = new StringBuilder();
        newName.append(DEFAULT_LANG_DEF_NAME);
        newName.append(UNDERSCORE);
        newName.append(UUID.generate().getUuidValue());
        return newName.toString();
    }

    private String getTemporaryDSN() {
        return String.valueOf(this.options.getTemporaryDsnPrefix()) + UNDERSCORE + this.tempCounter++;
    }

    private String getDescription(IJclResultDataDef dataDef) {
        String comments = dataDef.getComments();
        if (comments != null && !comments.isEmpty()) {
            return comments;
        }
        return EMPTY;
    }

    private DataDefinitionEntry createDataDefEntry(String kind, String value, boolean member) {
        DataDefinitionEntry dEntry = ModelFactory.eINSTANCE.createDataDefinitionEntry();
        dEntry.setKind(kind);
        if (value != null) {
            dEntry.setValue(value);
        }
        if (member) {
            dEntry.setMember(member);
        }
        return dEntry;
    }

    private void addDataSetDefs(IZosTranslator translator, List<IJclResultDataDef> dataDefResults) {
        List toAllocs = dataDefResults.stream().filter(d -> !d.hasDatasets()).collect(Collectors.toList());
        List toConcat = dataDefResults.stream().filter(d -> d.hasDatasets()).collect(Collectors.toList());
        List allocs = toAllocs.stream().map(this::createAllocation).collect(Collectors.toList());
        List concats = toConcat.stream().map(this::createConcat).collect(Collectors.toList());
        translator.getConcatenations().addAll(concats);
        translator.getDDAllocations().addAll(allocs);
    }

    public static JCLSystemDefInterpreter create() {
        return new JCLSystemDefInterpreter();
    }

    private JCLSystemDefInterpreter() {
        this.translators = new HashSet<ITranslator>();
        this.translatorEntries = new ArrayList<ITranslatorEntry>();
        this.langDefs = new HashSet<ILanguageDefinition>();
        this.functions = new ArrayList<IFunctionDefinition>();
        this.versions = new ArrayList<IVersionDefinition>();
        this.results = new ArrayList<IJclResult>();
    }

    public JCLSystemDefInterpreter setOptions(JCLOptions options) {
        this.options = options;
        return this;
    }

    public JCLSystemDefInterpreter addResult(IJclResult result) {
        this.results.add(result);
        return this;
    }

    public JCLSystemDefInterpreter addResults(List<IJclResult> results) {
        this.results.addAll(results);
        return this;
    }

    private void interpretResult(IJclResult result) {
        ILanguageDefinition langDef = this.createNewLanguageDefinition();
        result.getSteps().stream().forEach(this::createTranslator);
        langDef.getTranslators().addAll(this.translatorEntries);
        langDef.setName(this.getLanguageDefName(result.getName()));
        this.langDefs.add(langDef);
    }

    public JCLSystemDefInterpreter interpret() throws ExportException {
        if (this.results.isEmpty()) {
            throw new ExportException(Messages.RESULT_MUST_BE_SET);
        }
        if (this.options == null) {
            throw new ExportException(Messages.OPTIONS_MUST_BE_SET);
        }
        this.results.stream().forEach(this::interpretResult);
        return this;
    }

    public Set<IResourceDefinition> getDsDefs() {
        return this.dsDefs;
    }

    public Set<ITranslator> getTranslators() {
        return this.translators;
    }

    public Set<ILanguageDefinition> getLangDefs() {
        return this.langDefs;
    }

    public List<IFunctionDefinition> getFunctions() {
        return this.functions;
    }

    public List<IVersionDefinition> getVersions() {
        return this.versions;
    }

    public IDataSetDefinition getDataSetDefinition(Object o) {
        UUID itemId;
        Object object = o instanceof UUID ? (UUID)o : (itemId = o instanceof IDataSetDefinitionHandle ? ((IDataSetDefinitionHandle)o).getItemId() : null);
        if (itemId == null) {
            return null;
        }
        return this.dsDefs.stream().filter(d -> d.getItemId().equals((Object)itemId)).map(IDataSetDefinition.class::cast).findAny().orElse(null);
    }
}

