/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionQueryCache;
import com.ibm.team.enterprise.systemdefinition.common.parsers.SystemDefinitionHandleParser;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class SystemDefinitionQueryCache
implements ISystemDefinitionQueryCache {
    private final String type;
    private final List<ISystemDefinitionHandle> systemDefinitionHandles;

    public SystemDefinitionQueryCache(String type, String content) {
        this.type = type;
        this.systemDefinitionHandles = new ArrayList<ISystemDefinitionHandle>();
        if (content != null) {
            try {
                SystemDefinitionHandleParser parser = new SystemDefinitionHandleParser();
                JSONArray arrays = JSONArray.parse((Reader)new StringReader(content));
                for (JSONObject obj : arrays) {
                    ISystemDefinitionHandle handle = parser.parseJSON(obj);
                    if (!handle.getType().equals(type)) continue;
                    this.systemDefinitionHandles.add(handle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addSystemDefinitionHandle(ISystemDefinitionHandle handle) {
        this.systemDefinitionHandles.add(handle);
    }

    @Override
    public List<ISystemDefinitionHandle> getSystemDefinitionHandles() {
        return this.systemDefinitionHandles;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

