/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugInstance;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.systemdefinition.common.IPropertyResolver;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class PropertyResolverItems {
    private static PropertyResolverItems instance;
    private final IDebugger dbg = DebugInstance.getInstance().getDbg();
    private final String simpleName = this.getClass().getSimpleName();
    private IProjectAreaHandle projectAreaHandle;
    private int maxNameWidth = 48;
    private final Map<String, IPropertyResolver> propertyMap = new HashMap<String, IPropertyResolver>();
    private List<IFunctionDefinition> functions;
    private List<ILanguageDefinition> languages;
    private List<IResourceDefinition> resources;

    private PropertyResolverItems() {
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public static synchronized PropertyResolverItems getInstance() {
        if (instance == null) {
            instance = new PropertyResolverItems();
            instance.load();
        }
        return instance;
    }

    public synchronized Map<String, IPropertyResolver> getElementMap() {
        return this.propertyMap;
    }

    public boolean isConfigured() {
        return this.functions != null && this.languages != null && this.resources != null;
    }

    public boolean isConfigured(IProjectAreaHandle handle) {
        return this.projectAreaHandle == null ? false : this.projectAreaHandle.sameItemId((IItemHandle)handle) && this.functions != null && this.languages != null && this.resources != null;
    }

    private void load() throws ServiceConfigurationError {
        ServiceLoader<IPropertyResolver> loader = ServiceLoader.load(IPropertyResolver.class);
        for (IPropertyResolver element : loader) {
            for (String propertyName : element.getPropertyNames()) {
                this.propertyMap.put(propertyName, element);
                this.maxNameWidth = Math.max(this.maxNameWidth, propertyName.length());
                if (!this.dbg.isItems()) continue;
                Debug.items((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new Mnm(){}.get(), "item", LogString.valueOf((String)propertyName)});
            }
        }
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new Mnm(){}.get(), Integer.toString(this.propertyMap.size())});
        }
    }

    public final List<IFunctionDefinition> getFunctions() {
        return this.functions;
    }

    public final void setFunctions(List<IFunctionDefinition> functions) {
        this.functions = functions;
    }

    public final List<ILanguageDefinition> getLanguages() {
        return this.languages;
    }

    public final void setLanguages(List<ILanguageDefinition> languages) {
        this.languages = languages;
    }

    public final List<IResourceDefinition> getResources() {
        return this.resources;
    }

    public final void setResources(List<IResourceDefinition> resources) {
        this.resources = resources;
    }

    public final IProjectAreaHandle getProjectAreaHandle() {
        return this.projectAreaHandle;
    }

    public final void setProjectAreaHandle(IProjectAreaHandle projectArea) {
        this.projectAreaHandle = projectArea;
    }

    public final int getMaxNameWidth() {
        return this.maxNameWidth;
    }
}

