/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.helper.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import org.eclipse.osgi.util.NLS;

public class MemberNamePattern {
    protected int maxMemberNameLength = Integer.MAX_VALUE;
    static String[] currentVarNames = new String[]{"@{current.date}", "@{current.time}", "@{current.millisecond}"};
    static String[] currentVarPatterns = new String[]{"@\\{current.date\\}", "@\\{current.time\\}", "@\\{current.millisecond\\}"};
    static String[] currentVarSamples = new String[]{"140811", "151845", "123456"};
    static String[] currentVarValues = new String[3];

    @Deprecated
    public MemberNamePattern(ISystemDefinition.Platform platform) {
        if (platform == ISystemDefinition.Platform.zos) {
            this.maxMemberNameLength = 8;
        } else if (platform == ISystemDefinition.Platform.ibmi) {
            this.maxMemberNameLength = 10;
        }
    }

    public MemberNamePattern(Class<? extends IPlatformObject> c) {
        if (c.equals(IZosPlatformObject.class)) {
            this.maxMemberNameLength = 8;
        } else if (c.equals(IIBMiPlatformObject.class)) {
            this.maxMemberNameLength = 10;
        }
    }

    public String substituteDateVars(String pattern) {
        return this.substituteDateVars(pattern, currentVarSamples[0], currentVarSamples[1], currentVarSamples[2]);
    }

    public String substituteDateVars(String pattern, String date, String time, String millisecond) {
        String result = pattern;
        if (result.contains(currentVarNames[0])) {
            result = result.replaceAll(currentVarPatterns[0], date);
        }
        if (result.contains(currentVarNames[1])) {
            result = result.replaceAll(currentVarPatterns[1], time);
        }
        if (result.contains(currentVarNames[2])) {
            result = result.replaceAll(currentVarPatterns[2], millisecond);
        }
        return result;
    }

    public boolean containsDateVars(String name) {
        if (name == null) {
            return false;
        }
        int i = 0;
        while (i < currentVarNames.length) {
            if (name.contains(currentVarNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void validate(String pattern) throws IllegalArgumentException {
        this.validate(pattern, false);
    }

    public void validate(String pattern, boolean allowShortStrings) throws IllegalArgumentException {
        if (pattern == null || pattern.trim().equals("") && !allowShortStrings) {
            throw new IllegalArgumentException(Messages.getCommonString("InvalidPatternError.1"));
        }
        if (!pattern.contains("@{") && pattern.length() > this.maxMemberNameLength) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("InvalidPatternError.2"), (Object)this.maxMemberNameLength));
        }
        int countAsterisk = 0;
        int countEqual = 0;
        int countExclamation = 0;
        int countChar = 0;
        char[] cArray = pattern.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (ch) {
                case '*': {
                    if (countChar > 0 && countChar < pattern.length() - 1) {
                        throw new IllegalArgumentException(Messages.getCommonString("InvalidPatternError.4"));
                    }
                    ++countAsterisk;
                    break;
                }
                case '=': {
                    ++countEqual;
                    break;
                }
                case '!': {
                    ++countExclamation;
                    break;
                }
            }
            ++countChar;
            if ((countEqual > 0 || countExclamation > 0) && countAsterisk > 0) {
                throw new IllegalArgumentException(Messages.getCommonString("InvalidPatternError.3"));
            }
            if (countAsterisk > 1) {
                throw new IllegalArgumentException(Messages.getCommonString("InvalidPatternError.4"));
            }
            ++n2;
        }
        if (!(allowShortStrings || countChar >= this.maxMemberNameLength || pattern.equals("*") || pattern.startsWith("*") || pattern.endsWith("*") || pattern.indexOf(61) == -1 && pattern.indexOf(33) == -1)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("InvalidPatternError.5"), (Object)this.maxMemberNameLength));
        }
    }

    public String convert(String aPattern, String text) throws IllegalArgumentException {
        String pattern = aPattern.trim();
        this.validate(pattern);
        int patternLength = pattern.length();
        int inputLength = text.length();
        if (pattern.equals("*")) {
            return text;
        }
        if (pattern.startsWith("*")) {
            int suffixLength = patternLength - 1;
            String suffix = pattern.substring(1, patternLength);
            if (inputLength + suffixLength <= this.maxMemberNameLength) {
                return String.valueOf(text) + suffix;
            }
            return String.valueOf(text.substring(0, this.maxMemberNameLength - suffixLength)) + suffix;
        }
        if (pattern.endsWith("*")) {
            int prefixLength = patternLength - 1;
            String prefix = pattern.substring(0, patternLength - 1);
            if (inputLength + prefixLength <= this.maxMemberNameLength) {
                return String.valueOf(prefix) + text;
            }
            return String.valueOf(prefix) + text.substring(0, this.maxMemberNameLength - prefixLength);
        }
        char[] result = new char[this.maxMemberNameLength];
        try {
            int i = 0;
            while (i < patternLength) {
                switch (pattern.charAt(i)) {
                    case '=': {
                        if (inputLength > i) {
                            result[i] = text.charAt(i);
                            break;
                        }
                        result[i] = 32;
                        break;
                    }
                    case '!': {
                        result[i] = 32;
                        break;
                    }
                    default: {
                        result[i] = pattern.charAt(i);
                    }
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("InvalidPatternError.6"), (Object)pattern), e);
        }
        String resultString = new String(result);
        resultString = resultString.replaceAll(" ", "");
        resultString = resultString.replaceAll("\u0000", "");
        return resultString;
    }
}

