/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common;

import com.ibm.team.enterprise.systemdefinition.common.ILanguageExtensionDetails;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageExtensionDetailsEnumeration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LanguageExtensionDetails
implements ILanguageExtensionDetails {
    private final String platform;
    private static final Map<String, ILanguageExtensionDetailsEnumeration.LanguageExtensionTask> taskMap;

    static {
        HashMap<String, ILanguageExtensionDetailsEnumeration.LanguageExtensionTask> loadMap = new HashMap<String, ILanguageExtensionDetailsEnumeration.LanguageExtensionTask>();
        loadMap.put(ILanguageExtensionDetailsEnumeration.LanguageExtensionTask.AIX.getPlatform(), ILanguageExtensionDetailsEnumeration.LanguageExtensionTask.AIX);
        loadMap.put(ILanguageExtensionDetailsEnumeration.LanguageExtensionTask.IBMI.getPlatform(), ILanguageExtensionDetailsEnumeration.LanguageExtensionTask.IBMI);
        loadMap.put(ILanguageExtensionDetailsEnumeration.LanguageExtensionTask.ZOS.getPlatform(), ILanguageExtensionDetailsEnumeration.LanguageExtensionTask.ZOS);
        taskMap = Collections.unmodifiableMap(loadMap);
    }

    public LanguageExtensionDetails(String platform) {
        this.platform = platform;
    }

    public static final ILanguageExtensionDetailsEnumeration.LanguageExtensionTask getTask(String platform) {
        return platform == null ? null : (taskMap.containsKey(platform) ? taskMap.get(platform) : null);
    }

    public static final Map<String, ILanguageExtensionDetailsEnumeration.LanguageExtensionTask> getTaskMap() {
        return taskMap;
    }

    @Override
    public final String getPlatform() {
        return taskMap.get(this.platform).getPlatform();
    }

    @Override
    public final String getPackageName() {
        return taskMap.get(this.platform).getPackageName();
    }

    @Override
    public final String getCreateClass() {
        return taskMap.get(this.platform).getCreateClass();
    }

    @Override
    public final String getCreateMethod() {
        return taskMap.get(this.platform).getCreateMethod();
    }

    @Override
    public final Class<?>[] getCreateParamTypes() {
        return taskMap.get(this.platform).getCreateParamTypes();
    }

    @Override
    public final String getExportClass() {
        return taskMap.get(this.platform).getExportClass();
    }

    @Override
    public final String getExportMethod() {
        return taskMap.get(this.platform).getExportMethod();
    }

    @Override
    public final Class<?>[] getExportParamTypes() {
        return taskMap.get(this.platform).getExportParamTypes();
    }
}

