/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHandleCache;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHandleCacheHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonSystemDefinitionHandleCache
implements ISystemDefinitionHandleCache {
    protected Map<String, RepositoryCache> cache = new HashMap<String, RepositoryCache>();

    @Override
    public synchronized ISystemDefinitionHandle getSystemDefinitionHandle(UUID uuid, IItemType type, ISystemDefinitionHandleCacheHelper cacheHelper) throws TeamRepositoryException {
        Map<UUID, ISystemDefinitionHandle> typeCache;
        RepositoryCache repositoryCache = this.cache.get(cacheHelper.getRepositoryUri());
        if (repositoryCache == null) {
            repositoryCache = new RepositoryCache();
            this.cache.put(cacheHelper.getRepositoryUri(), repositoryCache);
        }
        if ((typeCache = repositoryCache.getCache(type.getName())) == null) {
            typeCache = new HashMap<UUID, ISystemDefinitionHandle>();
            List<ISystemDefinitionHandle> systemDefinitionHandles = cacheHelper.getAllSystemDefinitionHandles(type);
            for (ISystemDefinitionHandle systemDefinitionHandle : systemDefinitionHandles) {
                typeCache.put(systemDefinitionHandle.getItemId(), systemDefinitionHandle);
            }
            repositoryCache.putCache(type.getName(), typeCache);
        }
        return typeCache.get(uuid);
    }

    @Override
    public void deleteCache(IItemType type, ISystemDefinitionHandleCacheHelper cacheHelper) {
        RepositoryCache repositoryCache;
        if (cacheHelper.getRepositoryUri() != null && type != null && (repositoryCache = this.cache.get(cacheHelper.getRepositoryUri())) != null) {
            repositoryCache.clearCache(type.getName());
        }
    }

    class RepositoryCache {
        private Map<String, Map<UUID, ISystemDefinitionHandle>> cache = new HashMap<String, Map<UUID, ISystemDefinitionHandle>>();

        protected RepositoryCache() {
        }

        protected Map<UUID, ISystemDefinitionHandle> getCache(String systemDefinitionType) {
            return this.cache.get(systemDefinitionType);
        }

        protected void putCache(String systemDefinitionType, Map<UUID, ISystemDefinitionHandle> typeCache) {
            if (systemDefinitionType != null) {
                this.cache.put(systemDefinitionType, typeCache);
            }
        }

        protected void clearCache(String systemDefinitionType) {
            Map<UUID, ISystemDefinitionHandle> typeCache = this.cache.get(systemDefinitionType);
            if (typeCache != null) {
                typeCache.clear();
                typeCache = null;
                this.cache.put(systemDefinitionType, typeCache);
            }
        }
    }
}

