/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.helper.Messages;
import com.ibm.team.enterprise.systemdefinition.common.validation.ISystemDefinitionValidator;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractSystemDefinition
implements ISystemDefinition {
    private String fName;
    private String fDescription;
    private String fProjectAreaUuid;
    private boolean fIsArchived;
    private String fUuid;
    private boolean isNew = true;
    private Map<String, String> properties = new HashMap<String, String>(0);
    private String fStateId;
    private boolean fIsMigrated;
    private boolean nonImpacting;

    public AbstractSystemDefinition() {
        this.fUuid = UUID.generate().getUuidValue();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public void setDescription(String description) {
        this.fDescription = description;
    }

    @Override
    public String getProjectAreaUuid() {
        return this.fProjectAreaUuid;
    }

    @Override
    public void setProjectAreaUuid(String projectAreaUuid) {
        this.fProjectAreaUuid = projectAreaUuid;
    }

    @Override
    public boolean isArchived() {
        return this.fIsArchived;
    }

    @Override
    public void setArchived(boolean archive) {
        this.fIsArchived = archive;
    }

    @Override
    public abstract String getType();

    @Override
    public abstract String getPlatform();

    @Override
    public String getUuid() {
        return this.fUuid;
    }

    @Override
    public void setUuid(String uuid) {
        this.fUuid = uuid;
    }

    @Override
    public ISystemDefinitionValidator[] getValidators() {
        return null;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getStateId() {
        return this.fStateId;
    }

    @Override
    public void setStateId(String stateId) {
        this.fStateId = stateId;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public boolean isMigrated() {
        return this.fIsMigrated;
    }

    @Override
    public void setMigrated(boolean isMigrated) {
        this.fIsMigrated = isMigrated;
    }

    @Override
    public ISystemDefinition newCopy() {
        ISystemDefinition newCopy = this.newInstance();
        newCopy.setName(this.newCopyName(this.getName()));
        newCopy.setArchived(this.isArchived());
        newCopy.setDescription(this.getDescription());
        newCopy.setProjectAreaUuid(this.getProjectAreaUuid());
        newCopy.setNonImpacting(this.isNonImpacting());
        if (this.getProperties() != null) {
            newCopy.getProperties().putAll(this.getProperties());
        }
        return newCopy;
    }

    protected abstract ISystemDefinition newInstance();

    protected String newCopyName(String name) {
        return NLS.bind((String)Messages.getCommonString("SystemDefinitionNewCopy.Name"), (Object)name);
    }

    @Override
    public boolean isNonImpacting() {
        return this.nonImpacting;
    }

    @Override
    public void setNonImpacting(boolean nonImpacting) {
        this.nonImpacting = nonImpacting;
    }

    @Override
    public boolean isIgnoredOnceForBuild() {
        return this.properties != null && Boolean.parseBoolean(this.properties.get("ignoredOnceForBuild"));
    }

    @Override
    public void setIgnoredOnceForBuild(boolean ignoredOnceForBuild) {
        if (ignoredOnceForBuild) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>(1);
            }
            this.properties.put("ignoredOnceForBuild", "true");
        } else if (this.properties != null) {
            this.properties.remove("ignoredOnceForBuild");
        }
    }

    public int hashCode() {
        int prime = 31;
        return 31 + (this.fUuid == null ? 0 : this.fUuid.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSystemDefinition other = (AbstractSystemDefinition)obj;
        return !(this.fUuid == null ? other.fUuid != null : !this.fUuid.equals(other.fUuid));
    }
}

