/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.common;

import com.ibm.team.enterprise.systemdefinition.common.AbstractSystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.SystemDefinitionFactory;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.DependencyType;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.TranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.validation.DuplicateDefaultLanguageDefinitionValidator;
import com.ibm.team.enterprise.systemdefinition.common.validation.DuplicateLanguageDefinitionNameValidator;
import com.ibm.team.enterprise.systemdefinition.common.validation.ISystemDefinitionValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractLanguageDefinition
extends AbstractSystemDefinition
implements ILanguageDefinition {
    protected String fDefaultPatterns;
    protected List<IDependencyType> fDependencyTypes = new ArrayList<IDependencyType>();
    protected String fLanguageCode;
    protected List<String> fSourceCodeDataScanners = new ArrayList<String>();
    protected List<ITranslatorEntry> fTranslators = new ArrayList<ITranslatorEntry>();
    protected ISystemDefinitionValidator[] validators = new ISystemDefinitionValidator[]{new DuplicateLanguageDefinitionNameValidator(), new DuplicateDefaultLanguageDefinitionValidator()};
    protected List<IScopedProperty> scopedProperties = new ArrayList<IScopedProperty>();
    protected Map<String, ISystemDefinition> languageExtensionMap = new HashMap<String, ISystemDefinition>();
    protected boolean calculateImpacts = true;
    protected boolean consolidateLogs;

    @Override
    public String getType() {
        return "languagedefinition";
    }

    @Override
    public String getDefaultPatterns() {
        return this.fDefaultPatterns;
    }

    @Override
    public List<IDependencyType> getDependencyTypes() {
        return this.fDependencyTypes;
    }

    @Override
    public String getLanguageCode() {
        return this.fLanguageCode;
    }

    @Override
    public List<String> getSourceCodeDataScanners() {
        return this.fSourceCodeDataScanners;
    }

    @Override
    public List<ITranslatorEntry> getTranslators() {
        return this.fTranslators;
    }

    @Override
    public void setDefaultPatterns(String patterns) {
        if (patterns == null) {
            this.fDefaultPatterns = null;
        } else {
            StringBuilder builder = new StringBuilder();
            String[] patternTokens = patterns.toLowerCase().split(",");
            int size = patternTokens.length;
            int i = 0;
            while (i < size) {
                builder.append(patternTokens[i].trim());
                if (i < size - 1) {
                    builder.append(',');
                }
                ++i;
            }
            this.fDefaultPatterns = builder.toString();
        }
    }

    @Override
    public void setLanguageCode(String langCode) {
        this.fLanguageCode = langCode;
    }

    @Override
    public void setCalculateImpacts(boolean doCalculate) {
        this.calculateImpacts = doCalculate;
    }

    @Override
    public boolean isCalculateImpacts() {
        return this.calculateImpacts;
    }

    @Override
    public boolean isConsolidateLogs() {
        return this.consolidateLogs;
    }

    @Override
    public void setConsolidateLogs(boolean doConsolidate) {
        this.consolidateLogs = doConsolidate;
    }

    @Override
    public ISystemDefinitionValidator[] getValidators() {
        return this.validators;
    }

    @Override
    public ISystemDefinition newCopy() {
        ILanguageDefinition newCopy = (ILanguageDefinition)super.newCopy();
        newCopy.setCalculateImpacts(this.isCalculateImpacts());
        newCopy.setConsolidateLogs(this.isConsolidateLogs());
        List<IScopedProperty> properties = this.getScopedProperties();
        if (!properties.isEmpty()) {
            for (IScopedProperty scopedProperty : properties) {
                IScopedProperty tmp = SystemDefinitionFactory.createScopedProperty();
                tmp.setCondition(scopedProperty.getCondition());
                tmp.setName(scopedProperty.getName());
                tmp.setValue(scopedProperty.getValue());
                newCopy.getScopedProperties().add(tmp);
            }
        }
        for (IDependencyType dt : this.getDependencyTypes()) {
            DependencyType newDT = new DependencyType();
            newDT.setLevel(dt.getLevel());
            newDT.setName(dt.getName());
            newDT.getTranslators().addAll(dt.getTranslators());
            newCopy.getDependencyTypes().add(newDT);
        }
        newCopy.setLanguageCode(this.getLanguageCode());
        newCopy.getSourceCodeDataScanners().addAll(this.getSourceCodeDataScanners());
        for (ITranslatorEntry te : this.getTranslators()) {
            TranslatorEntry newTE = new TranslatorEntry();
            newTE.setKind(te.getKind());
            newTE.setValue(te.getValue());
            newCopy.getTranslators().add(newTE);
        }
        return newCopy;
    }

    @Override
    public List<IScopedProperty> getScopedProperties() {
        return this.scopedProperties;
    }

    @Override
    public Map<String, ISystemDefinition> getLanguageExtensionMap() {
        return this.languageExtensionMap;
    }
}

