/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.systemdefinition.common.util;

import com.ibm.team.enterprise.ibmi.systemdefinition.common.util.IBMiChangeLogUtil;
import com.ibm.team.enterprise.ibmi.systemdefinition.common.util.IBMiSystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHistoryProcessor;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.dto.DeltaType;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.IBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.common.util.ChangeLogUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.SearchPathUtils;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import java.util.List;

public class IBMiSystemDefinitionHistoryProcessor
implements ISystemDefinitionHistoryProcessor {
    @Override
    public void process(ISystemDefinition oldSystemDefinition, ISystemDefinition newSystemDefinition, ChangeLogDTO changeLog) {
        if (newSystemDefinition instanceof IIBMiTranslator) {
            this.addTranslatorDeltas(oldSystemDefinition, (IIBMiTranslator)newSystemDefinition, changeLog);
        } else if (newSystemDefinition instanceof IIBMiSearchPath) {
            this.addSearchPathChangeLogDeltas(oldSystemDefinition, (IIBMiSearchPath)newSystemDefinition, changeLog);
        } else if (newSystemDefinition instanceof IIBMiResourceDefinition) {
            this.addResourceDefinitionDeltas(oldSystemDefinition, (IBMiResourceDefinition)newSystemDefinition, changeLog);
        }
    }

    private void addTranslatorDeltas(ISystemDefinition oldSystemDefinition, IIBMiTranslator newTranslator, ChangeLogDTO changeLog) {
        boolean oldIntrospection = false;
        boolean oldIgnore = false;
        String oldOutputType = null;
        String oldDeployType = null;
        OutputNameKind oldOutputKind = null;
        String oldOutputName = null;
        String oldSearchPath = null;
        String oldCommandExist = null;
        Boolean oldIsSame = null;
        String oldCommandNotExist = null;
        IIBMiTranslator oldTranslator = null;
        if (oldSystemDefinition instanceof IIBMiTranslator) {
            oldTranslator = (IIBMiTranslator)oldSystemDefinition;
            oldIntrospection = oldTranslator.isIntrospection();
            oldIgnore = oldTranslator.isNonImpacting();
            oldOutputType = oldTranslator.getOutputType();
            oldDeployType = oldTranslator.getDeployType();
            oldOutputKind = oldTranslator.getOutputNameKind();
            oldOutputName = oldTranslator.getOutputName();
            oldSearchPath = oldTranslator.getSearchPath();
            oldCommandExist = oldTranslator.getCommandIfObjectExists();
            oldCommandNotExist = oldTranslator.getCommandIfObjectDoesntExist();
            if (oldCommandExist != null && oldCommandNotExist != null) {
                oldIsSame = oldCommandExist.equals(oldCommandNotExist);
            }
        }
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_INTROSPECTION_TAG.getWholeTagName(), oldIntrospection, newTranslator.isIntrospection(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG.getWholeTagName(), oldIgnore, newTranslator.isNonImpacting(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_TYPE_TAG.getWholeTagName(), oldOutputType, newTranslator.getOutputType(), false, oldSystemDefinition == null);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_KIND_TAG.getWholeTagName(), (Object)oldOutputKind, (Object)newTranslator.getOutputNameKind(), null, false, false);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_TAG.getWholeTagName(), oldOutputName, newTranslator.getOutputName(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_DEPLOY_TYPE_TAG.getWholeTagName(), oldDeployType, newTranslator.getDeployType(), false, oldSystemDefinition == null);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG.getWholeTagName(), oldSearchPath, newTranslator.getSearchPath(), null, false, false);
        String newCommandExist = newTranslator.getCommandIfObjectExists();
        String newCommandNotExist = newTranslator.getCommandIfObjectDoesntExist();
        Boolean isSame = null;
        if (newCommandExist != null && newCommandNotExist != null) {
            isSame = newCommandExist.equals(newCommandNotExist);
        }
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_EXISTS_TAG.getWholeTagName(), oldCommandExist, newCommandExist, true, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_IS_SAME_TAG.getWholeTagName(), oldIsSame, isSame, false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_DOESNT_EXIST_TAG.getWholeTagName(), oldCommandNotExist, newCommandNotExist, true, oldSystemDefinition == null);
    }

    private void addSearchPathChangeLogDeltas(ISystemDefinition oldSystemDefinition, IIBMiSearchPath newSearchPath, ChangeLogDTO changeLog) {
        boolean isNew = oldSystemDefinition == null;
        String thisObjectLib = SearchPathUtils.getObjectLibraryUUID(newSearchPath);
        List<String> thisRefLibs = SearchPathUtils.getReferencedLibrariesUUIDs(newSearchPath);
        String oldObjectLib = null;
        List<String> oldRefLibs = null;
        Boolean oldImpact = null;
        if (oldSystemDefinition instanceof IIBMiSearchPath) {
            oldObjectLib = SearchPathUtils.getObjectLibraryUUID((IIBMiSearchPath)oldSystemDefinition);
            oldRefLibs = SearchPathUtils.getReferencedLibrariesUUIDs((IIBMiSearchPath)oldSystemDefinition);
            oldImpact = oldSystemDefinition.isNonImpacting();
        }
        DeltaType deltaType = ChangeLogUtil.getDeltaType(oldSystemDefinition, newSearchPath);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ISEARCHPATH_OBJECT_LIBRARY_TAG.getWholeTagName(), oldObjectLib, thisObjectLib, DeltaType.UUID, false, false);
        if (thisRefLibs.size() > 0 || oldRefLibs != null && oldRefLibs.size() > 0) {
            IBMiChangeLogUtil.generateReferencedLibChanges(changeLog.getChanges(), IBMiSystemDefinitionUtil.ISEARCHPATH_REFERENCED_LIBRARY_TAG.getWholeTagName(), oldRefLibs, thisRefLibs, deltaType, isNew);
        }
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG.getWholeTagName(), oldImpact, newSearchPath.isNonImpacting(), false, isNew);
    }

    private void addResourceDefinitionDeltas(ISystemDefinition oldSystemDefinition, IIBMiResourceDefinition newResourceDef, ChangeLogDTO changeLog) {
        boolean isNew = oldSystemDefinition == null;
        IIBMiResourceDefinition oldResourceDef = null;
        String oldResourceName = null;
        Boolean oldImpact = null;
        if (oldSystemDefinition instanceof IIBMiResourceDefinition) {
            oldResourceDef = (IIBMiResourceDefinition)oldSystemDefinition;
            oldResourceName = oldResourceDef.getResourceName();
            oldImpact = oldResourceDef.isNonImpacting();
        }
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG.getWholeTagName(), oldImpact, newResourceDef.isNonImpacting(), false, isNew);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IBMiSystemDefinitionUtil.ISEARCHPATH_LIBRARY_TAG.getWholeTagName(), oldResourceName, newResourceDef.getResourceName(), true, isNew);
    }
}

