/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.repository.common.UUID;
import java.util.Map;

public class IBMiSearchPathUtilities {
    private static boolean isValidBuildProperty(String value) {
        return value.startsWith("${") && value.endsWith("}");
    }

    public static String calculateEffectiveSearchPath(IIBMiTranslator translator, String defaultSP) {
        String effectivePath;
        String path = translator.getSearchPath();
        String string = effectivePath = path == null || path.trim().isEmpty() ? null : path;
        if (effectivePath == null && defaultSP != null && !defaultSP.trim().isEmpty()) {
            effectivePath = defaultSP;
        }
        return effectivePath;
    }

    public static String getUuidFromSPString(String value, Map<String, String> fBuildProperties, StringBuffer missingPropertyName) {
        String uuidString = value.trim();
        if (IBMiSearchPathUtilities.isValidBuildProperty(value)) {
            String propertyName = value.substring(2, value.length() - 1);
            String propertyValue = fBuildProperties.get(propertyName);
            if (propertyValue == null) {
                missingPropertyName.append(propertyName);
                uuidString = null;
            } else {
                uuidString = IBMiSearchPathUtilities.getUuidFromSPString(propertyValue.trim(), fBuildProperties, missingPropertyName);
            }
        }
        return uuidString;
    }

    public static boolean isValidUUID(String value) {
        boolean isValid = true;
        try {
            UUID.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            isValid = false;
        }
        return isValid;
    }
}

