/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.systemdefinition.common.parsers;

import com.ibm.team.enterprise.ibmi.systemdefinition.common.impl.IBMiTranslator;
import com.ibm.team.enterprise.ibmi.systemdefinition.common.util.IBMiSystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractTranslatorParser;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IBMiTranslatorParser
extends AbstractTranslatorParser
implements ISystemDefinitionParser {
    @Override
    protected ITranslator newTranslator() {
        return new IBMiTranslator();
    }

    @Override
    protected void parseTranslator(Element rdfDescriptionElement, ITranslator translator) {
        super.parseTranslator(rdfDescriptionElement, translator);
        IBMiTranslator ibmiTranslator = (IBMiTranslator)translator;
        String attr = this.readAttributeFromChildElement(rdfDescriptionElement, IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG);
        if (attr != null) {
            ibmiTranslator.setSearchPath(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_TYPE_TAG)) != null) {
            ibmiTranslator.setOutputType(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IBMiSystemDefinitionUtil.ITRANSLATOR_DEPLOY_TYPE_TAG)) != null) {
            ibmiTranslator.setDeployType(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_EXISTS_TAG)) != null) {
            ibmiTranslator.getCommandIfObjectExists().setCommand(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_DOESNT_EXIST_TAG)) != null) {
            ibmiTranslator.getCommandIfObjectDoesntExist().setCommand(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IBMiSystemDefinitionUtil.ITRANSLATOR_INTROSPECTION_TAG)) != null) {
            ibmiTranslator.setIntrospection(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_KIND_TAG)) != null && attr.trim().length() > 0) {
            ibmiTranslator.setOutputNameKind(ITranslator.OutputNameKind.valueOf(attr));
            if (ibmiTranslator.getOutputNameKind() != ITranslator.OutputNameKind.SAME_AS_INPUT && (attr = this.readAttributeFromChildElement(rdfDescriptionElement, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_TAG)) != null && attr.trim().length() > 0) {
                ibmiTranslator.setOutputName(attr);
            }
        }
    }

    @Override
    protected Element convertToRdfElement(Document doc, ISystemDefinition systemDefinition) {
        Element rdfElement = super.convertToRdfElement(doc, systemDefinition);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(IBMiSystemDefinitionUtil.ITRANSLATOR_NAMESPACE.getPrefix()).toString());
        attr.setValue(IBMiSystemDefinitionUtil.ITRANSLATOR_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attr);
        return rdfElement;
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        IBMiTranslator ibmiTranslator = (IBMiTranslator)systemDefinition;
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG, ibmiTranslator.getSearchPath());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_TYPE_TAG, ibmiTranslator.getOutputType());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_EXISTS_TAG, ibmiTranslator.getCommandIfObjectExists().getCommand());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_DOESNT_EXIST_TAG, ibmiTranslator.getCommandIfObjectDoesntExist().getCommand());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_INTROSPECTION_TAG, String.valueOf(ibmiTranslator.isIntrospection()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_KIND_TAG, ibmiTranslator.getOutputNameKind().name());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_TAG, ibmiTranslator.getOutputName());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_DEPLOY_TYPE_TAG, ibmiTranslator.getDeployType());
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        IIBMiTranslator ibmiTranslator = (IIBMiTranslator)systemDefinition;
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG, ibmiTranslator.getSearchPath());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_TYPE_TAG, ibmiTranslator.getOutputType());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_EXISTS_TAG, ibmiTranslator.getCommandIfObjectExists());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_DOESNT_EXIST_TAG, ibmiTranslator.getCommandIfObjectDoesntExist());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_INTROSPECTION_TAG, String.valueOf(ibmiTranslator.isIntrospection()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_KIND_TAG, ibmiTranslator.getOutputNameKind().getName());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_TAG, ibmiTranslator.getOutputName());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IBMiSystemDefinitionUtil.ITRANSLATOR_DEPLOY_TYPE_TAG, ibmiTranslator.getDeployType());
    }
}

