/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.util;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.Activator;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DataSetDefinition {
    private static final String className = DataSetDefinition.class.getSimpleName();

    public static IDataSetDefinition fetch(ITeamRepository repository, String itemString) throws TeamRepositoryException {
        return DataSetDefinition.fetch(repository, itemString, (IDebugger)new Debugger(DataSetDefinition.class));
    }

    public static IDataSetDefinition fetch(ITeamRepository repository, String itemString, IDebugger dbg) throws TeamRepositoryException {
        IDataSetDefinition definition = null;
        Result result = new Result();
        Job fetchJob = DataSetDefinition.fetchJob(repository, itemString, result);
        try {
            fetchJob.schedule();
            fetchJob.join();
            definition = (IDataSetDefinition)result.result;
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)definition)});
        }
        return definition;
    }

    private static Job fetchJob(final ITeamRepository repository, final String uuid, final Result result) {
        Job fetchJob = new Job(Messages.Common_FETCH_ITEM){

            protected IStatus run(IProgressMonitor monitor) {
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
                try {
                    result.result = client.findSystemDefinition(uuid, null, IDataSetDefinition.ITEM_TYPE, monitor);
                }
                catch (TeamRepositoryException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        return fetchJob;
    }

    public static IDataSetDefinition get(ITeamRepository repository, String itemString) throws TeamRepositoryException {
        return DataSetDefinition.get(repository, null, null, itemString, (IProgressMonitor)new NullProgressMonitor(), (IDebugger)new Debugger(DataSetDefinition.class));
    }

    public static IDataSetDefinition get(ITeamRepository repository, String itemString, IProgressMonitor monitor) throws TeamRepositoryException {
        return DataSetDefinition.get(repository, null, null, itemString, monitor, (IDebugger)new Debugger(DataSetDefinition.class));
    }

    public static IDataSetDefinition get(ITeamRepository repository, String itemString, IDebugger dbg) throws TeamRepositoryException {
        return DataSetDefinition.get(repository, null, null, itemString, (IProgressMonitor)new NullProgressMonitor(), dbg);
    }

    public static IDataSetDefinition get(ITeamRepository repository, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        return DataSetDefinition.get(repository, null, null, itemString, monitor, dbg);
    }

    public static IDataSetDefinition get(ITeamRepository repository, IDataSetDefinition item, IDataSetDefinitionHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        ISystemDefinition definition = null;
        if (item != null) {
            definition = client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)item, true, monitor);
        } else if (itemHandle != null) {
            definition = client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)itemHandle, true, monitor);
        } else if (itemString != null) {
            definition = Verification.isUUID((String)itemString) ? client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)IResourceDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemString), null), true, monitor) : client.findSystemDefinitionByName(itemString, IResourceDefinition.ITEM_TYPE, monitor);
        }
        if (definition == null) {
            return (IDataSetDefinition)definition;
        }
        if (!(definition instanceof IDataSetDefinition)) {
            return null;
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)definition)});
        }
        return (IDataSetDefinition)definition;
    }

    public static IDataSetDefinition getState(ITeamRepository repository, String itemUuid, String stateUuid) throws TeamRepositoryException {
        return DataSetDefinition.getState(repository, itemUuid, stateUuid, (IProgressMonitor)new NullProgressMonitor(), (IDebugger)new Debugger(DataSetDefinition.class));
    }

    public static IDataSetDefinition getState(ITeamRepository repository, String itemUuid, String stateUuid, IProgressMonitor monitor) throws TeamRepositoryException {
        return DataSetDefinition.getState(repository, itemUuid, stateUuid, monitor, (IDebugger)new Debugger(DataSetDefinition.class));
    }

    public static IDataSetDefinition getState(ITeamRepository repository, String itemUuid, String stateUuid, IDebugger dbg) throws TeamRepositoryException {
        return DataSetDefinition.getState(repository, itemUuid, stateUuid, (IProgressMonitor)new NullProgressMonitor(), dbg);
    }

    public static IDataSetDefinition getState(ITeamRepository repository, String itemUuid, String stateUuid, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        ISystemDefinition definition = null;
        if (Verification.isUUID((String)itemUuid) && Verification.isUUID((String)stateUuid)) {
            definition = client.findSystemDefinition(itemUuid, stateUuid, IDataSetDefinition.ITEM_TYPE, monitor);
        }
        if (definition == null) {
            return (IDataSetDefinition)definition;
        }
        if (!(definition instanceof IDataSetDefinition)) {
            return null;
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)definition)});
        }
        return (IDataSetDefinition)definition;
    }

    public static List<IDataSetDefinition> get(ITeamRepository repository, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        return DataSetDefinition.get(repository, projectArea, (IProgressMonitor)new NullProgressMonitor(), (IDebugger)new Debugger(DataSetDefinition.class));
    }

    public static List<IDataSetDefinition> get(ITeamRepository repository, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return DataSetDefinition.get(repository, projectArea, monitor, (IDebugger)new Debugger(DataSetDefinition.class));
    }

    public static List<IDataSetDefinition> get(ITeamRepository repository, IProjectAreaHandle projectArea, IDebugger dbg) throws TeamRepositoryException {
        return DataSetDefinition.get(repository, projectArea, (IProgressMonitor)new NullProgressMonitor(), dbg);
    }

    public static List<IDataSetDefinition> get(ITeamRepository repository, IProjectAreaHandle projectArea, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        ArrayList<IDataSetDefinition> itemList = new ArrayList<IDataSetDefinition>();
        List<ISystemDefinition> items = client.findSystemDefinitions(IDataSetDefinition.ITEM_TYPE, projectArea, -1, false, Arrays.asList(IDataSetDefinition.SMALL_PROFILE), monitor);
        itemList.addAll(items);
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }

    public static List<IDataSetDefinition> get(ITeamRepository repository, List<IDataSetDefinition> items, List<IDataSetDefinitionHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        ArrayList<IDataSetDefinition> itemList = new ArrayList<IDataSetDefinition>();
        if (items != null) {
            List<ISystemDefinition> fetched = client.fetchSystemDefinitionsComplete(items, true, monitor);
            itemList.addAll(fetched);
        } else if (itemHandles != null) {
            List<ISystemDefinition> fetched = client.fetchSystemDefinitionsComplete(itemHandles, true, monitor);
            itemList.addAll(fetched);
        } else if (itemStrings != null && itemStrings.get(0) != null) {
            if (Verification.isUUID((String)itemStrings.get(0))) {
                ArrayList<ISystemDefinitionHandle> handles = new ArrayList<ISystemDefinitionHandle>();
                for (String uuid : itemStrings) {
                    handles.add((ISystemDefinitionHandle)IResourceDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
                }
                List<ISystemDefinition> fetched = client.fetchSystemDefinitionsComplete(handles, true, monitor);
                itemList.addAll(fetched);
            } else {
                for (String name : itemStrings) {
                    itemList.add((IDataSetDefinition)client.findSystemDefinitionByName(name, IResourceDefinition.ITEM_TYPE, monitor));
                }
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }

    private static class Result {
        protected Object result;

        private Result() {
        }
    }
}

