/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebugUtility;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.common.common.ZPackagingNature;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterProperties;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingLanguage;
import com.ibm.team.enterprise.systemdefinition.client.importer.ImportLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterConstants;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

@DebugGroup(value={"zPackaging"})
@DebugUtility(value=true)
public class PackagingUtilities {
    private static String cls = PackagingUtilities.class.getSimpleName();
    private static IDebugger dbg = new Debugger(PackagingUtilities.class);
    private static final String LanguageExport = ".*?\\.Export\\.Language\\..*?\\.xml";

    private PackagingUtilities() {
    }

    public static List<IImporterLanguage> getLanguages(IProject project) throws ImporterException {
        Mnm mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
        ArrayList<IImporterLanguage> result = new ArrayList<IImporterLanguage>();
        IFolder resource = project.getFolder(".config");
        if (!resource.exists()) {
            throw new ImporterException(NLS.bind((String)Messages.zPackaging_UTILITY_FOLDER_NONEXISTS, (Object)".config", (Object)project.getName()));
        }
        try {
            File[] exports;
            File folder = resource.getLocation().toFile();
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(PackagingUtilities.LanguageExport);
                }
            };
            File[] fileArray = exports = folder.listFiles(filter);
            int n = exports.length;
            int n2 = 0;
            while (n2 < n) {
                File export = fileArray[n2];
                ImportLanguage importer = new ImportLanguage(PackagingLanguage.class);
                importer.parseFile(export);
                result.addAll(importer.getImports());
                ++n2;
            }
        }
        catch (Exception e) {
            throw new ImporterException((Throwable)e);
        }
        mnm.leave(new Object[]{result});
        return result;
    }

    public static IProject[] getProjects() {
        Mnm mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.hasNature(ZPackagingNature.ID)) {
                    projectList.add(project);
                }
            }
            catch (CoreException e) {
                System.out.println(NLS.bind((String)Messages.zPackaging_PROJECT_NAME_EXCEPTION, (Object)project.getName()));
                e.printStackTrace();
            }
            ++n2;
        }
        mnm.leave(new Object[]{projectList.size()});
        return projectList.toArray(new IProject[projectList.size()]);
    }

    public static Properties getProperties(IProject project) {
        Properties properties;
        Mnm mnm;
        block14: {
            mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
            IFile propertiesFile = project.getFile(IImporterConstants.PATH_PROPERTIES);
            properties = new Properties();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(propertiesFile.getRawLocation().makeAbsolute().toFile());
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        mnm.leave(new Object[]{properties.size()});
        return properties;
    }

    public static IImporterProperties getProjectProperties(IProject project) {
        return new ImporterProperties(PackagingUtilities.getProperties(project));
    }

    public static boolean isProjectValid(IProject project) {
        Mnm mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
        boolean result = false;
        if (Verification.isNonNull((Object)project)) {
            try {
                if (project.hasNature(ZPackagingNature.ID)) {
                    result = true;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        mnm.leave(new Object[]{result});
        return result;
    }

    public static boolean isProjectNameValid(String projectName) {
        Mnm mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
        boolean result = true;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(projectName, 4);
        if (!status.isOK()) {
            result = false;
        }
        if (projectName.indexOf(32) > -1) {
            result = false;
        }
        mnm.leave(new Object[]{result});
        return result;
    }

    public static void validateProjectName(String projectName) throws ImporterException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(projectName, 4);
        if (!status.isOK()) {
            throw new ImporterException(NLS.bind((String)Messages.zPackaging_PROJECT_NAME_ISINVALID, (Object)projectName, (Object)status.getMessage()), status);
        }
        if (projectName.indexOf(32) > -1) {
            throw new ImporterException(NLS.bind((String)Messages.zPackaging_PROJECT_NAME_ISINVALID, (Object)projectName, (Object)Messages.zPackaging_PROJECT_NAME_HASSPACES));
        }
        new Mnm(){}.inout(dbg, cls, new String[0]);
    }
}

