/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingFactory;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterPropertyKey;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemFile;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemFolder;
import com.ibm.team.enterprise.systemdefinition.common.model.Disttype;
import com.ibm.team.enterprise.systemdefinition.common.model.Hfsdata;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.Id;
import com.ibm.team.enterprise.systemdefinition.common.model.Mcstype;
import com.ibm.team.enterprise.systemdefinition.common.model.Processor;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDataset;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.scm.common.IVersionable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PackagingTools {
    private final IDebugger dbg;
    private final String simpleName;
    private final boolean useItemCache;
    private final Map<String, IPackagingDataset> packagingDatasetMap;

    public PackagingTools() {
        this(false, (IDebugger)new Debugger(PackagingTools.class));
    }

    public PackagingTools(boolean useItemCache) {
        this(useItemCache, (IDebugger)new Debugger(PackagingTools.class));
    }

    public PackagingTools(IDebugger dbg) {
        this(false, dbg);
    }

    public PackagingTools(boolean useItemCache, IDebugger dbg) {
        this.useItemCache = useItemCache;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.packagingDatasetMap = null;
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public PackagingTools(Map<String, IPackagingDataset> packagingDatasetMap) {
        this(packagingDatasetMap, false, (IDebugger)new Debugger(PackagingTools.class));
    }

    public PackagingTools(Map<String, IPackagingDataset> packagingDatasetMap, boolean useItemCache) {
        this(packagingDatasetMap, useItemCache, (IDebugger)new Debugger(PackagingTools.class));
    }

    public PackagingTools(Map<String, IPackagingDataset> packagingDatasetMap, IDebugger dbg) {
        this(packagingDatasetMap, false, dbg);
    }

    public PackagingTools(Map<String, IPackagingDataset> packagingDatasetMap, boolean useItemCache, IDebugger dbg) {
        this.useItemCache = useItemCache;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.packagingDatasetMap = packagingDatasetMap;
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final IPackagingItem createPackagingFileItem(IVersionable file, ITeamRepository repository, IPackagingItem packagingFolder) {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        IProjectAreaHandle projectArea = packagingFolder.getProjectArea();
        Map propertyMap = file.getUserProperties();
        ArrayList<String> addUuids = null;
        ArrayList<String> orderUuids = null;
        ArrayList<String> removeUuids = null;
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.tableAdd") && Verification.isNonBlank((String)((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableAdd")))) {
            addUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableAdd")).split(",")));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.tableOrder") && Verification.isNonBlank((String)((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableOrder")))) {
            orderUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableOrder")).split(",")));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.tableRemove") && Verification.isNonBlank((String)((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableRemove")))) {
            removeUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableRemove")).split(",")));
        }
        PackagingItemFile packagingFile = new PackagingItemFile(packagingFolder, this.dbg);
        packagingFile.init(addUuids, removeUuids, orderUuids);
        packagingFile.setName(file.getName());
        packagingFile.setNonImpacting(packagingFolder.isNonImpacting());
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.alias") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.alias"))) {
            packagingFile.setAlias((String)propertyMap.get("team.enterprise.smpe.packaging.file.alias"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.class") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.class"))) {
            packagingFile.setClazz((String)propertyMap.get("team.enterprise.smpe.packaging.file.class"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.csect") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.csect"))) {
            packagingFile.setCsect((String)propertyMap.get("team.enterprise.smpe.packaging.file.csect"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.deleted") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.deleted")))) {
            packagingFile.setDeleted(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.deleted"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.description") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.description"))) {
            packagingFile.setDescription((String)propertyMap.get("team.enterprise.smpe.packaging.file.description"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.disttype") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.disttype"))) {
            packagingFile.setDisttype(Disttype.get((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.disttype"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.fmid") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.fmid"))) {
            packagingFile.setFmid((IFunctionDefinitionHandle)this.getFunction(repository, projectArea, (String)propertyMap.get("team.enterprise.smpe.packaging.file.fmid")));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.ignore") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.ignore")))) {
            packagingFile.setIgnore(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.ignore"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.jclin") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.jclin")))) {
            packagingFile.setJclin(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.jclin"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.hfsdata") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.hfsdata"))) {
            packagingFile.setHfsdata(Hfsdata.get((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.hfsdata"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.hfspath") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.hfspath"))) {
            packagingFile.setHfspath((String)propertyMap.get("team.enterprise.smpe.packaging.file.hfspath"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.leparm") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.leparm"))) {
            packagingFile.setLeparm((String)propertyMap.get("team.enterprise.smpe.packaging.file.leparm"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.mcsclass") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.mcsclass"))) {
            packagingFile.setMcsclass(Mcstype.get((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.mcsclass"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.module") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.module"))) {
            packagingFile.setModule((String)propertyMap.get("team.enterprise.smpe.packaging.file.module"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.originalfmid") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.originalfmid"))) {
            packagingFile.setOriginalFmid((IFunctionDefinitionHandle)this.getFunction(repository, projectArea, (String)propertyMap.get("team.enterprise.smpe.packaging.file.originalfmid")));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.originalstateid") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.originalstateid"))) {
            packagingFile.setOriginalStateId(UUID.valueOf((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.originalstateid"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.updated") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.updated")))) {
            packagingFile.setUpdated(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.updated"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.transform") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.transform")))) {
            packagingFile.setTransform(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.transform"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.vpl") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.vpl")))) {
            packagingFile.setVpl(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.vpl"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.binary")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.binary", new CommandBinary());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.description")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.description", new CommandDescription());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.distlib")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.distlib", new CommandDistlib());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.distname")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.distname", new CommandDistname());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.extension")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.extension", new CommandExtension());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.fmidoverride")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.fmidoverride", new CommandFmidoverride());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.folder")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.folder", new CommandFolder());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.id")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.id", new CommandId());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.location")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.location", new CommandLocation());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.mcstype")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.mcstype", new CommandMcstype());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.originaldistlib")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.originaldistlib", new CommandOriginalDistlib());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.originalfmidoverride")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.originalfmidoverride", new CommandOriginalFmidoverride());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.originalsyslib")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.originalsyslib", new CommandOriginalSyslib());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.name")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.name", new CommandName());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.processor")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.processor", new CommandProcessor());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.relfileOverride")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.relfileOverride", new CommandRelfileOverride());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.shipalias")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.shipalias", new CommandShipalias());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.syslib")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.syslib", new CommandSyslib());
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        return packagingFile;
    }

    public final IPackagingItem createPackagingFolderItem(IVersionable folder, ITeamRepository repository, IPackagingItem packagingLanguage) {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        IProjectAreaHandle projectArea = packagingLanguage.getProjectArea();
        String propertySuffix = packagingLanguage.getLanguage().getItemId().getUuidValue();
        if (Verification.isNonEmpty((List)packagingLanguage.getLanguage().getDefaultPatterns()) && ((IStringHelper)packagingLanguage.getLanguage().getDefaultPatterns().get(0)).getValue().equalsIgnoreCase(folder.getName())) {
            propertySuffix = "";
        }
        IImporterPropertyKey propertyKey = PackagingFactory.createPropertyKey(propertySuffix);
        Map propertyMap = folder.getUserProperties();
        ArrayList<String> addUuids = null;
        ArrayList<String> orderUuids = null;
        ArrayList<String> removeUuids = null;
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableAdd")) && Verification.isNonBlank((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableAdd"))))) {
            addUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableAdd"))).split(",")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableOrder")) && Verification.isNonBlank((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableOrder"))))) {
            orderUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableOrder"))).split(",")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableRemove")) && Verification.isNonBlank((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableRemove"))))) {
            removeUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableRemove"))).split(",")));
        }
        PackagingItemFolder packagingFolder = new PackagingItemFolder(packagingLanguage, this.dbg);
        packagingFolder.init(addUuids, removeUuids, orderUuids);
        packagingFolder.setName(folder.getName());
        packagingFolder.setNonImpacting(packagingLanguage.isNonImpacting());
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.alias")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.alias")))) {
            packagingFolder.setAlias((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.alias")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.class")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.class")))) {
            packagingFolder.setClazz((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.class")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.csect")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.csect")))) {
            packagingFolder.setCsect((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.csect")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.deleted")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.deleted"))))) {
            packagingFolder.setDeleted(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.deleted")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.description")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.description")))) {
            packagingFolder.setDescription((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.description")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.disttype")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.disttype")))) {
            packagingFolder.setDisttype(Disttype.get((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.disttype")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.fmid")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.fmid")))) {
            packagingFolder.setFmid((IFunctionDefinitionHandle)this.getFunction(repository, projectArea, (String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.fmid"))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.ignore")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.ignore"))))) {
            packagingFolder.setIgnore(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.ignore")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.hfsdata")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.hfsdata")))) {
            packagingFolder.setHfsdata(Hfsdata.get((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.hfsdata")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.hfspath")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.hfspath")))) {
            packagingFolder.setHfspath((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.hfspath")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.leparm")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.leparm")))) {
            packagingFolder.setLeparm((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.leparm")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.mcsclass")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.mcsclass")))) {
            packagingFolder.setMcsclass(Mcstype.get((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.mcsclass")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.module")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.module")))) {
            packagingFolder.setModule((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.module")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.originalfmid")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.originalfmid")))) {
            packagingFolder.setOriginalFmid((IFunctionDefinitionHandle)this.getFunction(repository, projectArea, (String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.originalfmid"))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.originalstateid")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.originalstateid")))) {
            packagingFolder.setOriginalStateId(UUID.valueOf((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.originalstateid")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.updated")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.updated"))))) {
            packagingFolder.setUpdated(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.updated")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.transform")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.transform"))))) {
            packagingFolder.setTransform(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.transform")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.vpl")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.vpl"))))) {
            packagingFolder.setVpl(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.vpl")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.binary"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.binary"), new CommandBinary());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.description"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.description"), new CommandDescription());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distlib"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distlib"), new CommandDistlib());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distname"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distname"), new CommandDistname());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.extension"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.extension"), new CommandExtension());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.fmidoverride"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.fmidoverride"), new CommandFmidoverride());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.folder"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.folder"), new CommandFolder());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.id"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.id"), new CommandId());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.location"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.location"), new CommandLocation());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.mcstype"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.mcstype"), new CommandMcstype());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originaldistlib"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originaldistlib"), new CommandOriginalDistlib());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalfmidoverride"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalfmidoverride"), new CommandOriginalFmidoverride());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalsyslib"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalsyslib"), new CommandOriginalSyslib());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.name"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.name"), new CommandName());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.processor"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.processor"), new CommandProcessor());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.shipalias"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.shipalias"), new CommandShipalias());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.syslib"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.syslib"), new CommandSyslib());
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        return packagingFolder;
    }

    private IDataSetDefinitionHandle getDataset(ITeamRepository repository, IProjectAreaHandle projectArea, String uuid) {
        if (this.packagingDatasetMap != null) {
            return (IDataSetDefinitionHandle)this.packagingDatasetMap.get(uuid);
        }
        if (this.useItemCache) {
            return (IDataSetDefinitionHandle)ItemCacheFactory.getDataset(repository, projectArea).getUuid(uuid);
        }
        return (IDataSetDefinitionHandle)ItemCacheFactory.getDataset(repository, projectArea).getUuid(uuid);
    }

    private IFunctionDefinition getFunction(ITeamRepository repository, IProjectAreaHandle projectArea, String uuid) {
        if (this.useItemCache) {
            return ItemCacheFactory.getFunction(repository, projectArea).getUuid(uuid);
        }
        return ItemCacheFactory.getFunction(repository, projectArea).getUuid(uuid);
    }

    private JSONObject getJsonObject(String jsonString) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSONObject.parse((Reader)new StringReader(jsonString));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private void setPackagingDetailValues(IPackagingItem packagingItem, Map<String, String> propertyMap, String propertyKey, Command command) {
        JSONObject jsonObject = this.getJsonObject(propertyMap.get(propertyKey));
        for (Object key : jsonObject.keySet()) {
            if (!(key instanceof String)) continue;
            String uuid = (String)key;
            String value = (String)jsonObject.get(key);
            if (!packagingItem.hasPackagingDetail(uuid)) continue;
            command.execute(packagingItem, uuid, value.replaceAll("%20", " "));
        }
    }

    public static interface Command {
        public void execute(IPackagingItem var1, String var2, String var3);
    }

    public class CommandBinary
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setBinary(uuid, Verification.toBoolean((String)value));
        }
    }

    public class CommandDescription
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setDescription(uuid, value);
        }
    }

    public class CommandDistlib
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setDistlib(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandDistname
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setDistname(uuid, value);
        }
    }

    public class CommandExtension
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setExtension(uuid, value);
        }
    }

    public class CommandFmidoverride
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setFmidoverride(uuid, (IFunctionDefinitionHandle)PackagingTools.this.getFunction((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandFolder
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setFolder(uuid, value);
        }
    }

    public class CommandId
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setId(uuid, Id.get((String)value));
        }
    }

    public class CommandLocation
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setLocation(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandMcstype
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setMcstype(uuid, Mcstype.get((String)value));
        }
    }

    public class CommandName
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setName(uuid, value);
        }
    }

    public class CommandOriginalDistlib
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setOriginalDistlib(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandOriginalFmidoverride
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setOriginalFmidoverride(uuid, (IFunctionDefinitionHandle)PackagingTools.this.getFunction((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandOriginalSyslib
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setOriginalSyslib(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandProcessor
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setProcessor(uuid, Processor.get((String)value));
        }
    }

    public class CommandRelfileOverride
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            IPackagingDetailDefinition detailDefinition = packagingItem.getDetail(uuid);
            if (detailDefinition != null && detailDefinition instanceof IPackagingDetail) {
                IPackagingDetail detail = (IPackagingDetail)detailDefinition;
                detail.setRelfileOverride(Integer.valueOf(value));
            }
        }
    }

    public class CommandShipalias
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setShipalias(uuid, value);
        }
    }

    public class CommandSyslib
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setSyslib(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }
}

