/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.common.ICommonConstants;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterTemplate;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public class PackagingTemplateFactory {
    public static final String Path = "templates/packaging";

    private PackagingTemplateFactory() {
    }

    public static final String getBuild(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/sysdefs/Build.%s.xml", type).getTemplate(tokens);
    }

    public static final String getBuildLaunch(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/_launch/Build.%s.xml.launch", type).getTemplate(tokens);
    }

    public static final String getEngine(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/engines/Engine.JBE.xml", type).getTemplate(tokens);
    }

    public static final String getEngineLaunch(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/_launch/Engine.JBE.xml.launch", type).getTemplate(tokens);
    }

    public static final String getJclinJob(List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/utilities/job.jclin").getTemplate(tokens);
    }

    public static final String getJclinStepLink(List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/utilities/step.link.jclin").getTemplate(tokens);
    }

    public static final String getLanguage(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/sysdefs/Language.%s.xml", type).getTemplate(tokens);
    }

    public static final String getLanguageDocument(IImporterLanguage language) {
        String result = "";
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(language.createDocument());
            transformer.transform(source, streamResult);
            result = streamResult.getWriter().toString().replace("\"?><", ICommonConstants.CONSTANT_XML_SEQ2A).replace("--><", ICommonConstants.CONSTANT_XML_SEQ2B);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static final String getLanguageLaunch(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/_launch/Language.%s.xml.launch", type).getTemplate(tokens);
    }

    public static final String getMetadata(List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/sysdefs/Metadata.xml").getTemplate(tokens);
    }

    public static final String getMetadataLaunch(List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/_launch/Metadata.xml.launch").getTemplate(tokens);
    }

    public static final String getMetadataResolve(List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/sysdefs/MetadataResolve.xml").getTemplate(tokens);
    }

    public static final String getMetadataResolveLaunch(List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/_launch/MetadataResolve.xml.launch").getTemplate(tokens);
    }

    public static final String getProjectProperties(List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/_config/project.properties").getTemplate(tokens);
    }

    public static final String getResource(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/sysdefs/Resource.%s.xml", type).getTemplate(tokens);
    }

    public static final String getResourceLaunch(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/_launch/Resource.%s.xml.launch", type).getTemplate(tokens);
    }

    public static final String getTranslator(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/sysdefs/Translator.%s.xml", type).getTemplate(tokens);
    }

    public static final String getTranslatorLaunch(String type, List<IImporterToken> tokens) {
        return PackagingTemplateFactory.getTemplate("templates/%s/_launch/Translator.%s.xml.launch", type).getTemplate(tokens);
    }

    private static String getPath(String template) {
        return String.format(template, Path);
    }

    private static ImporterTemplate getTemplate(String template) {
        return new ImporterTemplate(PackagingTemplateFactory.getPath(template));
    }

    private static ImporterTemplate getTemplate(String template, String type) {
        return new ImporterTemplate(String.format(PackagingTemplateFactory.getPath(template), type));
    }
}

