/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebugUtility;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.internal.client.Password;
import com.ibm.team.enterprise.common.common.ZPackagingNature;
import com.ibm.team.enterprise.internal.common.common.PasswordHelper;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterEngine;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterMetadata;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterProperties;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingLanguage;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingStepAsm;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingStepIrx;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingStepLnk;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingStepSld;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingTemplateFactory;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingUtilities;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterEngine;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterMetadata;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterPropertyKey;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepAsm;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepIrx;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepLnk;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepSld;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterException;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterFactoryException;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterPropertyKey;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

@DebugGroup(value={"zPackaging"})
@DebugUtility(value=true)
public class PackagingFactory {
    private static String cls = PackagingFactory.class.getSimpleName();
    private static IDebugger dbg = new Debugger(PackagingFactory.class);

    private PackagingFactory() {
    }

    public static void createEngine(IProject project, IImporterEngine engine, IProgressMonitor monitor) throws ImporterFactoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!project.exists()) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zPackaging_PROJECT_NAME_NONEXISTS, (Object)project.getName()));
        }
        if (engine == null) {
            throw new ImporterFactoryException(Messages.zPackaging_ENGINE_REQ_PARAMETER);
        }
        try {
            IFolder resource = null;
            IFile file = null;
            resource = project.getFolder("engines");
            if (!resource.exists()) {
                resource.create(true, true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Engine.%s.xml", engine.getProperties().getId(), engine.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getEngine(engine.getType().getName(), engine.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Engine.%s.xml.launch", engine.getProperties().getId(), engine.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getEngineLaunch(engine.getType().getName(), engine.createTokenList()).getBytes()), true, monitor);
            }
        }
        catch (Exception e) {
            throw new ImporterFactoryException((Throwable)e);
        }
    }

    public static void createLanguageFiles(IProject project, IImporterLanguage language, IProgressMonitor monitor) throws ImporterFactoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!project.exists()) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zPackaging_PROJECT_NAME_NONEXISTS, (Object)project.getName()));
        }
        if (language == null) {
            throw new ImporterFactoryException(Messages.zPackaging_LANGUAGE_REQUIRED);
        }
        try {
            IFolder properties = null;
            IFolder launches = null;
            IFolder resource = null;
            IFile file = null;
            launches = project.getFolder(".launch");
            if (!launches.exists()) {
                launches.create(true, true, monitor);
            }
            if (!(resource = project.getFolder("sysdefs")).exists()) {
                resource.create(true, true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Build.%s.xml", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getBuild(language.getType().getName(), language.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = launches.getFile(String.format("%s.Build.%s.xml.launch", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getBuildLaunch(language.getType().getName(), language.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Language.%s.xml", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getLanguage(language.getType().getName(), language.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = launches.getFile(String.format("%s.Language.%s.xml.launch", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getLanguageLaunch(language.getType().getName(), language.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Resource.%s.xml", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getResource(language.getType().getName(), language.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = launches.getFile(String.format("%s.Resource.%s.xml.launch", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getResourceLaunch(language.getType().getName(), language.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Translator.%s.xml", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getTranslator(language.getType().getName(), language.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = launches.getFile(String.format("%s.Translator.%s.xml.launch", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getTranslatorLaunch(language.getType().getName(), language.createTokenList()).getBytes()), true, monitor);
            }
            if (!(properties = project.getFolder(".config")).exists()) {
                properties.create(true, true, monitor);
            }
            if (!(file = properties.getFile(String.format("%s.Export.Language.%s.xml", language.getProperties().getId(), language.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getLanguageDocument(language).getBytes()), true, monitor);
            }
        }
        catch (Exception e) {
            throw new ImporterFactoryException((Throwable)e);
        }
    }

    public static void createMetadata(IProject project, IImporterMetadata metadata, IProgressMonitor monitor) throws ImporterFactoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!project.exists()) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zPackaging_PROJECT_NAME_NONEXISTS, (Object)project.getName()));
        }
        if (metadata == null) {
            throw new ImporterFactoryException(Messages.zPackaging_METADATA_REQUIRED_PARAMETER);
        }
        try {
            IFolder resource = null;
            IFile file = null;
            resource = project.getFolder("sysdefs");
            if (!resource.exists()) {
                resource.create(true, true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Metadata.xml", metadata.getProperties().getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getMetadata(metadata.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Metadata.xml.launch", metadata.getProperties().getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getMetadataLaunch(metadata.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.MetadataResolve.xml", metadata.getProperties().getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getMetadataResolve(metadata.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.MetadataResolve.xml.launch", metadata.getProperties().getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getMetadataResolveLaunch(metadata.createTokenList()).getBytes()), true, monitor);
            }
        }
        catch (Exception e) {
            throw new ImporterFactoryException((Throwable)e);
        }
    }

    public static IImporterDataset createDataset() {
        return new ImporterDataset();
    }

    public static IImporterEngine createEngine() {
        return new ImporterEngine();
    }

    public static IImporterProperties createProperties() {
        return new ImporterProperties();
    }

    public static IImporterProperties createProperties(Properties properties) {
        return new ImporterProperties(properties);
    }

    public static IImporterPropertyKey createPropertyKey(String suffix) {
        return new ImporterPropertyKey(suffix);
    }

    public static IImporterLanguage createLanguage() {
        return new PackagingLanguage();
    }

    public static IImporterMetadata createMetadata() {
        return new ImporterMetadata();
    }

    public static IImporterStepAsm createStepAsm() {
        return PackagingFactory.createStepAsm(false);
    }

    public static IImporterStepAsm createStepAsm(boolean defaultsBuiltin) {
        PackagingStepAsm result = new PackagingStepAsm();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterStepIrx createStepIrx() {
        return PackagingFactory.createStepIrx(false);
    }

    public static IImporterStepIrx createStepIrx(boolean defaultsBuiltin) {
        PackagingStepIrx result = new PackagingStepIrx();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterStepLnk createStepLnk() {
        return PackagingFactory.createStepLnk(false);
    }

    public static IImporterStepLnk createStepLnk(boolean defaultsBuiltin) {
        PackagingStepLnk result = new PackagingStepLnk();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterStepSld createStepSld() {
        return PackagingFactory.createStepSld(false);
    }

    public static IImporterStepSld createStepSld(boolean defaultsBuiltin) {
        PackagingStepSld result = new PackagingStepSld();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterToken createToken() {
        return new ImporterToken();
    }

    public static IProject createProject(String projectName, List<String> natures, IImporterProperties properties, IProgressMonitor progressMonitor) throws ImporterFactoryException {
        Mnm mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
        if (natures == null) {
            natures = new ArrayList<String>();
        }
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        try {
            PackagingUtilities.validateProjectName(projectName);
        }
        catch (ImporterException e) {
            throw new ImporterFactoryException((Throwable)e);
        }
        if (properties == null) {
            throw new ImporterFactoryException(Messages.zPackaging_PROJECT_REQ_PROPERTIES);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        natures.add(ZPackagingNature.ID);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zPackaging_PROJECT_NAME_NONUNIQUE, (Object)projectName));
        }
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        description.setName(projectName);
        description.setNatureIds(natures.toArray(new String[natures.size()]));
        try {
            project.create(description, progressMonitor);
            project.open(progressMonitor);
            IFolder resource = null;
            IFile file = null;
            resource = project.getFolder(".config");
            if (!resource.exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(file = resource.getFile(".properties")).exists()) {
                file.create((InputStream)new ByteArrayInputStream(PackagingTemplateFactory.getProjectProperties(properties.createTokenList()).getBytes()), true, progressMonitor);
            }
            if (!(file = resource.getFile(".password")).exists()) {
                try {
                    PasswordHelper.createPasswordFile((File)file.getRawLocation().toFile(), (String)new Password().getDecryptedPassword(properties.getPassword()));
                }
                catch (Exception e) {
                    throw new ImporterFactoryException(NLS.bind((String)Messages.zBuilder_PROJECT_PWD_EXCEPTION, (Object)projectName, (Object)e.getMessage()), (Throwable)e);
                }
            }
            if (!(resource = project.getFolder(".launch")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("builds")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("engines")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("imports")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("scripts")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("sysdefs")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("utilities")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            project.refreshLocal(2, progressMonitor);
        }
        catch (Exception e) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zBuilder_PROJECT_UNK_EXCEPTION, (Object)projectName, (Object)e.getMessage()), (Throwable)e);
        }
        mnm.leave(new String[0]);
        return project;
    }
}

