/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.importer;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebugUtility;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.parser.ParseResult;
import com.ibm.team.enterprise.common.common.parser.Parser;
import com.ibm.team.enterprise.common.common.parser.ParserRejected;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDataDef;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDataSet;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderFactory;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;

@DebugGroup(value={"zBuilder,zPackaging"})
@DebugUtility(value=true)
public class ImporterFactory {
    private static String cls = BuilderFactory.class.getSimpleName();
    private static IDebugger dbg = new Debugger(BuilderFactory.class);
    private static final String ClassifierDsn = "dsn";
    private static final String ClassifierMbr = "mbr";
    private static final String ClassifierOpt = "opt";
    private static final String PatternDsn = "[^\\(]+";

    private ImporterFactory() {
    }

    public static IImporterDataset createDataset(IJclResultDataDef datadef, IJclResultDataSet dataset, String zPrefix) {
        Mnm mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
        String dsn = dataset.getParameters().getOrDefault("DSN", "");
        String dsName = "";
        String dsMember = "";
        String dsPrefix = "";
        boolean zDataset = false;
        boolean mbrFound = false;
        if (!dsn.equals("")) {
            Parser parser = Parser.sequence((Parser[])new Parser[]{Parser.token((String)PatternDsn).classifier(ClassifierDsn), Parser.optional((Parser)Parser.sequence((Parser[])new Parser[]{Parser.token((String)"\\("), Parser.token().classifier(ClassifierMbr), Parser.token((String)"\\)")}).classifier(ClassifierOpt))});
            ParseResult parseResult = null;
            try {
                parseResult = (ParseResult)parser.parse(dsn);
            }
            catch (ParserRejected e) {
                e.printStackTrace();
            }
            dsName = (String)parseResult.get(ClassifierDsn);
            if (parseResult.get(ClassifierOpt) != null) {
                dsMember = (String)((ParseResult)parseResult.get(ClassifierOpt)).get(ClassifierMbr);
                boolean bl = mbrFound = dsMember.length() > 0;
            }
        }
        if (zPrefix != null && dsName.startsWith(zPrefix)) {
            dsName = dsName.substring(zPrefix.length() + 1);
            dsMember = "";
            dsPrefix = zPrefix;
            zDataset = true;
        }
        IDataSetDefinition dsdef = (IDataSetDefinition)IDataSetDefinition.ITEM_TYPE.createItem();
        dsdef.setProjectArea(null);
        dsdef.setNonImpacting(true);
        dsdef.setName(datadef.getName());
        dsdef.setDescription(datadef.getComments());
        dsdef.setDsName(dsName);
        dsdef.setDsMember(dsMember);
        dsdef.setPrefixDSN(zDataset);
        if (dsName.startsWith("&&")) {
            dsdef.setUsageType(2);
        } else if (!zDataset) {
            dsdef.setUsageType(3);
        } else {
            dsdef.setUsageType(1);
        }
        dsdef.setDataClass(dataset.getParameters().getOrDefault("DATACLAS", ""));
        dsdef.setStorageClass(dataset.getParameters().getOrDefault("STORCLAS", ""));
        dsdef.setManagementClass(dataset.getParameters().getOrDefault("MGMTCLAS", ""));
        if (dataset.hasUnitParameters()) {
            dsdef.setGenericUnit((String)dataset.getUnitParameter().get(0));
        } else {
            dsdef.setGenericUnit(dataset.getParameters().getOrDefault("UNIT", ""));
        }
        if (dataset.hasVolParameters() || dataset.hasVolumeParameters()) {
            dsdef.setVolumeSerial(dataset.getVolParameter().getVolume());
        } else {
            dsdef.setVolumeSerial("");
        }
        if (dataset.hasSpaceParameters()) {
            dsdef.setSpaceUnits(IDataSetDefinition.convertJclSpaceUnit((String)dataset.getSpaceParameter().getUnits()));
            dsdef.setPrimaryQuantity(dataset.getSpaceParameter().getPrimary());
            dsdef.setSecondaryQuantity(dataset.getSpaceParameter().getSecondary());
            dsdef.setDirectoryBlocks(dataset.getSpaceParameter().getDirectory());
        } else {
            dsdef.setSpaceUnits("");
            dsdef.setPrimaryQuantity("");
            dsdef.setSecondaryQuantity("");
            dsdef.setDirectoryBlocks("");
        }
        if (dataset.hasDcbParameters()) {
            dsdef.setBlockSize(dataset.getDcbParameter().getOrDefault("BLKSIZE", ""));
            dsdef.setRecordLength(dataset.getDcbParameter().getOrDefault("LRECL", ""));
            dsdef.setRecordFormat(dataset.getDcbParameter().getOrDefault("RECFM", ""));
        } else {
            dsdef.setBlockSize(dataset.getParameters().getOrDefault("BLKSIZE", ""));
            dsdef.setRecordLength(dataset.getParameters().getOrDefault("LRECL", ""));
            dsdef.setRecordFormat(dataset.getParameters().getOrDefault("RECFM", ""));
        }
        if (mbrFound) {
            dsdef.setDsType(0);
        } else {
            dsdef.setDsType(1);
        }
        ImporterDataset iDataset = new ImporterDataset();
        iDataset.setDsn(dsn);
        iDataset.setDataset(dsName);
        iDataset.setMember(dsMember);
        iDataset.setPrefix(dsPrefix);
        iDataset.setzDataset(zDataset);
        iDataset.setDsdef(dsdef);
        mnm.leave(new String[0]);
        return iDataset;
    }
}

