/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.importer;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterLibrary;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterOption;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterParameter;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterProperties;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterResource;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterTranslator;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterAllocationSize;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLibrary;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterOption;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParameter;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterResource;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.repository.common.util.NLS;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ImportLanguageSaxHandler
extends DefaultHandler {
    private final IDebugger dbg;
    private final String cls;
    private final Class<?> languageClass;
    private boolean openOption = false;
    private boolean openLibraries = false;
    private boolean openParameter = false;
    private boolean openResource = false;
    private boolean openPropertyPassword = false;
    private boolean openPropertyPasswordFile = false;
    private boolean openPropertyProjectArea = false;
    private boolean openPropertyRepositoryAddress = false;
    private boolean openPropertyUserId = false;
    private boolean openPropertyDescription = false;
    private boolean openPropertyId = false;
    private boolean openPropertyName = false;
    private IImporterLanguage languageImport;
    private IImporterOption languageOption;
    private IImporterLibrary languageLibrary;
    private IImporterParameter languageParameter;
    private IImporterResource languageResource;
    private IImporterTranslator languageTranslator;
    private final List<IImporterLanguage> imports;

    public ImportLanguageSaxHandler(List<IImporterLanguage> imports, Class<?> languageClass, IDebugger dbg) {
        this.languageClass = languageClass;
        this.dbg = dbg;
        this.cls = this.getClass().getSimpleName();
        this.imports = imports;
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.cls});
        }
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.dbg.isDebug()) {
            Debug.start((IDebugger)this.dbg, (String[])new String[]{this.cls, new MethodName(){}.getName()});
        }
        if (qName.equals("language")) {
            try {
                this.languageImport = (IImporterLanguage)this.languageClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new SAXException(Messages.ImportLanguage_LANGUAGE_EXCEPTION, e);
            }
            catch (InstantiationException e) {
                throw new SAXException(Messages.ImportLanguage_LANGUAGE_EXCEPTION, e);
            }
            this.languageImport.setDescription(attributes.getValue("description"));
            this.languageImport.setFolderAdditional(attributes.getValue("folderAdditional"));
            this.languageImport.setFolderPrimary(attributes.getValue("folderPrimary"));
            this.languageImport.setId(attributes.getValue("id"));
            this.languageImport.setName(attributes.getValue("name"));
            this.languageImport.setPatternAdditional(attributes.getValue("patternAdditional"));
            this.languageImport.setPatternPrimary(attributes.getValue("patternPrimary"));
            this.languageImport.setPrefix(attributes.getValue("prefix"));
            this.languageImport.setSize(IImporterAllocationSize.AllocationSize.get((String)attributes.getValue("size")));
            this.languageImport.setType(attributes.getValue("type"));
            this.languageImport.setZFolderName(attributes.getValue("zFolderName"));
            this.imports.add(this.languageImport);
        } else if (qName.equals("project")) {
            if (!Verification.isNonNull((Object)this.languageImport)) {
                throw new SAXException(NLS.bind((String)Messages.ImportLanguage_LANGUAGE_MISSING_ELEMENT, (Object)"language", (Object[])new Object[0]));
            }
            this.languageImport.setProjectName(attributes.getValue("name"));
            this.languageImport.setProperties((IImporterProperties)new ImporterProperties());
        } else if (qName.equals("property")) {
            if (!Verification.isNonNull((Object)this.languageImport)) {
                throw new SAXException(NLS.bind((String)Messages.ImportLanguage_LANGUAGE_MISSING_ELEMENT, (Object)"language", (Object[])new Object[0]));
            }
            if (!Verification.isNonNull((Object)this.languageImport.getProperties())) {
                throw new SAXException(NLS.bind((String)Messages.ImportLanguage_LANGUAGE_MISSING_ELEMENT, (Object)"property", (Object[])new Object[0]));
            }
            if ("description".equals(attributes.getValue("name"))) {
                this.openPropertyDescription = true;
            }
            if ("id".equals(attributes.getValue("name"))) {
                this.openPropertyId = true;
            }
            if ("name".equals(attributes.getValue("name"))) {
                this.openPropertyName = true;
            }
            if ("password".equals(attributes.getValue("name"))) {
                this.openPropertyPassword = true;
            }
            if ("passwordFile".equals(attributes.getValue("name"))) {
                this.openPropertyPasswordFile = true;
            }
            if ("projectArea".equals(attributes.getValue("name"))) {
                this.openPropertyProjectArea = true;
            }
            if ("repositoryAddress".equals(attributes.getValue("name"))) {
                this.openPropertyRepositoryAddress = true;
            }
            if ("userId".equals(attributes.getValue("name"))) {
                this.openPropertyUserId = true;
            }
        } else if (qName.equals("translator")) {
            if (!Verification.isNonNull((Object)this.languageImport)) {
                throw new SAXException(NLS.bind((String)Messages.ImportLanguage_LANGUAGE_MISSING_ELEMENT, (Object)"language", (Object[])new Object[0]));
            }
            this.languageTranslator = new ImporterTranslator();
            this.languageTranslator.setName(attributes.getValue("name"));
            this.languageImport.getTranslators().add(this.languageTranslator);
        } else if (qName.equals("option")) {
            if (!Verification.isNonNull((Object)this.languageTranslator)) {
                throw new SAXException(NLS.bind((String)Messages.ImportLanguage_LANGUAGE_MISSING_ELEMENT, (Object)"translator", (Object[])new Object[0]));
            }
            this.openOption = true;
            this.languageOption = new ImporterOption();
            this.languageOption.setEnabled(Boolean.parseBoolean(attributes.getValue("enabled")));
            this.languageOption.setState(Boolean.parseBoolean(attributes.getValue("state")));
            this.languageTranslator.getOptions().add(this.languageOption);
        } else if (qName.equals("parameter")) {
            if (!Verification.isNonNull((Object)this.languageTranslator)) {
                throw new SAXException(NLS.bind((String)Messages.ImportLanguage_LANGUAGE_MISSING_ELEMENT, (Object)"translator", (Object[])new Object[0]));
            }
            this.openParameter = true;
            this.languageParameter = new ImporterParameter();
            this.languageParameter.setName(attributes.getValue("name"));
            this.languageTranslator.getParameters().add(this.languageParameter);
        } else if (qName.equals("resource")) {
            if (!Verification.isNonNull((Object)this.languageTranslator)) {
                throw new SAXException(NLS.bind((String)Messages.ImportLanguage_LANGUAGE_MISSING_ELEMENT, (Object)"translator", (Object[])new Object[0]));
            }
            this.openResource = true;
            this.languageResource = new ImporterResource();
            this.languageResource.setName(attributes.getValue("name"));
            this.languageResource.setzFolder(Boolean.parseBoolean(attributes.getValue("zFolder")));
            if (this.openLibraries) {
                this.languageLibrary.getResources().add(this.languageResource);
            } else {
                this.languageTranslator.getResources().add(this.languageResource);
            }
        } else if (qName.equals("libraries")) {
            if (!Verification.isNonNull((Object)this.languageTranslator)) {
                throw new SAXException(NLS.bind((String)Messages.ImportLanguage_LANGUAGE_MISSING_ELEMENT, (Object)"translator", (Object[])new Object[0]));
            }
            this.openLibraries = true;
            this.languageLibrary = new ImporterLibrary();
            this.languageLibrary.setName(attributes.getValue("name"));
            this.languageTranslator.getLibraries().add(this.languageLibrary);
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.cls, new MethodName(){}.getName()});
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.dbg.isDebug()) {
            Debug.start((IDebugger)this.dbg, (String[])new String[]{this.cls, new MethodName(){}.getName()});
        }
        if (qName.equals("translator")) {
            this.languageTranslator = null;
        } else if (qName.equals("option")) {
            this.openOption = false;
            this.languageOption = null;
        } else if (qName.equals("parameter")) {
            this.openParameter = false;
            this.languageParameter = null;
        } else if (qName.equals("resource")) {
            this.openResource = false;
            this.languageResource = null;
        } else if (qName.equals("libraries")) {
            this.openLibraries = false;
            this.languageLibrary = null;
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.cls, new MethodName(){}.getName()});
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.dbg.isDebug()) {
            Debug.start((IDebugger)this.dbg, (String[])new String[]{this.cls, new MethodName(){}.getName()});
        }
        if (this.openOption) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageOption.setName(sb.toString());
        } else if (this.openParameter) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageParameter.setValue(sb.toString());
        } else if (this.openResource) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageResource.setValue(sb.toString());
        } else if (this.openPropertyDescription) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageImport.getProperties().setDescription(sb.toString());
            this.openPropertyDescription = false;
        } else if (this.openPropertyId) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageImport.getProperties().setId(sb.toString());
            this.openPropertyId = false;
        } else if (this.openPropertyName) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageImport.getProperties().setName(sb.toString());
            this.openPropertyName = false;
        } else if (this.openPropertyPassword) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageImport.getProperties().setPasswordString(sb.toString());
            this.openPropertyPassword = false;
        } else if (this.openPropertyPasswordFile) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageImport.getProperties().setPasswordFile(sb.toString());
            this.openPropertyPasswordFile = false;
        } else if (this.openPropertyProjectArea) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageImport.getProperties().setProjectArea(sb.toString());
            this.openPropertyProjectArea = false;
        } else if (this.openPropertyRepositoryAddress) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageImport.getProperties().setRepositoryAddress(sb.toString());
            this.openPropertyRepositoryAddress = false;
        } else if (this.openPropertyUserId) {
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                sb.append(ch[i]);
                ++i;
            }
            this.languageImport.getProperties().setUserId(sb.toString());
            this.openPropertyUserId = false;
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.cls, new MethodName(){}.getName()});
        }
    }
}

