/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.importer;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.enterprise.systemdefinition.client.importer.ImportLanguageSaxHandler;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImportLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@DebugGroup(value={"zBuilder,zPackaging"})
public class ImportLanguage
implements IImportLanguage {
    private final IDebugger dbg;
    private final String cls;
    private final Class<?> languageClass;
    private final List<IImporterLanguage> imports = new ArrayList<IImporterLanguage>();

    public ImportLanguage(Class<?> languageClass) {
        this.languageClass = languageClass;
        this.dbg = new Debugger(this.getClass());
        this.cls = this.getClass().getSimpleName();
        if (this.dbg.isFlow()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.cls});
        }
    }

    public final void parseFile(File xml) throws ImporterException {
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.cls, new MethodName(){}.getName()});
        }
        if (!xml.exists()) {
            throw new ImporterException(NLS.bind((String)Common.COMMON_EXCEPTION_FILE_NOT_FOUND, (Object)xml.toString(), (Object[])new Object[0]));
        }
        if (!xml.canRead()) {
            throw new ImporterException(NLS.bind((String)Common.COMMON_EXCEPTION_FILE_NO_READ, (Object)xml.toString(), (Object[])new Object[0]));
        }
        InputStream xsd = this.getClass().getClassLoader().getResourceAsStream("schema/Importer.language.xsd");
        if (xsd == null) {
            throw new ImporterException(NLS.bind((String)Common.COMMON_EXCEPTION_FILE_NOT_FOUND, (Object)"schema/Importer.language.xsd", (Object[])new Object[0]));
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            StreamSource schemaSource = new StreamSource(xsd);
            schema = schemaFactory.newSchema(schemaSource);
        }
        catch (SAXException e) {
            throw new ImporterException(NLS.bind((String)Common.COMMON_EXCEPTION_SAX_SCHEMA, (Object)"schema/Importer.language.xsd", (Object[])new Object[0]), (Throwable)e);
        }
        try {
            SAXParserFactory saxParserFactory = XMLUtil.getSecureSAXParserFactory();
            saxParserFactory.setSchema(schema);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            ImportLanguageSaxHandler saxHandler = new ImportLanguageSaxHandler(this.imports, this.languageClass, this.dbg);
            saxParser.parse(xml, (DefaultHandler)saxHandler);
        }
        catch (Exception e) {
            throw new ImporterException(NLS.bind((String)Common.COMMON_EXCEPTION_SAX_PARSE, (Object)xml.toString(), (Object[])new Object[0]), (Throwable)e);
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.cls, new MethodName(){}.getName()});
        }
    }

    public final List<IImporterLanguage> getImports() {
        return this.imports;
    }
}

