/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoad;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoadExecute;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheItemTranslatorHandle;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ItemCacheLoadTranslatorHandle
implements ICacheLoad,
ICacheLoadExecute<ISystemDefinitionHandle>,
Callable<ICacheLoad> {
    private final ItemCacheItemTranslatorHandle itemCacheItem;
    private final ITeamRepository repository;
    private final IProjectAreaHandle projectArea;
    private final ISystemDefinition.Platform platform;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<ISystemDefinitionHandle> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public ItemCacheLoadTranslatorHandle(ITeamRepository repository, IProjectAreaHandle projectArea, ISystemDefinition.Platform platform, ItemCacheItemTranslatorHandle itemCacheItem, IDebugger dbg) {
        this.repository = repository;
        this.projectArea = projectArea;
        this.platform = platform;
        this.itemCacheItem = itemCacheItem;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    @Override
    public List<ISystemDefinitionHandle> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public ICacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        ISystemDefinitionModelClient systemDefinitionClient = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
        List<Object> itemList = this.itemCacheItem.hasItemMapByName() ? new ArrayList<ISystemDefinition>(systemDefinitionClient.findSystemDefinitions(ITranslator.ITEM_TYPE, this.projectArea, -1, false, Arrays.asList(ISystemDefinition.SMALL_PROFILE), this.monitor)) : systemDefinitionClient.findSystemDefinitionHandles(ITranslator.ITEM_TYPE, this.projectArea, -1, false, this.monitor);
        HashMap<String, ISystemDefinitionHandle> itemMapByName = new HashMap<String, ISystemDefinitionHandle>();
        HashMap<String, ISystemDefinitionHandle> itemMapByUuid = new HashMap<String, ISystemDefinitionHandle>();
        for (ISystemDefinitionHandle item : itemList) {
            if (this.itemCacheItem.hasItemMapByName()) {
                String itemName = ((ISystemDefinition)item).getName().trim();
                itemMapByName.put(itemName, item);
            }
            if (!this.itemCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        this.itemCacheItem.setRepository(this.repository);
        this.itemCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
        this.itemCacheItem.setProcessArea((IProcessAreaHandle)this.projectArea);
        this.itemCacheItem.setProcessAreaId(this.projectArea.getItemId().getUuidValue());
        this.itemCacheItem.setItemHandle(null);
        this.itemCacheItem.setItemHandleId(null);
        this.itemCacheItem.setComplete();
        if (!this.append) {
            this.itemCacheItem.clear();
            this.itemCacheItem.clearPlatformEntry();
            this.itemCacheItem.setUsage(this.usage);
            this.itemCacheItem.setPlatformEntry(this.platform, (Integer)this.usage, (List<ISystemDefinitionHandle>)itemList);
            if (this.itemCacheItem.hasItemList()) {
                this.itemCacheItem.setItemList((List<ISystemDefinitionHandle>)itemList);
            }
            if (this.itemCacheItem.hasItemMapByName()) {
                this.itemCacheItem.setItemMapByName((Map<String, ISystemDefinitionHandle>)itemMapByName);
            }
            if (this.itemCacheItem.hasItemMapByUuid()) {
                this.itemCacheItem.setItemMapByUuid((Map<String, ISystemDefinitionHandle>)itemMapByUuid);
            }
        } else {
            this.itemCacheItem.addUsage(this.usage);
            this.itemCacheItem.setPlatformEntry(this.platform, (Integer)this.usage, (List<ISystemDefinitionHandle>)itemList);
            if (this.itemCacheItem.hasItemList()) {
                this.itemCacheItem.addAllItemList((List<ISystemDefinitionHandle>)itemList);
            }
            if (this.itemCacheItem.hasItemMapByName()) {
                this.itemCacheItem.addAllItemMapByName((Map<String, ISystemDefinitionHandle>)itemMapByName);
            }
            if (this.itemCacheItem.hasItemMapByUuid()) {
                this.itemCacheItem.addAllItemMapByUuid((Map<String, ISystemDefinitionHandle>)itemMapByUuid);
            }
        }
        if (this.returnItemList) {
            this.itemList = itemList;
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    @Override
    public final void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

