/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoad;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoadExecute;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheItemTranslator;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ItemCacheLoadTranslator
implements ICacheLoad,
ICacheLoadExecute<ITranslator>,
Callable<ICacheLoad> {
    private final ItemCacheItemTranslator itemCacheItem;
    private final ITeamRepository repository;
    private final IProjectAreaHandle projectArea;
    private final ISystemDefinition.Platform platform;
    private final ITranslator definition;
    private final List<ITranslator> definitionList;
    private final ISystemDefinitionHandle definitionHandle;
    private final List<ISystemDefinitionHandle> definitionHandleList;
    private final String definitionUuid;
    private final List<String> definitionUuidList;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<ITranslator> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public ItemCacheLoadTranslator(ITeamRepository repository, IProjectAreaHandle projectArea, ISystemDefinition.Platform platform, ItemCacheItemTranslator itemCacheItem, ITranslator definition, List<ITranslator> definitionList, ISystemDefinitionHandle definitionHandle, List<ISystemDefinitionHandle> definitionHandleList, String definitionUuid, List<String> definitionUuidList, IDebugger dbg) {
        this.repository = repository;
        this.projectArea = projectArea;
        this.platform = platform;
        this.itemCacheItem = itemCacheItem;
        this.definition = definition;
        this.definitionList = definitionList;
        this.definitionHandle = definitionHandle;
        this.definitionHandleList = definitionHandleList;
        this.definitionUuid = definitionUuid;
        this.definitionUuidList = definitionUuidList;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    @Override
    public List<ITranslator> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public ICacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.definition != null || this.definitionList != null || this.definitionHandle != null || this.definitionHandleList != null || this.definitionUuid != null || this.definitionUuidList != null) {
            ISystemDefinitionModelClient systemDefinitionClient = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
            ArrayList<ITranslator> itemList = new ArrayList<ITranslator>();
            if (this.definition != null) {
                itemList.add(this.definition);
            }
            if (this.definitionList != null) {
                itemList.addAll(this.definitionList);
            }
            if (this.definitionHandle != null) {
                itemList.add((ITranslator)systemDefinitionClient.fetchSystemDefinitionComplete(this.definitionHandle, false, this.monitor));
            }
            if (this.definitionHandleList != null) {
                itemList.addAll(systemDefinitionClient.fetchSystemDefinitionsComplete(this.definitionHandleList, false, this.monitor));
            }
            if (this.definitionUuid != null) {
                itemList.add((ITranslator)systemDefinitionClient.fetchSystemDefinitionComplete((ISystemDefinitionHandle)ITranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.definitionUuid), null), false, this.monitor));
            }
            if (this.definitionUuidList != null) {
                ArrayList<ISystemDefinitionHandle> systemDefinitionHandles = new ArrayList<ISystemDefinitionHandle>();
                for (String uuid : this.definitionUuidList) {
                    systemDefinitionHandles.add((ISystemDefinitionHandle)ITranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
                }
                itemList.addAll(systemDefinitionClient.fetchSystemDefinitionsComplete(systemDefinitionHandles, false, this.monitor));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, ITranslator> itemMapByName = new HashMap<String, ITranslator>();
            HashMap<String, ITranslator> itemMapByUuid = new HashMap<String, ITranslator>();
            for (ITranslator iTranslator : itemList) {
                if (this.itemCacheItem.hasItemMapByName()) {
                    String itemName = iTranslator.getName().trim();
                    itemMapByName.put(itemName, iTranslator);
                }
                if (!this.itemCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = iTranslator.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, iTranslator);
            }
            this.itemCacheItem.setRepository(this.repository);
            this.itemCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.itemCacheItem.setProcessArea((IProcessAreaHandle)this.projectArea);
            this.itemCacheItem.setProcessAreaId(this.projectArea.getItemId().getUuidValue());
            this.itemCacheItem.setItemHandle(null);
            this.itemCacheItem.setItemHandleId(null);
            this.itemCacheItem.setPartial();
            if (this.itemCacheItem.hasItemList()) {
                this.itemCacheItem.addAllItemList((List<ITranslator>)itemList);
            }
            if (this.itemCacheItem.hasItemMapByName()) {
                this.itemCacheItem.addAllItemMapByName((Map<String, ITranslator>)itemMapByName);
            }
            if (this.itemCacheItem.hasItemMapByUuid()) {
                this.itemCacheItem.addAllItemMapByUuid((Map<String, ITranslator>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            ISystemDefinitionModelClient systemDefinitionClient = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
            List<Object> itemList = null;
            itemList = this.platform == null ? systemDefinitionClient.findSystemDefinitionsComplete(ITranslator.ITEM_TYPE, this.projectArea, -1, false, this.monitor) : (this.platform.equals((Object)ISystemDefinition.Platform.zos) ? systemDefinitionClient.findSystemDefinitionsComplete(ITranslator.ITEM_TYPE, this.projectArea, -1, false, this.monitor) : new ArrayList());
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, ITranslator> itemMapByName = new HashMap<String, ITranslator>();
            HashMap<String, ITranslator> itemMapByUuid = new HashMap<String, ITranslator>();
            for (ITranslator iTranslator : itemList) {
                if (this.itemCacheItem.hasItemMapByName()) {
                    String itemName = iTranslator.getName().trim();
                    itemMapByName.put(itemName, iTranslator);
                }
                if (!this.itemCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = iTranslator.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, iTranslator);
            }
            this.itemCacheItem.setRepository(this.repository);
            this.itemCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.itemCacheItem.setProcessArea((IProcessAreaHandle)this.projectArea);
            this.itemCacheItem.setProcessAreaId(this.projectArea.getItemId().getUuidValue());
            this.itemCacheItem.setItemHandle(null);
            this.itemCacheItem.setItemHandleId(null);
            this.itemCacheItem.setComplete();
            if (!this.append) {
                this.itemCacheItem.clear();
                this.itemCacheItem.clearPlatformEntry();
                this.itemCacheItem.setUsage(this.usage);
                this.itemCacheItem.setPlatformEntry(this.platform, (Integer)this.usage, (List<ITranslator>)itemList);
                if (this.itemCacheItem.hasItemList()) {
                    this.itemCacheItem.setItemList((List<ITranslator>)itemList);
                }
                if (this.itemCacheItem.hasItemMapByName()) {
                    this.itemCacheItem.setItemMapByName((Map<String, ITranslator>)itemMapByName);
                }
                if (this.itemCacheItem.hasItemMapByUuid()) {
                    this.itemCacheItem.setItemMapByUuid((Map<String, ITranslator>)itemMapByUuid);
                }
            } else {
                this.itemCacheItem.addUsage(this.usage);
                this.itemCacheItem.setPlatformEntry(this.platform, (Integer)this.usage, (List<ITranslator>)itemList);
                if (this.itemCacheItem.hasItemList()) {
                    this.itemCacheItem.addAllItemList((List<ITranslator>)itemList);
                }
                if (this.itemCacheItem.hasItemMapByName()) {
                    this.itemCacheItem.addAllItemMapByName((Map<String, ITranslator>)itemMapByName);
                }
                if (this.itemCacheItem.hasItemMapByUuid()) {
                    this.itemCacheItem.addAllItemMapByUuid((Map<String, ITranslator>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    @Override
    public final void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

