/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoad;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoadExecute;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheItemDataset;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ItemCacheLoadDataset
implements ICacheLoad,
ICacheLoadExecute<IResourceDefinition>,
Callable<ICacheLoad> {
    private final ItemCacheItemDataset itemCacheItem;
    private final ITeamRepository repository;
    private final IProjectAreaHandle projectArea;
    private final ISystemDefinition.Platform platform;
    private final IResourceDefinition definition;
    private final List<IResourceDefinition> definitionList;
    private final ISystemDefinitionHandle definitionHandle;
    private final List<ISystemDefinitionHandle> definitionHandleList;
    private final String definitionUuid;
    private final List<String> definitionUuidList;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IResourceDefinition> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public ItemCacheLoadDataset(ITeamRepository repository, IProjectAreaHandle projectArea, ISystemDefinition.Platform platform, ItemCacheItemDataset itemCacheItem, IResourceDefinition definition, List<IResourceDefinition> definitionList, ISystemDefinitionHandle definitionHandle, List<ISystemDefinitionHandle> definitionHandleList, String definitionUuid, List<String> definitionUuidList, IDebugger dbg) {
        this.repository = repository;
        this.projectArea = projectArea;
        this.platform = platform;
        this.itemCacheItem = itemCacheItem;
        this.definition = definition;
        this.definitionList = definitionList;
        this.definitionHandle = definitionHandle;
        this.definitionHandleList = definitionHandleList;
        this.definitionUuid = definitionUuid;
        this.definitionUuidList = definitionUuidList;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    @Override
    public List<IResourceDefinition> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public ICacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.definition != null || this.definitionList != null || this.definitionHandle != null || this.definitionHandleList != null || this.definitionUuid != null || this.definitionUuidList != null) {
            ISystemDefinitionModelClient systemDefinitionClient = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
            ArrayList<IResourceDefinition> itemList = new ArrayList<IResourceDefinition>();
            if (this.definition != null) {
                itemList.add(this.definition);
            }
            if (this.definitionList != null) {
                itemList.addAll(this.definitionList);
            }
            if (this.definitionHandle != null) {
                itemList.add((IResourceDefinition)systemDefinitionClient.fetchSystemDefinitionComplete(this.definitionHandle, false, this.monitor));
            }
            if (this.definitionHandleList != null) {
                itemList.addAll(systemDefinitionClient.fetchSystemDefinitionsComplete(this.definitionHandleList, false, this.monitor));
            }
            if (this.definitionUuid != null) {
                itemList.add((IResourceDefinition)systemDefinitionClient.fetchSystemDefinitionComplete((ISystemDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.definitionUuid), null), false, this.monitor));
            }
            if (this.definitionUuidList != null) {
                ArrayList<ISystemDefinitionHandle> systemDefinitionHandles = new ArrayList<ISystemDefinitionHandle>();
                for (String uuid : this.definitionUuidList) {
                    systemDefinitionHandles.add((ISystemDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
                }
                itemList.addAll(systemDefinitionClient.fetchSystemDefinitionsComplete(systemDefinitionHandles, false, this.monitor));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IResourceDefinition> itemMapByName = new HashMap<String, IResourceDefinition>();
            HashMap<String, IResourceDefinition> itemMapByUuid = new HashMap<String, IResourceDefinition>();
            for (IResourceDefinition iResourceDefinition : itemList) {
                if (this.itemCacheItem.hasItemMapByName()) {
                    String itemName = iResourceDefinition.getName().trim();
                    itemMapByName.put(itemName, iResourceDefinition);
                }
                if (!this.itemCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = iResourceDefinition.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, iResourceDefinition);
            }
            this.itemCacheItem.setRepository(this.repository);
            this.itemCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.itemCacheItem.setProcessArea((IProcessAreaHandle)this.projectArea);
            this.itemCacheItem.setProcessAreaId(this.projectArea.getItemId().getUuidValue());
            this.itemCacheItem.setItemHandle(null);
            this.itemCacheItem.setItemHandleId(null);
            this.itemCacheItem.setPartial();
            if (this.itemCacheItem.hasItemList()) {
                this.itemCacheItem.addAllItemList((List<IResourceDefinition>)itemList);
            }
            if (this.itemCacheItem.hasItemMapByName()) {
                this.itemCacheItem.addAllItemMapByName((Map<String, IResourceDefinition>)itemMapByName);
            }
            if (this.itemCacheItem.hasItemMapByUuid()) {
                this.itemCacheItem.addAllItemMapByUuid((Map<String, IResourceDefinition>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            ISystemDefinitionModelClient systemDefinitionClient = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
            List<Object> itemList = null;
            itemList = this.platform == null ? systemDefinitionClient.findSystemDefinitionsComplete(IDataSetDefinition.ITEM_TYPE, this.projectArea, this.usage, false, this.monitor) : (this.platform.equals((Object)ISystemDefinition.Platform.zos) ? systemDefinitionClient.findSystemDefinitionsComplete(IDataSetDefinition.ITEM_TYPE, this.projectArea, this.usage, false, this.monitor) : new ArrayList());
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IResourceDefinition> itemMapByName = new HashMap<String, IResourceDefinition>();
            HashMap<String, IResourceDefinition> itemMapByUuid = new HashMap<String, IResourceDefinition>();
            for (IResourceDefinition iResourceDefinition : itemList) {
                if (this.itemCacheItem.hasItemMapByName()) {
                    String itemName = iResourceDefinition.getName().trim();
                    itemMapByName.put(itemName, iResourceDefinition);
                }
                if (!this.itemCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = iResourceDefinition.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, iResourceDefinition);
            }
            this.itemCacheItem.setRepository(this.repository);
            this.itemCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.itemCacheItem.setProcessArea((IProcessAreaHandle)this.projectArea);
            this.itemCacheItem.setProcessAreaId(this.projectArea.getItemId().getUuidValue());
            this.itemCacheItem.setItemHandle(null);
            this.itemCacheItem.setItemHandleId(null);
            if (this.usage == -1) {
                this.itemCacheItem.setComplete();
            } else {
                this.itemCacheItem.setPartial();
            }
            if (!this.append) {
                this.itemCacheItem.clear();
                this.itemCacheItem.clearPlatformEntry();
                this.itemCacheItem.setUsage(this.usage);
                this.itemCacheItem.setPlatformEntry(this.platform, (Integer)this.usage, (List<IResourceDefinition>)itemList);
                if (this.itemCacheItem.hasItemList()) {
                    this.itemCacheItem.setItemList((List<IResourceDefinition>)itemList);
                }
                if (this.itemCacheItem.hasItemMapByName()) {
                    this.itemCacheItem.setItemMapByName((Map<String, IResourceDefinition>)itemMapByName);
                }
                if (this.itemCacheItem.hasItemMapByUuid()) {
                    this.itemCacheItem.setItemMapByUuid((Map<String, IResourceDefinition>)itemMapByUuid);
                }
            } else {
                this.itemCacheItem.addUsage(this.usage);
                this.itemCacheItem.setPlatformEntry(this.platform, (Integer)this.usage, (List<IResourceDefinition>)itemList);
                if (this.itemCacheItem.hasItemList()) {
                    this.itemCacheItem.addAllItemList((List<IResourceDefinition>)itemList);
                }
                if (this.itemCacheItem.hasItemMapByName()) {
                    this.itemCacheItem.addAllItemMapByName((Map<String, IResourceDefinition>)itemMapByName);
                }
                if (this.itemCacheItem.hasItemMapByUuid()) {
                    this.itemCacheItem.addAllItemMapByUuid((Map<String, IResourceDefinition>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    @Override
    public final void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public final void setUsage(int usage) {
        this.usage = usage;
    }

    public final void setDatasetUsageAll() {
        this.usage = -1;
    }

    public final void setDatasetUsageZfolder() {
        this.usage = 0;
    }

    public final void setDatasetUsageNew() {
        this.usage = 1;
    }

    public final void setDatasetUsageTemporary() {
        this.usage = 2;
    }

    public final void setDatasetUsageExisting() {
        this.usage = 3;
    }
}

