/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.extensions.client.util.BuildDefinition;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoad;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoadExecute;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheItemBuildDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ItemCacheLoadBuildDefinition
implements ICacheLoad,
ICacheLoadExecute<IBuildDefinition>,
Callable<ICacheLoad> {
    private final ItemCacheItemBuildDefinition itemCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final ISystemDefinition.Platform platform;
    private final IBuildDefinition item;
    private final List<IBuildDefinition> items;
    private final IBuildDefinitionHandle itemHandle;
    private final List<IBuildDefinitionHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IBuildDefinition> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public ItemCacheLoadBuildDefinition(ITeamRepository repository, IProcessAreaHandle processArea, ISystemDefinition.Platform platform, ItemCacheItemBuildDefinition itemCacheItem, IBuildDefinition item, List<IBuildDefinition> items, IBuildDefinitionHandle itemHandle, List<IBuildDefinitionHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea == null ? null : processArea.getItemId().getUuidValue();
        this.platform = platform;
        this.itemCacheItem = itemCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    @Override
    public List<IBuildDefinition> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public ICacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ArrayList<IBuildDefinition> itemList = new ArrayList<IBuildDefinition>();
            if (this.item != null) {
                itemList.add(this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(BuildDefinition.getBuildDefinition((ITeamRepository)this.repository, (IBuildDefinitionHandle)this.itemHandle, (IProgressMonitor)this.monitor, (IDebugger)this.dbg));
            }
            if (this.itemHandles != null) {
                itemList.addAll(BuildDefinition.getBuildDefinitions((ITeamRepository)this.repository, this.itemHandles, (IProgressMonitor)this.monitor, (IDebugger)this.dbg));
            }
            if (this.itemString != null) {
                itemList.add(BuildDefinition.getBuildDefinition((ITeamRepository)this.repository, (String)this.itemString, (IProgressMonitor)this.monitor, (IDebugger)this.dbg));
            }
            if (this.itemStrings != null) {
                itemList.addAll(BuildDefinition.getBuildDefinitions((ITeamRepository)this.repository, this.itemStrings, (IProgressMonitor)this.monitor, (IDebugger)this.dbg));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildDefinition> itemMapByName = new HashMap<String, IBuildDefinition>();
            HashMap<String, IBuildDefinition> itemMapByUuid = new HashMap<String, IBuildDefinition>();
            for (IBuildDefinition item : itemList) {
                if (this.itemCacheItem.hasItemMapByName()) {
                    String itemName = item.getId();
                    itemMapByName.put(itemName, item);
                }
                if (!this.itemCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.itemCacheItem.setRepository(this.repository);
            this.itemCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.itemCacheItem.setProcessArea(this.processArea);
            this.itemCacheItem.setProcessAreaId(this.processAreaId);
            this.itemCacheItem.setItemHandle(null);
            this.itemCacheItem.setItemHandleId(null);
            this.itemCacheItem.setPartial();
            if (this.itemCacheItem.hasItemList()) {
                this.itemCacheItem.addAllItemList((List<IBuildDefinition>)itemList);
            }
            if (this.itemCacheItem.hasItemMapByName()) {
                this.itemCacheItem.addAllItemMapByName((Map<String, IBuildDefinition>)itemMapByName);
            }
            if (this.itemCacheItem.hasItemMapByUuid()) {
                this.itemCacheItem.addAllItemMapByUuid((Map<String, IBuildDefinition>)itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            List itemHandles = this.processArea == null ? BuildDefinition.getBuildDefinitionHandles((ITeamRepository)this.repository, (IProgressMonitor)this.monitor, (IDebugger)this.dbg) : BuildDefinition.getBuildDefinitionHandles((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea, (IProgressMonitor)this.monitor, (IDebugger)this.dbg);
            List itemList = BuildDefinition.getBuildDefinitions((ITeamRepository)this.repository, (List)itemHandles, (IDebugger)this.dbg);
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildDefinition> itemMapByName = new HashMap<String, IBuildDefinition>();
            HashMap<String, IBuildDefinition> itemMapByUuid = new HashMap<String, IBuildDefinition>();
            for (IBuildDefinition item : itemList) {
                if (this.itemCacheItem.hasItemMapByName()) {
                    String itemName = item.getId();
                    itemMapByName.put(itemName, item);
                }
                if (!this.itemCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.itemCacheItem.setRepository(this.repository);
            this.itemCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.itemCacheItem.setProcessArea(this.processArea);
            this.itemCacheItem.setProcessAreaId(this.processAreaId);
            this.itemCacheItem.setItemHandle(null);
            this.itemCacheItem.setItemHandleId(null);
            if (this.usage == -1) {
                this.itemCacheItem.setComplete();
            } else {
                this.itemCacheItem.setPartial();
            }
            if (!this.append) {
                this.itemCacheItem.clear();
                this.itemCacheItem.clearPlatformEntry();
                this.itemCacheItem.setUsage(this.usage);
                this.itemCacheItem.setPlatformEntry(this.platform, (Integer)this.usage, itemList);
                if (this.itemCacheItem.hasItemList()) {
                    this.itemCacheItem.setItemList(itemList);
                }
                if (this.itemCacheItem.hasItemMapByName()) {
                    this.itemCacheItem.setItemMapByName((Map<String, IBuildDefinition>)itemMapByName);
                }
                if (this.itemCacheItem.hasItemMapByUuid()) {
                    this.itemCacheItem.setItemMapByUuid((Map<String, IBuildDefinition>)itemMapByUuid);
                }
            } else {
                this.itemCacheItem.addUsage(this.usage);
                this.itemCacheItem.setPlatformEntry(this.platform, (Integer)this.usage, itemList);
                if (this.itemCacheItem.hasItemList()) {
                    this.itemCacheItem.addAllItemList(itemList);
                }
                if (this.itemCacheItem.hasItemMapByName()) {
                    this.itemCacheItem.addAllItemMapByName((Map<String, IBuildDefinition>)itemMapByName);
                }
                if (this.itemCacheItem.hasItemMapByUuid()) {
                    this.itemCacheItem.addAllItemMapByUuid((Map<String, IBuildDefinition>)itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    @Override
    public final void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

