/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheLoad;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ItemCacheLoad {
    private static volatile ItemCacheLoad instance;
    private ExecutorService executor;
    private ExecutorCompletionService<ICacheLoad> requests;
    private Integer requestThreadMax = 16;
    private Long requestTimeoutInt = 8000L;
    private final List<ICacheLoad> requestsList = new ArrayList<ICacheLoad>();
    private final List<ICacheLoad> completeList = new ArrayList<ICacheLoad>();

    private ItemCacheLoad() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ItemCacheLoad getInstance() {
        if (instance != null) return instance;
        Class<ItemCacheLoad> clazz = ItemCacheLoad.class;
        synchronized (ItemCacheLoad.class) {
            if (instance != null) return instance;
            instance = new ItemCacheLoad();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ItemCacheLoad itemCacheLoad = this;
        synchronized (itemCacheLoad) {
            if (this.executor == null) {
                this.executor = Executors.newFixedThreadPool(this.requestThreadMax);
                this.requests = new ExecutorCompletionService(this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void term() {
        ItemCacheLoad itemCacheLoad = this;
        synchronized (itemCacheLoad) {
            if (this.executor != null) {
                this.executor.shutdownNow();
                this.completeList.clear();
                this.requestsList.clear();
                this.requests = null;
                this.executor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(ICacheLoad request) throws TeamRepositoryException {
        Class<ItemCacheLoad> clazz = ItemCacheLoad.class;
        synchronized (ItemCacheLoad.class) {
            this.init();
            if (this.requests == null) {
                throw new TeamRepositoryException(Messages.ITEMCACHE_CACHELOAD_FAILED);
            }
            this.requestsList.add(request);
            this.requests.submit((Callable)((Object)request));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loaded() throws TeamRepositoryException {
        Class<ItemCacheLoad> clazz = ItemCacheLoad.class;
        synchronized (ItemCacheLoad.class) {
            if (this.requests != null) {
                try {
                    while (!this.completeList.containsAll(this.requestsList)) {
                        Future<ICacheLoad> future = this.requests.poll(this.requestTimeoutInt, TimeUnit.MILLISECONDS);
                        if (future == null) {
                            throw new TeamRepositoryException(Messages.ITEMCACHE_CACHELOAD_TIMEOUT);
                        }
                        this.completeList.add(future.get());
                    }
                }
                catch (InterruptedException e) {
                    throw new TeamRepositoryException(Messages.ITEMCACHE_CACHELOAD_EXCPINT, (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new TeamRepositoryException(Messages.ITEMCACHE_CACHELOAD_EXCPEXC, (Throwable)e);
                }
            } else {
                throw new TeamRepositoryException(Messages.ITEMCACHE_CACHELOAD_NOTINIT);
            }
            this.term();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Integer getRequestThreadMax() {
        Integer result;
        Integer n = this.requestThreadMax;
        synchronized (n) {
            result = this.requestThreadMax;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long getRequestTimeoutInt() {
        Long result;
        Long l = this.requestTimeoutInt;
        synchronized (l) {
            result = this.requestTimeoutInt;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLoading() {
        Class<ItemCacheLoad> clazz = ItemCacheLoad.class;
        synchronized (ItemCacheLoad.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.requestsList.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRequestThreadMax(Integer requestThreadMax) {
        Integer n = requestThreadMax;
        synchronized (n) {
            this.requestThreadMax = requestThreadMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getRequestTimeoutInt(Long requestTimeoutInt) {
        Long l = requestTimeoutInt;
        synchronized (l) {
            this.requestTimeoutInt = requestTimeoutInt;
        }
    }
}

