/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheItem;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionLogString;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ItemCacheItemAddFunction {
    private static final String className = ItemCacheItemAddFunction.class.getSimpleName();

    public static IFunctionDefinition add(ITeamRepository repository, ICacheItem<IFunctionDefinition> itemCacheItem, IFunctionDefinition item, ISystemDefinitionHandle itemHandle, String itemUuid, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ISystemDefinitionModelClient systemDefinitionClient = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        IFunctionDefinition itemDefinition = null;
        if (item != null) {
            if (itemCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return itemCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (itemCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return itemCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (IFunctionDefinition)systemDefinitionClient.fetchSystemDefinitionComplete(itemHandle, false, monitor);
        } else if (itemUuid != null) {
            if (itemCacheItem.containsUuid(itemUuid)) {
                return itemCacheItem.getUuid(itemUuid);
            }
            itemDefinition = (IFunctionDefinition)systemDefinitionClient.fetchSystemDefinitionComplete((ISystemDefinitionHandle)IFunctionDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemUuid), null), false, monitor);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = itemDefinition.getName();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (itemCacheItem.hasItemList()) {
            itemCacheItem.addItemList(itemDefinition);
        }
        if (itemCacheItem.hasItemMapByName()) {
            itemCacheItem.addItemMapByName(itemDefinitionName, itemDefinition);
        }
        if (itemCacheItem.hasItemMapByUuid()) {
            itemCacheItem.addItemMapByUuid(itemDefinitionUuid, itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), SystemDefinitionLogString.valueOf((IFunctionDefinition)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IFunctionDefinition> add(ITeamRepository repository, ICacheItem<IFunctionDefinition> itemCacheItem, List<IFunctionDefinition> items, List<ISystemDefinitionHandle> itemHandles, List<String> itemUuids, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ISystemDefinitionModelClient systemDefinitionClient = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        ArrayList<IFunctionDefinition> itemList = new ArrayList<IFunctionDefinition>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(systemDefinitionClient.fetchSystemDefinitionsComplete(itemHandles, false, monitor));
        } else if (itemUuids != null) {
            ArrayList<ISystemDefinitionHandle> systemDefinitionHandles = new ArrayList<ISystemDefinitionHandle>();
            for (String uuid : itemUuids) {
                systemDefinitionHandles.add((ISystemDefinitionHandle)IFunctionDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
            }
            itemList.addAll(systemDefinitionClient.fetchSystemDefinitionsComplete(systemDefinitionHandles, false, monitor));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IFunctionDefinition> itemMapByName = new HashMap<String, IFunctionDefinition>();
        HashMap<String, IFunctionDefinition> itemMapByUuid = new HashMap<String, IFunctionDefinition>();
        for (IFunctionDefinition item : itemList) {
            if (itemCacheItem.hasItemMapByName()) {
                String itemName = item.getName().trim();
                itemMapByName.put(itemName, item);
            }
            if (!itemCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (itemCacheItem.hasItemList()) {
            itemCacheItem.addAllItemList(itemList);
        }
        if (itemCacheItem.hasItemMapByName()) {
            itemCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (itemCacheItem.hasItemMapByUuid()) {
            itemCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

