/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.extensions.client.util.BuildEngine;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheItem;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ItemCacheItemAddBuildEngine {
    private static final String className = ItemCacheItemAddBuildEngine.class.getSimpleName();

    public static IBuildEngine add(ITeamRepository repository, ICacheItem<IBuildEngine> itemCacheItem, IBuildEngine item, IBuildEngineHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        IBuildEngine itemDefinition = null;
        if (item != null) {
            if (itemCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return itemCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (itemCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return itemCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (IBuildEngine)client.fetchCompleteItem((IItemHandle)itemHandle, 0, monitor);
        } else if (itemString != null) {
            if (itemCacheItem.contains(itemString)) {
                return itemCacheItem.get(itemString);
            }
            itemDefinition = BuildEngine.getBuildEngine((ITeamRepository)repository, (String)itemString, (IProgressMonitor)monitor, (IDebugger)dbg);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = itemDefinition.getId();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (itemCacheItem.hasItemList()) {
            itemCacheItem.addItemList(itemDefinition);
        }
        if (itemCacheItem.hasItemMapByName()) {
            itemCacheItem.addItemMapByName(itemDefinitionName, itemDefinition);
        }
        if (itemCacheItem.hasItemMapByUuid()) {
            itemCacheItem.addItemMapByUuid(itemDefinitionUuid, itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IBuildEngine> add(ITeamRepository repository, ICacheItem<IBuildEngine> itemCacheItem, List<IBuildEngine> items, List<IBuildEngineHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IItemManager client = repository.itemManager();
        ArrayList<IBuildEngine> itemList = new ArrayList<IBuildEngine>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(client.fetchCompleteItems(itemHandles, 0, monitor));
        } else if (itemStrings != null) {
            itemList.addAll(BuildEngine.getBuildEngines((ITeamRepository)repository, itemStrings, (IProgressMonitor)monitor, (IDebugger)dbg));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IBuildEngine> itemMapByName = new HashMap<String, IBuildEngine>();
        HashMap<String, IBuildEngine> itemMapByUuid = new HashMap<String, IBuildEngine>();
        for (IBuildEngine item : itemList) {
            if (itemCacheItem.hasItemMapByName()) {
                String itemName = item.getId();
                itemMapByName.put(itemName, item);
            }
            if (!itemCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (itemCacheItem.hasItemList()) {
            itemCacheItem.addAllItemList(itemList);
        }
        if (itemCacheItem.hasItemMapByName()) {
            itemCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (itemCacheItem.hasItemMapByUuid()) {
            itemCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

