/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.extensions.client.util.BuildDefinition;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheItem;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ItemCacheItemAddBuildDefinition {
    private static final String className = ItemCacheItemAddBuildDefinition.class.getSimpleName();

    public static IBuildDefinition add(ITeamRepository repository, ICacheItem<IBuildDefinition> itemCacheItem, IBuildDefinition item, IBuildDefinitionHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        IBuildDefinition itemDefinition = null;
        if (item != null) {
            if (itemCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return itemCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (itemCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return itemCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (IBuildDefinition)client.fetchCompleteItem((IItemHandle)itemHandle, 0, monitor);
        } else if (itemString != null) {
            if (itemCacheItem.contains(itemString)) {
                return itemCacheItem.get(itemString);
            }
            itemDefinition = BuildDefinition.getBuildDefinition((ITeamRepository)repository, (String)itemString, (IProgressMonitor)monitor, (IDebugger)dbg);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = itemDefinition.getId();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (itemCacheItem.hasItemList()) {
            itemCacheItem.addItemList(itemDefinition);
        }
        if (itemCacheItem.hasItemMapByName()) {
            itemCacheItem.addItemMapByName(itemDefinitionName, itemDefinition);
        }
        if (itemCacheItem.hasItemMapByUuid()) {
            itemCacheItem.addItemMapByUuid(itemDefinitionUuid, itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IBuildDefinition> add(ITeamRepository repository, ICacheItem<IBuildDefinition> itemCacheItem, List<IBuildDefinition> items, List<IBuildDefinitionHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IItemManager client = repository.itemManager();
        ArrayList<IBuildDefinition> itemList = new ArrayList<IBuildDefinition>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(client.fetchCompleteItems(itemHandles, 0, monitor));
        } else if (itemStrings != null) {
            ArrayList<IBuildDefinitionHandle> handles = new ArrayList<IBuildDefinitionHandle>();
            for (String itemId : itemStrings) {
                handles.add(BuildDefinition.getBuildDefinitionHandle((ITeamRepository)repository, (String)itemId, (IProgressMonitor)monitor, (IDebugger)dbg));
            }
            itemList.addAll(client.fetchCompleteItems(handles, 0, monitor));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IBuildDefinition> itemMapByName = new HashMap<String, IBuildDefinition>();
        HashMap<String, IBuildDefinition> itemMapByUuid = new HashMap<String, IBuildDefinition>();
        for (IBuildDefinition item : itemList) {
            if (itemCacheItem.hasItemMapByName()) {
                String itemName = item.getId();
                itemMapByName.put(itemName, item);
            }
            if (!itemCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (itemCacheItem.hasItemList()) {
            itemCacheItem.addAllItemList(itemList);
        }
        if (itemCacheItem.hasItemMapByName()) {
            itemCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (itemCacheItem.hasItemMapByUuid()) {
            itemCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

