/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.cache;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.common.IItemType;

public interface ICacheType {

    public static enum CacheType {
        DATASET(ISystemDefinition.Platform.zos, IResourceDefinition.ITEM_TYPE),
        FUNCTION(null, IFunctionDefinition.ITEM_TYPE),
        LANGUAGE(null, ILanguageDefinition.ITEM_TYPE),
        LIBRARY(ISystemDefinition.Platform.ibmi, IResourceDefinition.ITEM_TYPE),
        SEARCHPATH(null, ISearchPath.ITEM_TYPE),
        TRANSLATOR(null, ITranslator.ITEM_TYPE),
        VERSION(null, IVersionDefinition.ITEM_TYPE);

        private final ISystemDefinition.Platform platform;
        private final IItemType type;

        private CacheType(ISystemDefinition.Platform platform, IItemType type) {
            this.platform = platform;
            this.type = type;
        }

        public ISystemDefinition.Platform getPlatform() {
            return this.platform;
        }

        public IItemType getType() {
            return this.type;
        }

        public static final CacheType get(String s) {
            CacheType[] cacheTypeArray = CacheType.values();
            int n = cacheTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CacheType cachetype = cacheTypeArray[n2];
                if (cachetype.toString().equals(s)) {
                    return cachetype;
                }
                ++n2;
            }
            return null;
        }

        public static final CacheType get(ISystemDefinition.Platform platform, IItemType type) {
            CacheType[] cacheTypeArray = CacheType.values();
            int n = cacheTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CacheType cachetype = cacheTypeArray[n2];
                if (SystemDefinitionUtil.isTypeOf((IItemType)cachetype.getType(), (IItemType)type)) {
                    if (cachetype.getPlatform() == null) {
                        return cachetype;
                    }
                    if (cachetype.getPlatform().equals((Object)platform)) {
                        return cachetype;
                    }
                }
                ++n2;
            }
            return null;
        }
    }
}

