/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.ICommonConstants;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebugUtility;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterTemplate;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

@DebugGroup(value={"zBuilder"})
@DebugUtility(value=true)
public class BuilderTemplateFactory {
    public static final String Path = "builder";

    private BuilderTemplateFactory() {
    }

    public static final String getBuild(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/sysdefs/Build.%s.xml", id).getTemplate(tokens);
    }

    public static final String getBuildLaunch(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/_launch/Build.%s.xml.launch", id).getTemplate(tokens);
    }

    public static final String getEngine(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/engines/Engine.JBE.xml", id).getTemplate(tokens);
    }

    public static final String getEngineLaunch(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/_launch/Engine.JBE.xml.launch", id).getTemplate(tokens);
    }

    public static final String getLanguage(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/sysdefs/Language.%s.xml", id).getTemplate(tokens);
    }

    public static final String getLanguageDocument(IImporterLanguage language) {
        String result = "";
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(language.createDocument());
            transformer.transform(source, streamResult);
            result = streamResult.getWriter().toString().replace("\"?><", ICommonConstants.CONSTANT_XML_SEQ2A).replace("--><", ICommonConstants.CONSTANT_XML_SEQ2B);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static final String getLanguageLaunch(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/_launch/Language.%s.xml.launch", id).getTemplate(tokens);
    }

    public static final String getProjectProperties(List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/_config/project.properties").getTemplate(tokens);
    }

    public static final String getResourceMacro(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/_macros/resources/%s.tmp", id).getTemplate(tokens);
    }

    public static final String getResource(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/sysdefs/Resource.%s.xml", id).getTemplate(tokens);
    }

    public static final String getResourceLaunch(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/_launch/Resource.%s.xml.launch", id).getTemplate(tokens);
    }

    public static final String getTranslatorMacro(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/_macros/translators/%s.tmp", id).getTemplate(tokens);
    }

    public static final String getTranslator(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/sysdefs/Translator.%s.xml", id).getTemplate(tokens);
    }

    public static final String getTranslatorLaunch(String id, List<IImporterToken> tokens) {
        return BuilderTemplateFactory.getTemplate("templates/%s/_launch/Translator.%s.xml.launch", id).getTemplate(tokens);
    }

    private static ImporterTemplate getTemplate(String template) {
        return new ImporterTemplate(String.format(template, Path));
    }

    private static ImporterTemplate getTemplate(String template, String id) {
        return new ImporterTemplate(String.format(template, Path, id));
    }
}

