/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebugUtility;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.internal.client.Password;
import com.ibm.team.enterprise.common.common.ZBuilderNature;
import com.ibm.team.enterprise.internal.common.common.PasswordHelper;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderLanguage;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderStepAsm;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderStepCob;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderStepDef;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderStepIrx;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderStepLnk;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderStepSld;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterEngine;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterMetadata;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterProperties;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderTemplateFactory;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderUtilities;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterEngine;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterMetadata;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterPropertyKey;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepAsm;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepCob;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepDef;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepIrx;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepLnk;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepSld;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterException;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterFactoryException;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterPropertyKey;
import com.ibm.team.enterprise.systemdefinition.common.util.DatasetCache;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

@DebugGroup(value={"zBuilder"})
@DebugUtility(value=true)
public class BuilderFactory {
    private static String cls = BuilderFactory.class.getSimpleName();
    private static IDebugger dbg = new Debugger(BuilderFactory.class);

    private BuilderFactory() {
    }

    public static void createEngine(IProject project, IImporterEngine engine, IProgressMonitor monitor) throws ImporterFactoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!project.exists()) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zBuilder_PROJECT_NAME_NONEXISTS, (Object)project.getName()));
        }
        if (engine == null) {
            throw new ImporterFactoryException(Messages.zBuilder_ENGINE_REQ_PARAMETER);
        }
        try {
            IFolder resource = null;
            IFile file = null;
            resource = project.getFolder("engines");
            if (!resource.exists()) {
                resource.create(true, true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Engine.%s.xml", engine.getProperties().getId(), engine.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getEngine(engine.getType().getName(), engine.createTokenList()).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Engine.%s.xml.launch", engine.getProperties().getId(), engine.getId()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getEngineLaunch(engine.getType().getName(), engine.createTokenList()).getBytes()), true, monitor);
            }
        }
        catch (Exception e) {
            throw new ImporterFactoryException((Throwable)e);
        }
    }

    public static void createLanguageFiles(IProject project, IImporterLanguage language, DatasetCache cache, IProgressMonitor monitor) throws ImporterFactoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!project.exists()) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zBuilder_PROJECT_NAME_NONEXISTS, (Object)project.getName()));
        }
        if (language == null) {
            throw new ImporterFactoryException(Messages.zBuilder_LANGUAGE_REQUIRED);
        }
        language.setCache(cache);
        try {
            IFolder properties = null;
            IFolder launches = null;
            IFolder resource = null;
            IFile file = null;
            launches = project.getFolder(".launch");
            if (!launches.exists()) {
                launches.create(true, true, monitor);
            }
            if (!(resource = project.getFolder("sysdefs")).exists()) {
                resource.create(true, true, monitor);
            }
            String zBuilderId = language.getProperties().getId();
            String languageId = language.getId();
            String languageType = language.getType().getName();
            List tokenList = language.createTokenList();
            file = resource.getFile(String.format("%s.Build.%s.xml", zBuilderId, languageId));
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getBuild(languageType, tokenList).getBytes()), true, monitor);
            }
            if (!(file = launches.getFile(String.format("%s.Build.%s.xml.launch", zBuilderId, languageId))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getBuildLaunch(languageType, tokenList).getBytes()), true, monitor);
            }
            if (!(file = resource.getFile(String.format("%s.Language.%s.xml", zBuilderId, languageId))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getLanguage(languageType, tokenList).getBytes()), true, monitor);
            }
            if (!(file = launches.getFile(String.format("%s.Language.%s.xml.launch", zBuilderId, languageId))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getLanguageLaunch(languageType, tokenList).getBytes()), true, monitor);
            }
            StringBuilder resources = new StringBuilder();
            for (IImporterStep step : language.getSteps()) {
                List<IImporterToken> tokens = tokenList.stream().filter(p -> p.sameStep(step)).map(p -> p).collect(Collectors.toList());
                resources.append(BuilderTemplateFactory.getResourceMacro(step.getId(), tokens));
            }
            resources.setLength(resources.length() - 1);
            IImporterToken resoToken = BuilderFactory.createToken();
            resoToken.setName("@RESOURCES@");
            resoToken.setValue(resources.toString());
            tokenList.add(resoToken);
            file = resource.getFile(String.format("%s.Resource.%s.xml", zBuilderId, languageId));
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getResource(languageType, tokenList).getBytes()), true, monitor);
            }
            if (!(file = launches.getFile(String.format("%s.Resource.%s.xml.launch", zBuilderId, languageId))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getResourceLaunch(languageType, tokenList).getBytes()), true, monitor);
            }
            StringBuilder translators = new StringBuilder();
            for (IImporterStep step : language.getSteps()) {
                List<IImporterToken> tokens = tokenList.stream().filter(p -> p.sameStep(step)).map(p -> p).collect(Collectors.toList());
                translators.append(BuilderTemplateFactory.getTranslatorMacro(step.getId(), tokens));
            }
            translators.setLength(translators.length() - 1);
            IImporterToken tranToken = BuilderFactory.createToken();
            tranToken.setName("@TRANSLATORS@");
            tranToken.setValue(translators.toString());
            tokenList.add(tranToken);
            file = resource.getFile(String.format("%s.Translator.%s.xml", zBuilderId, languageId));
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getTranslator(languageType, tokenList).getBytes()), true, monitor);
            }
            if (!(file = launches.getFile(String.format("%s.Translator.%s.xml.launch", zBuilderId, languageId))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getTranslatorLaunch(languageType, tokenList).getBytes()), true, monitor);
            }
            if (!(properties = project.getFolder(".config")).exists()) {
                properties.create(true, true, monitor);
            }
            if (!(file = properties.getFile(String.format("%s.Export.Language.%s.xml", zBuilderId, languageId))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getLanguageDocument(language).getBytes()), true, monitor);
            }
        }
        catch (Exception e) {
            throw new ImporterFactoryException((Throwable)e);
        }
    }

    public static IImporterDataset createDataset() {
        return new ImporterDataset();
    }

    public static IImporterEngine createEngine() {
        return new ImporterEngine();
    }

    public static IImporterProperties createProperties() {
        return new ImporterProperties();
    }

    public static IImporterProperties createProperties(Properties properties) {
        return new ImporterProperties(properties);
    }

    public static IImporterPropertyKey createPropertyKey(String suffix) {
        return new ImporterPropertyKey(suffix);
    }

    public static IImporterLanguage createLanguage() {
        return new BuilderLanguage();
    }

    public static IImporterMetadata createMetadata() {
        return new ImporterMetadata();
    }

    public static IImporterStepAsm createStepAsm() {
        return BuilderFactory.createStepAsm(false);
    }

    public static IImporterStepAsm createStepAsm(boolean defaultsBuiltin) {
        BuilderStepAsm result = new BuilderStepAsm();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterStepCob createStepCob() {
        return BuilderFactory.createStepCob(false);
    }

    public static IImporterStepCob createStepCob(boolean defaultsBuiltin) {
        BuilderStepCob result = new BuilderStepCob();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterStepDef createStepDefault() {
        return BuilderFactory.createStepDefault(false);
    }

    public static IImporterStepDef createStepDefault(boolean defaultsBuiltin) {
        BuilderStepDef result = new BuilderStepDef();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterStepIrx createStepIrx() {
        return BuilderFactory.createStepIrx(false);
    }

    public static IImporterStepIrx createStepIrx(boolean defaultsBuiltin) {
        BuilderStepIrx result = new BuilderStepIrx();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterStepLnk createStepLnk() {
        return BuilderFactory.createStepLnk(false);
    }

    public static IImporterStepLnk createStepLnk(boolean defaultsBuiltin) {
        BuilderStepLnk result = new BuilderStepLnk();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterStepSld createStepSld() {
        return BuilderFactory.createStepSld(false);
    }

    public static IImporterStepSld createStepSld(boolean defaultsBuiltin) {
        BuilderStepSld result = new BuilderStepSld();
        if (defaultsBuiltin) {
            result.initDefault();
        } else {
            result.init();
        }
        return result;
    }

    public static IImporterToken createToken() {
        return new ImporterToken();
    }

    public static IProject createProject(String projectName, List<String> natures, IImporterProperties properties, IProgressMonitor progressMonitor) throws ImporterFactoryException {
        Mnm mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
        if (natures == null) {
            natures = new ArrayList<String>();
        }
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        try {
            BuilderUtilities.validateProjectName(projectName);
        }
        catch (ImporterException e) {
            throw new ImporterFactoryException((Throwable)e);
        }
        if (properties == null) {
            throw new ImporterFactoryException(Messages.zBuilder_PROJECT_REQ_PROPERTIES);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        natures.add(ZBuilderNature.ID);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zBuilder_PROJECT_NAME_NONUNIQUE, (Object)projectName));
        }
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        description.setName(projectName);
        description.setNatureIds(natures.toArray(new String[natures.size()]));
        try {
            project.create(description, progressMonitor);
            project.open(progressMonitor);
            IFolder resource = null;
            IFile file = null;
            resource = project.getFolder(".config");
            if (!resource.exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(file = resource.getFile(".properties")).exists()) {
                file.create((InputStream)new ByteArrayInputStream(BuilderTemplateFactory.getProjectProperties(properties.createTokenList()).getBytes()), true, progressMonitor);
            }
            if (!(file = resource.getFile(".password")).exists()) {
                try {
                    PasswordHelper.createPasswordFile((File)file.getRawLocation().toFile(), (String)new Password().getDecryptedPassword(properties.getPassword()));
                }
                catch (Exception e) {
                    throw new ImporterFactoryException(NLS.bind((String)Messages.zBuilder_PROJECT_PWD_EXCEPTION, (Object)projectName, (Object)e.getMessage()), (Throwable)e);
                }
            }
            if (!(resource = project.getFolder(".launch")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("builds")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("engines")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("imports")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("scripts")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("sysdefs")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            if (!(resource = project.getFolder("utilities")).exists()) {
                resource.create(true, true, progressMonitor);
            }
            project.refreshLocal(2, progressMonitor);
        }
        catch (Exception e) {
            throw new ImporterFactoryException(NLS.bind((String)Messages.zBuilder_PROJECT_UNK_EXCEPTION, (Object)projectName, (Object)e.getMessage()), (Throwable)e);
        }
        mnm.leave(new String[0]);
        return project;
    }
}

