/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client.advisors;

import com.ibm.team.enterprise.common.common.EtoolsIseriesNature;
import com.ibm.team.enterprise.common.common.ZComponentNature;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.process.DeliverOperationData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class LangDefinitionCheckAdvisor
implements IOperationAdvisor {
    private ITeamRepository fTeamRepository;
    static final String ADVISOR_ID = "com.ibm.team.enterprise.internal.process.systemdefinition.advisors.requireLangDefCheck";
    static final String TAG_DATA = "data";
    static final String TAG_REPOSITORY_ROOT = "repositoryRoot";
    static final String TAG_ERROR = "br";
    static final String TAG_STREAMS = "streams";
    static final String ATTR_LABEL = "label";
    static final String ATTR_UUID = "uuid";
    static final String ATTR_VALUE = "value";
    static final String COMA = ",";
    static final String DOT = ".";
    static final String EMPTY = "";
    static final String NEW_LINE = "\n";
    static final String SLASH = "/";
    static String LANGUAGE_DEFINITION_KEY = "team.enterprise.language.definition";
    private final List<String> exemptedFileExtensions = new ArrayList<String>();

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        this.loadProcessConfig(advisorConfiguration);
        Object opData = operation.getOperationData();
        if (!(opData instanceof DeliverOperationData)) {
            return;
        }
        DeliverOperationData data = (DeliverOperationData)opData;
        this.fTeamRepository = (ITeamRepository)data.getSourceWorkspace().getOrigin();
        List changeSetHandles = data.getChangeSetHandles();
        if (changeSetHandles != null && changeSetHandles.size() > 0) {
            List changeSets = this.fTeamRepository.itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
            HashSet<IVersionableHandle> changedVersionalHandles = new HashSet<IVersionableHandle>();
            Collections.sort(changeSets, new Comparator<IItem>(){

                @Override
                public int compare(IItem object1, IItem object2) {
                    int result = 0;
                    if (object1 == null && object2 != null) {
                        result = 1;
                    } else if (object1 != null && object2 == null) {
                        result = -1;
                    } else {
                        IChangeSet change1 = (IChangeSet)object1;
                        IChangeSet change2 = (IChangeSet)object2;
                        Date obj1Date = change1.getLastChangeDate();
                        Date obj2Date = change2.getLastChangeDate();
                        result = obj1Date.compareTo(obj2Date);
                    }
                    return result;
                }
            });
            for (IChangeSet changeSet : changeSets) {
                List changes = changeSet.changes();
                if (changes == null || changes.size() <= 0) continue;
                for (IChange change : changes) {
                    IVersionableHandle versionaHandle;
                    if (change.kind() == 16 || (versionaHandle = change.afterState()) == null || !(versionaHandle instanceof IFileItemHandle) || !this.isInterestedProject(versionaHandle)) continue;
                    changedVersionalHandles.add(versionaHandle);
                }
            }
            ArrayList<IVersionable> missingLangDefs = new ArrayList<IVersionable>();
            ArrayList<String> nameStrs = new ArrayList<String>();
            nameStrs.add(IVersionable.NAME_PROPERTY);
            nameStrs.add(IVersionable.PARENT_PROPERTY);
            List versionables = SCMPlatform.getWorkspaceManager((ITeamRepository)this.fTeamRepository).versionableManager().fetchPartialStates(new ArrayList(changedVersionalHandles), nameStrs, monitor);
            for (IVersionable file : versionables) {
                String fileFullName = file.getName();
                String fileExtension = null;
                int dotIndex = fileFullName.lastIndexOf(DOT);
                if (-1 == dotIndex) continue;
                fileExtension = fileFullName.substring(dotIndex + 1);
                if (this.hasLanguageDefinition((IVersionableHandle)file) || fileExtension == null || this.exemptedFileExtensions.contains(fileExtension.toLowerCase()) || this.exemptedFileExtensions.contains(fileExtension.toUpperCase())) continue;
                missingLangDefs.add(file);
            }
            if (missingLangDefs.size() != 0) {
                IWorkspaceConnection sps = SCMPlatform.getWorkspaceManager((ITeamRepository)this.fTeamRepository).getWorkspaceConnection((IWorkspaceHandle)data.getSourceWorkspace().getItemHandle(), null);
                ArrayList<String> filePaths = new ArrayList<String>();
                int i = 0;
                while (i < sps.getComponents().size()) {
                    List nameList = sps.configuration((IComponentHandle)sps.getComponents().get(i)).locateAncestors(new ArrayList(missingLangDefs), monitor);
                    List<String> candidatePath = this.getFilePaths(nameList);
                    if (candidatePath != null) {
                        filePaths.addAll(candidatePath);
                    }
                    ++i;
                }
                this.recordErrors(filePaths, collector);
            }
        }
    }

    public List<String> getFilePaths(List<IAncestorReport> ancestorsList) {
        ArrayList<String> pathList = new ArrayList<String>();
        int i = 0;
        while (i < ancestorsList.size()) {
            StringBuilder namePath = new StringBuilder();
            IAncestorReport ancestor = ancestorsList.get(i);
            int j = 1;
            while (j < ancestor.getNameItemPairs().size()) {
                INameItemPair pair = (INameItemPair)ancestor.getNameItemPairs().get(j);
                namePath.append(SLASH + pair.getName());
                ++j;
            }
            if (ancestor.getNameItemPairs().size() > 0) {
                pathList.add(namePath.toString());
            }
            ++i;
        }
        return pathList;
    }

    private void loadProcessConfig(IProcessConfigurationElement advisorConfiguration) {
        IProcessConfigurationElement fileExtensionsElement;
        IProcessConfigurationElement checkfileExtensionsElement;
        if (advisorConfiguration.getChildren().length != 0 && (checkfileExtensionsElement = advisorConfiguration.getChildren()[0]) != null && (fileExtensionsElement = checkfileExtensionsElement.getChildren()[0]) != null) {
            String extensionsStr = fileExtensionsElement.getAttribute(ATTR_VALUE);
            String[] extensions = extensionsStr.split(COMA);
            int i = 0;
            while (extensions != null && i < extensions.length) {
                this.exemptedFileExtensions.add(extensions[i]);
                ++i;
            }
        }
    }

    private void recordErrors(List<String> missingLangDefs, IAdvisorInfoCollector collector) {
        try {
            String problemDetail = this.createAdvisorInfoData(missingLangDefs);
            IAdvisorInfo info = collector.createProblemInfo(Messages.LangDefinitionCheckAdvisor_GENERAL_INFO, NLS.bind((String)Messages.LangDefinitionCheckAdvisor_GENERAL_Problem, (Object)problemDetail), ADVISOR_ID);
            collector.addInfo((IReportInfo)info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String createAdvisorInfoData(List<String> missingLangDefs) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String filePath : missingLangDefs) {
            sb.append(NEW_LINE);
            sb.append(filePath);
        }
        return sb.toString();
    }

    private boolean isInterestedProject(IVersionableHandle file) throws FileSystemException {
        for (IShareable shareable : SharingManager.getInstance().findShareables(file, null)) {
            IResource resource = (IResource)shareable.getAdapter(IResource.class);
            try {
                if ((resource == null || resource.getProject() == null || !resource.getProject().hasNature(EtoolsIseriesNature.ID)) && !resource.getProject().hasNature(ZComponentNature.ID)) continue;
                return true;
            }
            catch (CoreException e) {
                return false;
            }
        }
        return false;
    }

    private boolean hasLanguageDefinition(IVersionableHandle file) throws TeamRepositoryException {
        Iterator iter = SharingManager.getInstance().findShareables(file, null).iterator();
        boolean isAssociated = false;
        while (iter.hasNext()) {
            IShareable shreable = (IShareable)iter.next();
            String langDefUUID = null;
            IMetadataProperties metadataProperties = shreable.getMetadataProperties(null);
            if (metadataProperties != null) {
                langDefUUID = (String)metadataProperties.getCurrentProperties().get(LANGUAGE_DEFINITION_KEY);
            }
            if (langDefUUID == null || EMPTY.equals(langDefUUID)) continue;
            isAssociated = true;
            break;
        }
        return isAssociated;
    }
}

