/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.client;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.CommonSystemDefinitionHandleCache;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHandleCacheHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.List;

public class SystemDefinitionHandleCache
extends CommonSystemDefinitionHandleCache {
    private static SystemDefinitionHandleCache _instance;

    protected SystemDefinitionHandleCache() {
    }

    public static SystemDefinitionHandleCache getInstance() {
        if (_instance == null) {
            _instance = new SystemDefinitionHandleCache();
        }
        return _instance;
    }

    public synchronized ISystemDefinitionHandle getSystemDefinitionHandle(ITeamRepository repository, UUID uuid, IItemType type) throws TeamRepositoryException {
        return super.getSystemDefinitionHandle(uuid, type, (ISystemDefinitionHandleCacheHelper)new ClientSystemDefinitionHandleCacheHelper(repository));
    }

    public void deleteCache(ITeamRepository repository, IItemType type) {
        super.deleteCache(type, (ISystemDefinitionHandleCacheHelper)new ClientSystemDefinitionHandleCacheHelper(repository));
    }

    class ClientSystemDefinitionHandleCacheHelper
    implements ISystemDefinitionHandleCacheHelper {
        private ITeamRepository repository;

        public ClientSystemDefinitionHandleCacheHelper(ITeamRepository repository) {
            this.repository = repository;
        }

        public List<ISystemDefinitionHandle> getAllSystemDefinitionHandles(IItemType type) throws TeamRepositoryException {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
            return client.findSystemDefinitionHandles(type, null, -1, false, null);
        }

        public String getRepositoryUri() {
            return this.repository.getRepositoryURI();
        }
    }
}

