/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderStepIrx;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterOption;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepIrx;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingBuildOptions;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PackagingStepIrx
extends BuilderStepIrx
implements IImporterStepIrx {
    public PackagingStepIrx() {
    }

    public PackagingStepIrx(IImporterLanguage imported) {
        super(imported);
        for (IImporterTranslator translator : imported.getTranslators()) {
            if (!translator.getName().equals("IRX")) continue;
            this.buildOptions = new PackagingBuildOptions(StringUtil.toTitle((String)"IRX"));
            IPackagingBuildOptions buildOptions = (IPackagingBuildOptions)this.buildOptions;
            for (IImporterOption option : translator.getOptions()) {
                if (option.getName().equals("compile")) {
                    buildOptions.setCompile(option.getState());
                    buildOptions.setCompileEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("initial")) {
                    buildOptions.setInitial(option.getState());
                    buildOptions.setInitialEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("library")) {
                    buildOptions.setLibrary(option.getState());
                    buildOptions.setLibraryEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("package")) {
                    buildOptions.setPackage(option.getState());
                    buildOptions.setPackageEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("product")) {
                    buildOptions.setProduct(option.getState());
                    buildOptions.setProductEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("refresh")) {
                    buildOptions.setRefresh(option.getState());
                    buildOptions.setRefreshEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("service")) {
                    buildOptions.setService(option.getState());
                    buildOptions.setServiceEnabled(option.getEnabled());
                    continue;
                }
                if (!option.getName().equals("testing")) continue;
                buildOptions.setTesting(option.getState());
                buildOptions.setTestingEnabled(option.getEnabled());
            }
        }
    }

    @Override
    public final void init() {
        super.init();
        this.buildOptions = new PackagingBuildOptions("RexxExec");
    }

    @Override
    public final void initDefault() {
        super.init();
        this.buildOptions = new PackagingBuildOptions("RexxExec");
    }

    @Override
    public void createDocumentOptionsAdditional(Document document, Element translatorElement, IImporterBuildOptions ibo) {
        super.createDocumentOptionsAdditional(document, translatorElement, ibo);
        IPackagingBuildOptions buildOptions = (IPackagingBuildOptions)ibo;
        Element optionElement = null;
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isPackageEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isPackage()));
        optionElement.setTextContent("package");
        translatorElement.appendChild(optionElement);
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isProductEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isProduct()));
        optionElement.setTextContent("package");
        translatorElement.appendChild(optionElement);
    }

    @Override
    public void createConditionAttributeAdditional(StringBuilder conditionAttributes, IImporterBuildOptions ibo) {
        super.createConditionAttributeAdditional(conditionAttributes, ibo);
        IPackagingBuildOptions buildOptions = (IPackagingBuildOptions)ibo;
        if (!buildOptions.isPackage()) {
            conditionAttributes.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypePackage"));
        }
        if (!buildOptions.isProduct()) {
            conditionAttributes.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypeProduct"));
        }
    }

    @Override
    public void createTranslatorSyslibElementAdditional(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
        super.createTranslatorSyslibElementAdditional(language, tokens, datasets);
    }
}

