/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.enterprise.internal.systemdefinition.client.builder.BuilderStepAsm;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterOption;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepAsm;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingBuildOptions;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PackagingStepAsm
extends BuilderStepAsm
implements IImporterStepAsm {
    public PackagingStepAsm() {
    }

    public PackagingStepAsm(IImporterLanguage imported) {
        super(imported);
        for (IImporterTranslator translator : imported.getTranslators()) {
            if (!translator.getName().equals("ASM")) continue;
            this.buildOptions = new PackagingBuildOptions(StringUtil.toTitle((String)"ASM"));
            IPackagingBuildOptions buildOptions = (IPackagingBuildOptions)this.buildOptions;
            for (IImporterOption option : translator.getOptions()) {
                if (option.getName().equals("compile")) {
                    buildOptions.setCompile(option.getState());
                    buildOptions.setCompileEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("initial")) {
                    buildOptions.setInitial(option.getState());
                    buildOptions.setInitialEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("library")) {
                    buildOptions.setLibrary(option.getState());
                    buildOptions.setLibraryEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("package")) {
                    buildOptions.setPackage(option.getState());
                    buildOptions.setPackageEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("product")) {
                    buildOptions.setProduct(option.getState());
                    buildOptions.setProductEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("refresh")) {
                    buildOptions.setRefresh(option.getState());
                    buildOptions.setRefreshEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("service")) {
                    buildOptions.setService(option.getState());
                    buildOptions.setServiceEnabled(option.getEnabled());
                    continue;
                }
                if (!option.getName().equals("testing")) continue;
                buildOptions.setTesting(option.getState());
                buildOptions.setTestingEnabled(option.getEnabled());
            }
        }
    }

    @Override
    public final void init() {
        super.init();
        this.buildOptions = new PackagingBuildOptions("Assemble");
    }

    @Override
    public final void initDefault() {
        super.init();
        this.buildOptions = new PackagingBuildOptions("Assemble");
    }

    @Override
    public void createDocumentOptionsAdditional(Document document, Element translatorElement, IImporterBuildOptions ibo) {
        super.createDocumentOptionsAdditional(document, translatorElement, ibo);
        IPackagingBuildOptions buildOptions = (IPackagingBuildOptions)ibo;
        Element optionElement = null;
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isPackageEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isPackage()));
        optionElement.setTextContent("package");
        translatorElement.appendChild(optionElement);
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isProductEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isProduct()));
        optionElement.setTextContent("package");
        translatorElement.appendChild(optionElement);
    }

    @Override
    public void createConditionAttributeAdditional(StringBuilder conditionAttributes, IImporterBuildOptions ibo) {
        super.createConditionAttributeAdditional(conditionAttributes, ibo);
        IPackagingBuildOptions buildOptions = (IPackagingBuildOptions)ibo;
        if (!buildOptions.isPackage()) {
            conditionAttributes.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypePackage"));
        }
        if (!buildOptions.isProduct()) {
            conditionAttributes.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypeProduct"));
        }
    }

    @Override
    public void createTranslatorSyslibElementAdditional(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
        StringBuilder packageMaclibs = new StringBuilder();
        StringBuilder productMaclibs = new StringBuilder();
        String id = language.getId();
        int i = 0;
        while (i < datasets.size()) {
            IImporterDataset dataset = datasets.get(i);
            String standardName = datasets.size() > 1 ? String.format("%1$s.Resource.%3$s.SYSLIB.DSN%2$02d", id, i) : String.format("%1$s.Resource.%3$s.SYSLIB", id);
            if (dataset.iszFolder()) {
                packageMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
                productMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
            }
            ++i;
        }
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB_PACKAGE@", id), packageMaclibs.toString()));
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB_PRODUCT@", id), productMaclibs.toString()));
    }
}

