/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.client.util.SCMFileUtils;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.FileUtilities;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingTools;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemFile;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemFolder;
import com.ibm.team.enterprise.systemdefinition.common.model.Itemtype;
import com.ibm.team.enterprise.systemdefinition.common.model.Mcstype;
import com.ibm.team.enterprise.systemdefinition.common.model.PartStatus;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDataset;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFmidItem;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class PackagingContent {
    private final IDebugger dbg;
    private final String simpleName;
    private final ITeamRepository repository;
    private final IProgressMonitor monitor;
    private final IWorkspaceConnection wsConnection;
    private final PackagingTools packagingTools;
    private final List<String> ignoreFiles;
    private final List<IVersionable> contentList;
    private final Map<String, IComponent> componentMap;
    private final Map<String, IVersionable> folderMap;
    private final Map<String, Map<String, IVersionable>> componentFolderMap;
    private final Map<String, IPackagingItem> packagingLanguageMap;
    private final Map<String, IPackagingFmidItem> packagingFmidItemMap;
    private final Map<String, Map<String, Integer>> packagingRelfileMap;
    private final Map<String, Map<String, Set<Mcstype>>> packagingRelfileTypeMap;
    private final Map<String, Map<String, IPackagingItem>> packagingFolderMap = new HashMap<String, Map<String, IPackagingItem>>();
    private final List<IPackagingItem> packagingItemList = new ArrayList<IPackagingItem>();

    public PackagingContent(ITeamRepository repository, IWorkspaceConnection wsConnection, List<String> ignoreFiles, List<IVersionable> contentList, Map<String, IComponent> componentMap, Map<String, IVersionable> folderMap, Map<String, Map<String, IVersionable>> componentFolderMap, Map<String, IPackagingDataset> packagingDatasetMap, Map<String, IPackagingItem> packagingLanguageMap, Map<String, IPackagingFmidItem> packagingFmidItemMap, Map<String, Map<String, Integer>> packagingRelfileMap, Map<String, Map<String, Set<Mcstype>>> packagingRelfileTypeMap, IProgressMonitor monitor, IDebugger dbg) {
        this.repository = repository;
        this.wsConnection = wsConnection;
        this.ignoreFiles = ignoreFiles;
        this.contentList = contentList;
        this.componentMap = componentMap;
        this.folderMap = folderMap;
        this.componentFolderMap = componentFolderMap;
        this.packagingLanguageMap = packagingLanguageMap;
        this.packagingFmidItemMap = packagingFmidItemMap;
        this.packagingRelfileMap = packagingRelfileMap;
        this.packagingRelfileTypeMap = packagingRelfileTypeMap;
        this.packagingTools = new PackagingTools(packagingDatasetMap, true, dbg);
        this.monitor = monitor;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isFlow()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final void createPackagingFolderMap() throws TeamRepositoryException {
        String method = new MethodName(){}.getName();
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
        for (String componentKey : this.componentMap.keySet()) {
            String componentName = this.componentMap.get(componentKey).getName();
            String projectName = "";
            for (IVersionable versionable : this.componentFolderMap.get(componentKey).values()) {
                IPackagingItem packagingLanguage;
                if (versionable.getName().equalsIgnoreCase("zOSsrc")) continue;
                IFolder parent = this.folderMap.containsKey(this.getUuid((IItemHandle)versionable.getParent())) ? (IFolder)this.folderMap.get(this.getUuid((IItemHandle)versionable.getParent())) : SCMFileUtils.getFolder((IWorkspaceConnection)this.wsConnection, (IComponentHandle)((IComponentHandle)this.componentMap.get(componentKey)), (IFolderHandle)versionable.getParent());
                if (parent.getName().equals("")) {
                    projectName = versionable.getName();
                    continue;
                }
                if (!parent.getName().equals("zOSsrc")) {
                    if (!this.dbg.isDebug()) continue;
                    Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, NLS.bind((String)Messages.zPackaging_CONTENT_SKIPPING_FOLDER, (Object)versionable.getName(), (Object[])new Object[0])});
                    continue;
                }
                IFolder folder = (IFolder)versionable;
                String folderName = versionable.getName();
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                sb.append(componentName);
                sb.append("]");
                sb.append("[");
                sb.append(projectName);
                sb.append("]");
                sb.append("[");
                sb.append(folderName);
                sb.append("]");
                String folderNameExtended = sb.toString();
                HashMap<String, IPackagingItem> folderLanguageMap = new HashMap<String, IPackagingItem>();
                HashMap<String, PackagingItemFolder> folderPackagingItemMap = new HashMap<String, PackagingItemFolder>();
                if (this.packagingLanguageMap.containsKey(folderName.toUpperCase())) {
                    folderLanguageMap.put(folderName.toUpperCase(), this.packagingLanguageMap.get(folderName.toUpperCase()));
                }
                for (String languageKey : this.packagingLanguageMap.keySet()) {
                    packagingLanguage = this.packagingLanguageMap.get(languageKey);
                    if (!Verification.isNonBlank((String)packagingLanguage.getFolders())) continue;
                    for (String languageFolder : Arrays.asList(packagingLanguage.getFolders().split(","))) {
                        if (!languageFolder.equalsIgnoreCase(folderName) || languageKey.equalsIgnoreCase(folderName)) continue;
                        folderLanguageMap.put(languageKey, packagingLanguage);
                    }
                }
                for (String languageFolder : folderLanguageMap.keySet()) {
                    packagingLanguage = (IPackagingItem)folderLanguageMap.get(languageFolder);
                    PackagingItemFolder packagingFolder = (PackagingItemFolder)this.packagingTools.createPackagingFolderItem((IVersionable)folder, this.repository, packagingLanguage);
                    packagingFolder.setComponentHandle((IComponentHandle)this.componentMap.get(componentKey));
                    packagingFolder.setComponentName(componentName);
                    packagingFolder.setFolderVersionable(versionable);
                    packagingFolder.setFolderName(folderName);
                    packagingFolder.setFolderNameExtended(folderNameExtended);
                    packagingFolder.setProjectName(projectName);
                    folderPackagingItemMap.put(languageFolder, packagingFolder);
                }
                this.packagingFolderMap.put(folder.getItemId().getUuidValue(), folderPackagingItemMap);
            }
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
    }

    public final void createPackagingFileList() throws TeamRepositoryException {
        String method = new MethodName(){}.getName();
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
        for (IVersionable versionable : this.contentList) {
            IFileItem file = (IFileItem)versionable;
            IFolderHandle parent = file.getParent();
            IPackagingItem packagingFolder = null;
            String fileName = versionable.getName();
            if (parent == null) continue;
            if (!this.packagingFolderMap.containsKey(parent.getItemId().getUuidValue())) {
                if (!this.dbg.isDebug()) continue;
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, NLS.bind((String)Messages.zPackaging_CONTENT_SKIPPING_FILE_NOZOSSRC, (Object)versionable.getName(), (Object[])new Object[0])});
                continue;
            }
            if (file.getUserProperties().containsKey("team.enterprise.language.definition")) {
                String languageUuid = (String)file.getUserProperties().get("team.enterprise.language.definition");
                if (this.packagingFolderMap.get(parent.getItemId().getUuidValue()).containsKey(languageUuid)) {
                    packagingFolder = this.packagingFolderMap.get(parent.getItemId().getUuidValue()).get(languageUuid);
                }
                if (packagingFolder == null && this.packagingLanguageMap.containsKey(FileUtilities.toFileTypeUpperCase((String)fileName))) {
                    packagingFolder = this.packagingLanguageMap.get(languageUuid);
                }
            } else {
                String fileType = FileUtilities.toFileTypeUpperCase((String)fileName);
                if (this.packagingFolderMap.get(parent.getItemId().getUuidValue()).containsKey(fileType)) {
                    packagingFolder = this.packagingFolderMap.get(parent.getItemId().getUuidValue()).get(fileType);
                }
                if (packagingFolder == null && this.packagingLanguageMap.containsKey(FileUtilities.toFileTypeUpperCase((String)fileName))) {
                    packagingFolder = this.packagingLanguageMap.get(fileType);
                }
            }
            if (packagingFolder == null) {
                if (!this.dbg.isDebug()) continue;
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, NLS.bind((String)Messages.zPackaging_CONTENT_SKIPPING_FILE_NOFOLDER, (Object)versionable.getName(), (Object[])new Object[0])});
                continue;
            }
            PackagingItemFile packagingFile = (PackagingItemFile)this.packagingTools.createPackagingFileItem((IVersionable)file, this.repository, packagingFolder);
            packagingFile.setFileVersionable(versionable);
            packagingFile.setFileName(fileName);
            for (IPackagingDetail detail : packagingFile.getDetails()) {
                if (!detail.hasDistlib()) continue;
                String fmidItem = detail.hasFmidoverride() ? detail.getFmidoverride().getUuid() : packagingFile.getFmid().getUuid();
                String distlibItem = detail.getDistlib().getUuid();
                detail.setRelfile(this.packagingRelfileMap.get(fmidItem).get(distlibItem));
                detail.setPartStatus(PartStatus.ADD_LITERAL);
                if (this.packagingRelfileTypeMap.get(fmidItem).get(distlibItem).contains(detail.getMcstype())) continue;
                this.packagingRelfileTypeMap.get(fmidItem).get(distlibItem).add(detail.getMcstype());
            }
            this.packagingItemList.add((IPackagingItem)packagingFile);
            if (!this.packagingFmidItemMap.get(packagingFile.getFmid().getUuid()).isReferenced() && packagingFile.isShipped() && !packagingFile.isIgnore() && !packagingFile.getItemtype().equals(Itemtype.JCLIN_LITERAL)) {
                this.packagingFmidItemMap.get(packagingFile.getFmid().getUuid()).setReferenced(true);
            }
            if (packagingFile.isJclin()) {
                this.packagingFmidItemMap.get(packagingFile.getFmid().getUuid()).setJclinId(FileUtilities.toFileNameUpperCase((String)packagingFile.getFileName()));
                this.packagingFmidItemMap.get(packagingFile.getFmid().getUuid()).setJclinOverride(true);
            }
            if (!Verification.isNonEmpty(this.ignoreFiles) || !this.ignoreFiles.contains(packagingFile.getFileName())) continue;
            packagingFile.setIgnore(Boolean.valueOf(true));
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
    }

    public final Map<String, Map<String, IPackagingItem>> getPackagingFolderMap() {
        return this.packagingFolderMap;
    }

    public final List<IPackagingItem> getPackagingItemList() {
        return this.packagingItemList;
    }

    public final List<IPackagingItem> getPackagingItemListSorted() {
        ArrayList<IPackagingItem> result = new ArrayList<IPackagingItem>(this.packagingItemList);
        Collections.sort(result, new Comparator<IPackagingItem>(){

            @Override
            public int compare(IPackagingItem o1, IPackagingItem o2) {
                String key1 = String.valueOf(o1.getFileName()) + "/" + o1.toFolderPath();
                String key2 = String.valueOf(o2.getFileName()) + "/" + o2.toFolderPath();
                return key1.compareTo(key2);
            }
        });
        return result;
    }

    private final String getUuid(IItemHandle itemHandle) {
        return itemHandle.getItemId().getUuidValue();
    }
}

